/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.adapters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.SubgraphExtent;
import org.simantics.db.layer0.adapter.impl.DefaultCopyHandler;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ModelingUtils;
import org.simantics.structural.stubs.StructuralResource2;

public class CompositeCopyHandler
extends DefaultCopyHandler {
    public CompositeCopyHandler(Resource composite) {
        super(composite);
    }

    public CompositeCopyHandler(Collection<Resource> composites) {
        super(composites);
    }

    protected TransferableGraphConfiguration2 createConfiguration(ReadGraph graph, boolean cut) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        StructuralResource2 SR = StructuralResource2.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Set resourceSet = this.resources instanceof Set ? (Set)this.resources : new HashSet(this.resources);
        HashSet<Resource> exclusions = new HashSet<Resource>();
        HashSet externals = new HashSet();
        ArrayList<TransferableGraphConfiguration2.RootSpec> roots = new ArrayList<TransferableGraphConfiguration2.RootSpec>();
        for (Resource resource : this.resources) {
            for (Resource diagram : graph.getObjects(resource, MOD.CompositeToDiagram)) {
                for (Resource flag : (Collection)graph.syncRequest((Read)new ObjectsWithType(diagram, L0.ConsistsOf, DIA.Flag))) {
                    for (Resource join : graph.getObjects(flag, DIA.FlagIsJoinedBy)) {
                        for (Resource comp : graph.getObjects(join, SR.JoinsComposite)) {
                            if (resourceSet.contains(comp)) continue;
                            exclusions.add(join);
                        }
                        for (Resource flag2 : graph.getObjects(join, DIA.JoinsFlag)) {
                            Resource comp;
                            Resource diagram2 = graph.getPossibleObject(flag2, L0.PartOf);
                            if (diagram2 == null || resourceSet.contains(comp = graph.getPossibleObject(diagram2, MOD.DiagramToComposite))) continue;
                            exclusions.add(join);
                        }
                    }
                }
                for (Resource ref : (Collection)graph.syncRequest((Read)new ObjectsWithType(diagram, L0.ConsistsOf, DIA.Monitor))) {
                    for (Resource monitoredComponent : graph.getObjects(ref, DIA.HasMonitorComponent)) {
                        Resource monitoredComponentComposite = graph.getPossibleObject(monitoredComponent, L0.PartOf);
                        if (monitoredComponentComposite == null || resourceSet.contains(monitoredComponentComposite)) continue;
                        exclusions.add(monitoredComponent);
                    }
                }
            }
            for (Resource ref : (Collection)graph.syncRequest((Read)new ObjectsWithType(resource, L0.ConsistsOf, SR.Component))) {
                for (Resource monitor : graph.getObjects(ref, DIA.HasMonitorComponent_Inverse)) {
                    Resource monitorComposite;
                    Resource monitorDiagram = graph.getPossibleObject(monitor, L0.PartOf);
                    if (monitorDiagram == null || (monitorComposite = graph.getPossibleObject(monitorDiagram, MOD.DiagramToComposite)) == null || resourceSet.contains(monitorComposite)) continue;
                    exclusions.add(monitor);
                }
            }
            ModelingUtils.CompositeInfo info = ModelingUtils.CompositeInfo.fromResource(graph, resource);
            roots.add(new TransferableGraphConfiguration2.RootSpec(resource, info.getTGName(), true));
            Resource id = graph.getPossibleObject(resource, L0.identifier);
            if (id != null) {
                exclusions.add(id);
            }
            for (Resource child : (Collection)graph.sync((ReadInterface)new ObjectsWithType(resource, L0.ConsistsOf, SR.Component))) {
                ModelingUtils.DiagramComponentInfo cinfo = ModelingUtils.DiagramComponentInfo.fromResource(graph, info, child);
                id = graph.getPossibleObject(child, L0.identifier);
                if (id != null) {
                    exclusions.add(id);
                }
                roots.add(new TransferableGraphConfiguration2.RootSpec(child, cinfo.getTGName(info), true));
            }
        }
        Resource model = (Resource)graph.syncRequest((Read)new PossibleIndexRoot((Resource)this.resources.iterator().next()));
        if (model == null) {
            throw new DatabaseException("Composite is not part of any index root");
        }
        roots.add(new TransferableGraphConfiguration2.RootSpec(model, "%model", false));
        TransferableGraphConfiguration2 config = TransferableGraphConfiguration2.createWithNames2((RequestProcessor)graph, roots, exclusions, (boolean)true, (boolean)false);
        for (Resource external : externals) {
            config.preStatus.put(external, SubgraphExtent.ExtentStatus.EXTERNAL);
        }
        return config;
    }
}

