/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.db;

import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.WriteBindings;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.db.service.ClusterBuilder2;
import org.simantics.db.service.ClusterBuilderFactory;
import org.simantics.db.service.ClusteringSupport;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.graph.db.CoreInitialization;
import org.simantics.graph.db.IImportAdvisor2;
import org.simantics.graph.db.MissingDependencyException;
import org.simantics.graph.db.TransferableGraphImporter;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.IdentityDefinition;
import org.simantics.graph.representation.Internal;
import org.simantics.graph.representation.Optional;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraphUtils;
import org.simantics.graph.utils.TGResourceUtil;

public class StreamingTransferableGraphImportProcess
implements TransferableGraphImporter {
    public static String LOG_FILE = "transferableGraphs.log";
    private static final boolean LOG = false;
    static DataOutput log;
    Resource indexRoot;
    TransferableGraphSource tg;
    VirtualGraph vg;
    IImportAdvisor2 advisor;
    ClusterBuilder2 builder;
    final TGResourceUtil resourceUtil = new TGResourceUtil();
    int[] handles;
    Set<String> missingExternals = new HashSet<String>();
    int resourceCount;
    Identity[] identities;
    TreeMap<String, Variant> extensions;
    Resource RootLibrary;
    Resource String;
    Resource Library;
    Resource InstanceOf;
    Resource ConsistsOf;
    Resource PartOf;
    Resource HasName;
    Resource NameOf;

    private static void log(String line) {
    }

    public StreamingTransferableGraphImportProcess(Session session, VirtualGraph vg, TransferableGraphSource tg, IImportAdvisor2 advisor) {
        this.tg = tg;
        this.vg = vg;
        this.advisor = advisor;
    }

    public void readIdentities(ReadGraph g) throws Exception {
        this.extensions = this.tg.getExtensions();
        this.resourceCount = this.tg.getResourceCount();
        this.identities = new Identity[this.tg.getIdentityCount()];
        this.tg.forIdentities(g, new TransferableGraphSource.TransferableGraphSourceProcedure<Identity>(){
            int counter = 0;

            @Override
            public void execute(Identity value) throws Exception {
                StreamingTransferableGraphImportProcess.this.identities[this.counter++] = value;
            }
        });
    }

    public void findBuiltins(WriteOnlyGraph g) throws DatabaseException {
        this.RootLibrary = g.getBuiltin("http:/");
        this.String = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "String");
        this.Library = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "Library");
        this.InstanceOf = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "InstanceOf");
        this.ConsistsOf = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "ConsistsOf");
        this.PartOf = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "PartOf");
        this.HasName = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "HasName");
        this.NameOf = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "NameOf");
    }

    public void findBuiltins(ReadGraph g) throws DatabaseException {
        this.RootLibrary = g.getBuiltin("http:/");
        this.String = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "String");
        this.Library = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "Library");
        this.InstanceOf = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "InstanceOf");
        this.ConsistsOf = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "ConsistsOf");
        this.PartOf = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "PartOf");
        this.HasName = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "HasName");
        this.NameOf = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "NameOf");
    }

    void addMissing(String external) {
        HashSet<String> removals = new HashSet<String>();
        for (String ext : this.missingExternals) {
            if (!ext.startsWith(external)) continue;
            return;
        }
        for (String ext : this.missingExternals) {
            if (!external.startsWith(ext)) continue;
            removals.add(ext);
        }
        this.missingExternals.removeAll(removals);
        this.missingExternals.add(external);
    }

    void prepare(ReadGraph graph) throws Exception {
        this.findBuiltins(graph);
        this.readIdentities(graph);
        ClusterBuilderFactory factory = (ClusterBuilderFactory)graph.getService(ClusterBuilderFactory.class);
        ClusterBuilder2 builder = factory.create(this.vg, false);
        this.handles = new int[this.resourceCount];
        Identity[] identityArray = this.identities;
        int n = this.identities.length;
        int n2 = 0;
        while (n2 < n) {
            External def;
            Identity identity = identityArray[n2];
            IdentityDefinition definition = identity.definition;
            if (definition instanceof External) {
                def = (External)definition;
                if (def.parent == -1) {
                    this.handles[identity.resource] = builder.handle(this.RootLibrary);
                } else if ("@inverse".equals(def.name)) {
                    int child;
                    int parent = this.handles[def.parent];
                    this.handles[identity.resource] = child = builder.handle(graph.getInverse(builder.resource(parent)));
                } else {
                    Resource parent;
                    int handle = this.handles[def.parent];
                    Resource resource = parent = handle != 0 ? builder.resource(handle) : null;
                    if (parent != null) {
                        Map childMap = (Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(parent), (AsyncProcedure)new TransientCacheAsyncListener());
                        Resource child = (Resource)childMap.get(def.name);
                        if (child == null) {
                            this.addMissing(java.lang.String.valueOf(graph.getURI(parent)) + "/" + def.name);
                        } else {
                            this.handles[identity.resource] = builder.handle(child);
                        }
                    } else {
                        this.addMissing(java.lang.String.valueOf(TransferableGraphUtils.getURI((int)this.resourceCount, (Identity[])this.identities, (int)def.parent)) + "/" + def.name);
                    }
                }
            } else if (!(definition instanceof Internal)) {
                if (definition instanceof Root) {
                    Root root = (Root)definition;
                    if (root.name.equals("")) {
                        this.handles[identity.resource] = builder.handle(this.RootLibrary);
                    } else {
                        Resource existing = this.advisor.analyzeRoot(graph, root);
                        if (existing != null) {
                            this.handles[identity.resource] = builder.handle(existing);
                        }
                    }
                } else if (definition instanceof Optional) {
                    def = (External)definition;
                    Resource parent = builder.resource(this.handles[def.parent]);
                    if (parent != null) {
                        this.handles[identity.resource] = builder.handle((Resource)((Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(parent))).get(def.name));
                    }
                }
            }
            ++n2;
        }
        if (!this.missingExternals.isEmpty()) {
            throw new MissingDependencyException(this);
        }
    }

    @Override
    public Resource createChild(WriteOnlyGraph graph, Resource parent, Resource child, String name) throws DatabaseException {
        if (child == null) {
            child = graph.newResource();
        }
        Resource nameResource = graph.newResource();
        graph.claim(nameResource, this.InstanceOf, null, this.String);
        graph.claimValue(nameResource, (Object)name, WriteBindings.STRING);
        graph.claim(child, this.HasName, this.NameOf, nameResource);
        return child;
    }

    int[] getClustering() {
        Variant v = this.extensions.get("clustering");
        if (v == null) {
            return null;
        }
        try {
            return (int[])v.getValue((Binding)Bindings.INT_ARRAY);
        }
        catch (AdaptException e) {
            Logger.defaultLogError((Throwable)e);
            return null;
        }
    }

    int[] getClusterSets() {
        Variant v = this.extensions.get("clusterSets");
        if (v == null) {
            return null;
        }
        try {
            return (int[])v.getValue((Binding)Bindings.INT_ARRAY);
        }
        catch (AdaptException e) {
            Logger.defaultLogError((Throwable)e);
            return null;
        }
    }

    boolean needTranslation(Datatype type) {
        return this.resourceUtil.mayHaveResource(type);
    }

    void findClusterSet(WriteOnlyGraph graph, Resource rootLibrary, Resource indexRoot, int[] clustering, int[] clusterSets, long[] clusters, int id) throws DatabaseException {
        ClusteringSupport support = (ClusteringSupport)graph.getService(ClusteringSupport.class);
        if (id == -1 || id == -2) {
            return;
        }
        int pos = 0;
        int index = 0;
        while (index < clustering.length) {
            if (id < (pos += clustering[index])) {
                int cs = clusterSets[index];
                if (this.handles[id] == 0) {
                    int csHandle = 0;
                    if (cs == -1) {
                        csHandle = this.builder.handle(rootLibrary);
                    } else if (cs == -2) {
                        csHandle = this.builder.handle(indexRoot);
                    } else {
                        this.findClusterSet(graph, rootLibrary, indexRoot, clustering, clusterSets, clusters, cs);
                        csHandle = this.handles[cs];
                    }
                    if (clusters[index] != 0L) {
                        this.builder.selectCluster(clusters[index]);
                    } else if (cs >= 0) {
                        this.builder.newCluster(csHandle);
                    }
                    this.handles[id] = this.builder.newResource(csHandle);
                    clusters[index] = support.getCluster(this.builder.resource(this.handles[id]));
                    this.builder.createClusterSet(this.handles[id]);
                }
                return;
            }
            ++index;
        }
    }

    void write(final WriteOnlyGraph graph) throws Exception {
        SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        ClusterBuilderFactory factory = (ClusterBuilderFactory)graph.getService(ClusterBuilderFactory.class);
        if (this.advisor instanceof IImportAdvisor2) {
            boolean allowImmutable = this.advisor.allowImmutableModifications();
            this.builder = factory.create(this.vg, allowImmutable);
        } else {
            this.builder = factory.create(this.vg, false);
        }
        final int[] handles = this.handles;
        int[] clustering = this.getClustering();
        if (clustering != null) {
            int c;
            int[] clusterSets = this.getClusterSets();
            if (clusterSets != null) {
                assert (clustering.length == clusterSets.length);
                long[] clusters = new long[clustering.length];
                int i = 0;
                while (i < clusterSets.length) {
                    this.findClusterSet(graph, graph.getRootLibrary(), this.indexRoot, clustering, clusterSets, clusters, clusterSets[i]);
                    ++i;
                }
                i = 0;
                int j = 0;
                while (j < clustering.length) {
                    c = clustering[j];
                    int s = clusterSets[j];
                    int setHandle = 0;
                    setHandle = s == -1 ? this.builder.handle(graph.getRootLibrary()) : (s == -2 ? this.builder.handle(this.indexRoot) : handles[s]);
                    if (clusters[j] != 0L) {
                        this.builder.selectCluster(clusters[j]);
                    } else if (s >= 0) {
                        this.builder.newCluster(setHandle);
                    }
                    int r = 0;
                    while (r < c) {
                        if (handles[i] == 0) {
                            handles[i] = this.builder.newResource();
                        }
                        ++r;
                        ++i;
                    }
                    ++j;
                }
                while (i < handles.length) {
                    if (handles[i] == 0) {
                        handles[i] = this.builder.newResource();
                    }
                    ++i;
                }
            } else {
                int i = 0;
                int[] s = clustering;
                c = clustering.length;
                int n = 0;
                while (n < c) {
                    int c2 = s[n];
                    this.builder.newCluster();
                    int r = 0;
                    while (r < c2) {
                        if (handles[i] == 0) {
                            handles[i] = this.builder.newResource();
                        }
                        ++r;
                        ++i;
                    }
                    ++n;
                }
                while (i < handles.length) {
                    if (handles[i] == 0) {
                        handles[i] = this.builder.newResource();
                    }
                    ++i;
                }
            }
        } else {
            int i = 0;
            while (i < handles.length) {
                if (handles[i] == 0) {
                    handles[i] = this.builder.newResource();
                }
                ++i;
            }
        }
        Identity[] identityArray = this.identities;
        int n = this.identities.length;
        int n2 = 0;
        while (n2 < n) {
            Identity identity = identityArray[n2];
            IdentityDefinition definition = identity.definition;
            if (!(definition instanceof External)) {
                if (definition instanceof Internal) {
                    Internal def = (Internal)definition;
                    handles[identity.resource] = handles[identity.resource] != 0 ? this.builder.handle(this.advisor.createChild(graph, this, this.builder.resource(handles[def.parent]), this.builder.resource(handles[identity.resource]), def.name)) : this.builder.handle(this.advisor.createChild(graph, this, this.builder.resource(handles[def.parent]), null, def.name));
                } else if (definition instanceof Root) {
                    Root root = (Root)definition;
                    handles[identity.resource] = handles[identity.resource] != 0 ? this.builder.handle(this.advisor.createRoot(graph, root, this.builder.resource(handles[identity.resource]))) : this.builder.handle(this.advisor.createRoot(graph, root, null));
                } else if (definition instanceof Optional) {
                    Optional def = (Optional)definition;
                    if (handles[identity.resource] != 0) {
                        Resource child = this.advisor.createChild(graph, this, this.builder.resource(handles[def.parent]), this.builder.resource(handles[identity.resource]), def.name);
                        graph.claim(child, this.InstanceOf, null, this.Library);
                        handles[identity.resource] = this.builder.handle(child);
                    } else {
                        Resource child = this.advisor.createChild(graph, this, this.builder.resource(handles[def.parent]), null, def.name);
                        graph.claim(child, this.InstanceOf, null, this.Library);
                        handles[identity.resource] = this.builder.handle(child);
                    }
                }
            }
            ++n2;
        }
        this.tg.getStatementCount();
        this.tg.forStatements(null, new TransferableGraphSource.TransferableGraphSourceProcedure<int[]>(){

            @Override
            public void execute(int[] value) throws Exception {
                int sub = value[0];
                int pred = value[1];
                int inv = value[2];
                int obj = value[3];
                int subject = handles[sub];
                int predicate = handles[pred];
                int object = handles[obj];
                StreamingTransferableGraphImportProcess.this.builder.addStatement(graph, subject, predicate, object);
                if (inv >= 0) {
                    int inverse = handles[inv];
                    StreamingTransferableGraphImportProcess.this.builder.addStatement(graph, object, inverse, subject);
                }
            }
        });
        this.tg.getValueCount();
        class ValueProcedure
        extends InputStream
        implements TransferableGraphSource.TransferableGraphSourceValueProcedure {
            private TGResourceUtil util = new TGResourceUtil();
            private InputStream source;
            private final /* synthetic */ int[] val$handles;
            private final /* synthetic */ SerialisationSupport val$ss;

            ValueProcedure(int[] nArray, SerialisationSupport serialisationSupport) {
                this.val$handles = nArray;
                this.val$ss = serialisationSupport;
            }

            @Override
            public void execute(int _resource, Datatype type, InputStream stream) throws Exception {
                this.source = stream;
                int file = _resource & Integer.MIN_VALUE;
                int resource = _resource & Integer.MAX_VALUE;
                Binding binding = Bindings.getBinding((Datatype)type);
                Serializer s = Bindings.getSerializer((Binding)binding);
                StreamingTransferableGraphImportProcess.this.builder.beginValue(this.val$handles[resource]);
                if (this.util.mayHaveResource(type)) {
                    byte[] bytes;
                    Object value = s.deserialize(stream);
                    this.util.adaptValue(binding, value, new TGResourceUtil.LongAdapter(){

                        public long adapt(long in) {
                            try {
                                return val$ss.getRandomAccessId(val$handles[(int)in]);
                            }
                            catch (DatabaseException e) {
                                throw new IllegalStateException(e);
                            }
                        }
                    });
                    byte[] byArray = bytes = s.serialize(value);
                    int n = bytes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int b = byArray[n2];
                        int val = b;
                        if (val < 0) {
                            val += 256;
                        }
                        StreamingTransferableGraphImportProcess.this.builder.appendValue(val);
                        ++n2;
                    }
                } else {
                    s.skip((InputStream)this);
                }
                StreamingTransferableGraphImportProcess.this.builder.endValue();
            }

            @Override
            public int read() throws IOException {
                int value = this.source.read();
                try {
                    StreamingTransferableGraphImportProcess.this.builder.appendValue(value);
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                }
                return value;
            }
        }
        this.tg.forValues2(null, new ValueProcedure(handles, ss));
    }

    @Override
    public long[] getResourceIds(SerialisationSupport serializer) throws DatabaseException {
        int count = this.handles.length;
        long[] resourceIds = new long[count];
        int i = 0;
        while (i < count) {
            resourceIds[i] = serializer.getRandomAccessId(this.handles[i]);
            ++i;
        }
        return resourceIds;
    }
}

