/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.datatypes.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.RuntimeBindingConstructionException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.datatypes.DatatypeResource;
import org.simantics.datatypes.utils.BTreeContentBean;
import org.simantics.datatypes.utils.BTreeContentBinding;
import org.simantics.datatypes.utils.BTreeContentManager;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.primitiverequest.RelatedValue;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.layer0.Layer0;
import org.simantics.scl.runtime.tuple.Tuple2;
import org.simantics.utils.datastructures.Pair;

public final class BTreeUtils
implements BTreeContentManager {
    private final Resource tree;
    private final Resource ownerRelation;
    public final Binding CONTENT_BEAN_BINDING;
    public final DatatypeResource DATA;

    public BTreeUtils(ReadGraph graph, Resource tree) throws DatabaseException {
        try {
            this.CONTENT_BEAN_BINDING = new BTreeContentBinding((SerialisationSupport)graph.getService(SerialisationSupport.class));
            this.DATA = DatatypeResource.getInstance((ReadGraph)graph);
            this.tree = tree;
            this.ownerRelation = graph.getPossibleObject(tree, this.DATA.BTree_HasOwnerRelation);
        }
        catch (RuntimeBindingConstructionException e) {
            Logger.defaultLogError((Throwable)e);
            throw new DatabaseException((Throwable)e);
        }
    }

    public Resource getTree() {
        return this.tree;
    }

    public static Resource create(WriteGraph graph, Resource ownerRelation, int t) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DatatypeResource DATA = DatatypeResource.getInstance((ReadGraph)graph);
        Resource tree = graph.newResource();
        graph.newClusterSet(tree);
        graph.setClusterSet4NewResource(tree);
        graph.claim(tree, L0.InstanceOf, null, DATA.BTree);
        if (ownerRelation != null) {
            graph.claim(tree, DATA.BTree_HasOwnerRelation, DATA.BTree_HasOwnerRelation_Inverse, ownerRelation);
        }
        graph.claimLiteral(tree, DATA.BTree_t, (Object)t, (Binding)Bindings.INTEGER);
        graph.claimLiteral(tree, DATA.BTree_mod, (Object)0L, (Binding)Bindings.LONG);
        BTreeUtils utils = new BTreeUtils((ReadGraph)graph, tree);
        Resource node = utils.createNode(graph, utils, DATA.BTreeNode, t);
        graph.claim(tree, DATA.BTree_root, DATA.BTree_root_Inverse, node);
        utils.setOwner(graph, node, tree, true);
        return tree;
    }

    public void insert(WriteGraph graph, Variant k, Resource v) throws DatabaseException {
        graph.setClusterSet4NewResource(this.tree);
        Resource r = this.getRoot((ReadGraph)graph);
        int t = this.getDegree((ReadGraph)graph);
        this.insertImpl(graph, this, r, t, k, v);
    }

    public void insertAll(WriteGraph graph, Collection<Pair<Variant, Resource>> values) throws DatabaseException {
        graph.setClusterSet4NewResource(this.tree);
        Resource r = this.getRoot((ReadGraph)graph);
        int t = this.getDegree((ReadGraph)graph);
        BatchContentManager cm = new BatchContentManager(this);
        for (Pair<Variant, Resource> entry : values) {
            this.insertImpl(graph, cm, r, t, (Variant)entry.first, (Resource)entry.second);
        }
        cm.apply(graph);
    }

    public Resource search(ReadGraph graph, Variant k) throws DatabaseException {
        Resource r = this.getRoot(graph);
        return this.searchNode(graph, r, k);
    }

    private int findKey(ReadGraph graph, BTreeContentManager manager, BTreeContentBean bean, Variant k) throws DatabaseException {
        int idx = 0;
        while (idx < bean.n && bean.key[idx].v.compareTo(k) < 0) {
            ++idx;
        }
        return idx;
    }

    private void insertImpl(WriteGraph graph, BTreeContentManager manager, Resource r, int t, Variant k, Resource v) throws DatabaseException {
        BTreeContentBean rContent = manager.getContentBean((ReadGraph)graph, r);
        if (rContent.n == 2 * t - 1) {
            Resource s = this.allocateNode(graph, manager, t);
            BTreeContentBean sContent = manager.getContentBean((ReadGraph)graph, s);
            this.setRoot(graph, s);
            this.setOwner(graph, s, this.tree, true);
            sContent.leaf = false;
            sContent.n = 0;
            sContent.c[0].r = r;
            this.setOwner(graph, r, s, true);
            manager.setContentBean(graph, s, sContent);
            this.splitChild(graph, manager, t, s, 1, r);
            this.insertNonfull(graph, manager, t, s, k, v);
        } else {
            this.insertNonfull(graph, manager, t, r, k, v);
        }
    }

    public void remove(WriteGraph graph, Variant k) throws DatabaseException {
        DatatypeResource DATA = DatatypeResource.getInstance((ReadGraph)graph);
        Resource r = this.getRoot((ReadGraph)graph);
        int t = (Integer)graph.getRelatedValue(this.tree, DATA.BTree_t, (Binding)Bindings.INTEGER);
        BTreeContentBean bean = this.getContentBean((ReadGraph)graph, r);
        Resource removedResource = this.removeImpl(graph, this, t, r, bean, k);
        this.removeOwner(graph, removedResource, false);
        if (bean.n == 0 && !bean.leaf) {
            this.setRoot(graph, bean.c[0].r);
            this.setOwner(graph, bean.c[0].r, this.tree, true);
        }
    }

    public Resource removeImpl(WriteGraph graph, BTreeContentManager manager, int t, Resource r, BTreeContentBean bean, Variant k) throws DatabaseException {
        int idx = this.findKey((ReadGraph)graph, manager, bean, k);
        if (idx < bean.n && bean.key[idx].v.equals((Object)k)) {
            if (bean.leaf) {
                this.removeFromLeaf(graph, manager, r, bean, idx);
            } else {
                this.removeFromNonLeaf(graph, manager, r, bean, t, idx);
            }
            return bean.value[idx].r;
        }
        if (bean.leaf) {
            throw new DatabaseException("The key " + k + " does not exist");
        }
        boolean flag = idx == bean.n;
        BTreeContentBean cContent = manager.getContentBean((ReadGraph)graph, bean.c[idx].r);
        if (cContent.n < t) {
            this.fill(graph, manager, r, bean, t, idx);
        }
        if (flag && idx > bean.n) {
            return this.removeImpl(graph, manager, t, bean.c[idx - 1].r, manager.getContentBean((ReadGraph)graph, bean.c[idx - 1].r), k);
        }
        return this.removeImpl(graph, manager, t, bean.c[idx].r, cContent, k);
    }

    Pair<Variant, Resource> getPred(ReadGraph graph, BTreeContentManager manager, BTreeContentBean bean, int idx) throws DatabaseException {
        bean = manager.getContentBean(graph, bean.c[idx].r);
        while (!bean.leaf) {
            bean = manager.getContentBean(graph, bean.c[bean.n].r);
        }
        return new Pair((Object)bean.key[bean.n - 1].v, (Object)bean.value[bean.n - 1].r);
    }

    Pair<Variant, Resource> getSucc(ReadGraph graph, BTreeContentManager manager, BTreeContentBean bean, int idx) throws DatabaseException {
        bean = manager.getContentBean(graph, bean.c[idx + 1].r);
        while (!bean.leaf) {
            bean = manager.getContentBean(graph, bean.c[0].r);
        }
        return new Pair((Object)bean.key[0].v, (Object)bean.value[0].r);
    }

    void fill(WriteGraph graph, BTreeContentManager manager, Resource r, BTreeContentBean bean, int t, int idx) throws DatabaseException {
        BTreeContentBean cContent;
        if (idx != 0) {
            cContent = manager.getContentBean((ReadGraph)graph, bean.c[idx - 1].r);
            if (cContent.n >= t) {
                this.borrowFromPrev(graph, manager, r, bean, idx);
                return;
            }
        }
        if (idx != bean.n) {
            cContent = manager.getContentBean((ReadGraph)graph, bean.c[idx + 1].r);
            if (cContent.n >= t) {
                this.borrowFromNext(graph, manager, r, bean, idx);
                return;
            }
        }
        if (idx != bean.n) {
            this.merge(graph, manager, r, bean, t, idx);
        } else {
            this.merge(graph, manager, r, bean, t, idx - 1);
        }
    }

    void borrowFromPrev(WriteGraph graph, BTreeContentManager manager, Resource r, BTreeContentBean bean, int idx) throws DatabaseException {
        BTreeContentBean childContent = manager.getContentBean((ReadGraph)graph, bean.c[idx].r);
        BTreeContentBean siblingContent = manager.getContentBean((ReadGraph)graph, bean.c[idx - 1].r);
        int i = childContent.n - 1;
        while (i >= 0) {
            childContent.key[i + 1].v = childContent.key[i].v;
            childContent.value[i + 1].r = childContent.value[i].r;
            --i;
        }
        if (!childContent.leaf) {
            i = childContent.n;
            while (i >= 0) {
                childContent.c[i + 1].r = childContent.c[i].r;
                this.setOwner(graph, childContent.c[i + 1].r, bean.c[idx].r, true);
                --i;
            }
        }
        childContent.key[0].v = bean.key[idx - 1].v;
        childContent.value[0].r = bean.value[idx - 1].r;
        if (!bean.leaf) {
            childContent.c[0].r = siblingContent.c[siblingContent.n].r;
            this.setOwner(graph, childContent.c[0].r, bean.c[idx].r, true);
        }
        bean.key[idx - 1].v = siblingContent.key[siblingContent.n - 1].v;
        bean.value[idx - 1].r = siblingContent.value[siblingContent.n - 1].r;
        ++childContent.n;
        --siblingContent.n;
        manager.setContentBean(graph, r, bean);
        manager.setContentBean(graph, bean.c[idx].r, childContent);
        manager.setContentBean(graph, bean.c[idx - 1].r, siblingContent);
    }

    void borrowFromNext(WriteGraph graph, BTreeContentManager manager, Resource r, BTreeContentBean bean, int idx) throws DatabaseException {
        BTreeContentBean childContent = manager.getContentBean((ReadGraph)graph, bean.c[idx].r);
        BTreeContentBean siblingContent = manager.getContentBean((ReadGraph)graph, bean.c[idx + 1].r);
        childContent.key[childContent.n].v = bean.key[idx].v;
        childContent.value[childContent.n].r = bean.value[idx].r;
        if (!childContent.leaf) {
            childContent.c[childContent.n + 1].r = siblingContent.c[0].r;
            this.setOwner(graph, childContent.c[childContent.n + 1].r, bean.c[idx].r, true);
        }
        bean.key[idx].v = siblingContent.key[0].v;
        bean.value[idx].r = siblingContent.value[0].r;
        int i = 1;
        while (i < siblingContent.n) {
            siblingContent.key[i - 1].v = siblingContent.key[i].v;
            siblingContent.value[i - 1].r = siblingContent.value[i].r;
            ++i;
        }
        if (!siblingContent.leaf) {
            i = 1;
            while (i <= siblingContent.n) {
                siblingContent.c[i - 1].r = siblingContent.c[i].r;
                ++i;
            }
        }
        ++childContent.n;
        --siblingContent.n;
        manager.setContentBean(graph, r, bean);
        manager.setContentBean(graph, bean.c[idx].r, childContent);
        manager.setContentBean(graph, bean.c[idx + 1].r, siblingContent);
    }

    void merge(WriteGraph graph, BTreeContentManager manager, Resource r, BTreeContentBean bean, int t, int idx) throws DatabaseException {
        BTreeContentBean childContent = manager.getContentBean((ReadGraph)graph, bean.c[idx].r);
        BTreeContentBean siblingContent = manager.getContentBean((ReadGraph)graph, bean.c[idx + 1].r);
        childContent.key[t - 1].v = bean.key[idx].v;
        childContent.value[t - 1].r = bean.value[idx].r;
        int i = 0;
        while (i < siblingContent.n) {
            childContent.key[i + t].v = siblingContent.key[i].v;
            childContent.value[i + t].r = siblingContent.value[i].r;
            ++i;
        }
        if (!childContent.leaf) {
            i = 0;
            while (i <= siblingContent.n) {
                childContent.c[i + t].r = siblingContent.c[i].r;
                this.setOwner(graph, childContent.c[i + t].r, bean.c[idx].r, true);
                ++i;
            }
        }
        i = idx + 1;
        while (i < bean.n) {
            bean.key[i - 1].v = bean.key[i].v;
            bean.value[i - 1].r = bean.value[i].r;
            ++i;
        }
        i = idx + 2;
        while (i <= bean.n) {
            bean.c[i - 1].r = bean.c[i].r;
            ++i;
        }
        childContent.n += siblingContent.n + 1;
        --bean.n;
        manager.setContentBean(graph, r, bean);
        manager.setContentBean(graph, bean.c[idx].r, childContent);
    }

    private void removeOwner(WriteGraph graph, Resource r, boolean force) throws DatabaseException {
        if (this.ownerRelation != null || force) {
            Resource own = this.ownerRelation != null ? this.ownerRelation : this.DATA.BTreeNode_IsOwnedBy;
            graph.deny(r, own);
        }
    }

    private void removeFromLeaf(WriteGraph graph, BTreeContentManager manager, Resource r, BTreeContentBean bean, int idx) throws DatabaseException {
        int i = idx + 1;
        while (i < bean.n) {
            bean.key[i - 1].v = bean.key[i].v;
            bean.value[i - 1].r = bean.value[i].r;
            ++i;
        }
        --bean.n;
        manager.setContentBean(graph, r, bean);
    }

    private void removeFromNonLeaf(WriteGraph graph, BTreeContentManager manager, Resource r, BTreeContentBean bean, int t, int idx) throws DatabaseException {
        Variant k = bean.key[idx].v;
        BTreeContentBean cContent = manager.getContentBean((ReadGraph)graph, bean.c[idx].r);
        if (cContent.n >= t) {
            Pair<Variant, Resource> pred = this.getPred((ReadGraph)graph, manager, bean, idx);
            bean.key[idx].v = (Variant)pred.first;
            bean.value[idx].r = (Resource)pred.second;
            this.removeImpl(graph, manager, t, bean.c[idx].r, cContent, (Variant)pred.first);
        } else {
            BTreeContentBean cContentPlus1 = manager.getContentBean((ReadGraph)graph, bean.c[idx + 1].r);
            if (cContentPlus1.n >= t) {
                Pair<Variant, Resource> succ = this.getSucc((ReadGraph)graph, manager, bean, idx);
                bean.key[idx].v = (Variant)succ.first;
                bean.value[idx].r = (Resource)succ.second;
                this.removeImpl(graph, manager, t, bean.c[idx + 1].r, cContentPlus1, (Variant)succ.first);
            } else {
                this.merge(graph, manager, r, bean, t, idx);
                this.removeImpl(graph, manager, t, bean.c[idx].r, cContent, k);
            }
        }
    }

    private Resource createNode(WriteGraph graph, BTreeContentManager manager, Resource type, int t) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource result = graph.newResource();
        long mod = (Long)graph.getRelatedValue(this.tree, this.DATA.BTree_mod, (Binding)Bindings.LONG);
        graph.claim(result, L0.InstanceOf, null, type);
        graph.claimLiteral(this.tree, this.DATA.BTree_mod, (Object)(mod + 1L), (Binding)Bindings.LONG);
        graph.addLiteral(result, L0.HasName, L0.NameOf, (Object)("" + mod), (Binding)Bindings.STRING);
        manager.setContentBean(graph, result, BTreeContentBean.create(t));
        return result;
    }

    private Resource searchNode(ReadGraph graph, Resource x, Variant k) throws DatabaseException {
        BTreeContentBean xContent = this.getContentBean(graph, x);
        int i = 1;
        while (i <= xContent.n && k.compareTo(xContent.key[i - 1].v) > 0) {
            ++i;
        }
        if (i <= xContent.n && k.equals((Object)xContent.key[i - 1].v)) {
            return xContent.value[i - 1].r;
        }
        if (xContent.leaf) {
            return null;
        }
        return this.searchNode(graph, xContent.c[i - 1].r, k);
    }

    private void splitChild(WriteGraph graph, BTreeContentManager manager, int t, Resource x, int i, Resource y) throws DatabaseException {
        Resource z = this.allocateNode(graph, manager, t);
        BTreeContentBean xContent = manager.getContentBean((ReadGraph)graph, x);
        BTreeContentBean yContent = manager.getContentBean((ReadGraph)graph, y);
        BTreeContentBean zContent = manager.getContentBean((ReadGraph)graph, z);
        zContent.leaf = yContent.leaf;
        zContent.n = t - 1;
        int j = 1;
        while (j <= t - 1) {
            zContent.key[j - 1].v = yContent.key[j + t - 1].v;
            zContent.value[j - 1].r = yContent.value[j + t - 1].r;
            this.setOwner(graph, zContent.value[j - 1].r, z, true);
            ++j;
        }
        if (!yContent.leaf) {
            j = 1;
            while (j <= t) {
                zContent.c[j - 1].r = yContent.c[j + t - 1].r;
                this.setOwner(graph, zContent.c[j - 1].r, z, true);
                ++j;
            }
        }
        yContent.n = t - 1;
        j = xContent.n + 1;
        while (j >= i + 1) {
            xContent.c[j + 1 - 1].r = xContent.c[j - 1].r;
            --j;
        }
        xContent.c[i + 1 - 1].r = z;
        this.setOwner(graph, z, x, true);
        j = xContent.n;
        while (j >= i) {
            xContent.key[j + 1 - 1].v = xContent.key[j - 1].v;
            xContent.value[j + 1 - 1].r = xContent.value[j - 1].r;
            --j;
        }
        xContent.key[i - 1].v = yContent.key[t - 1].v;
        xContent.value[i - 1].r = yContent.value[t - 1].r;
        ++xContent.n;
        this.setOwner(graph, xContent.value[i - 1].r, x, true);
        manager.setContentBean(graph, x, xContent);
        manager.setContentBean(graph, y, yContent);
        manager.setContentBean(graph, z, zContent);
    }

    /*
     * Unable to fully structure code
     */
    private void insertNonfull(WriteGraph graph, BTreeContentManager manager, int t, Resource x, Variant k, Resource v) throws DatabaseException {
        block4: {
            xContent = manager.getContentBean((ReadGraph)graph, x);
            i = xContent.n;
            if (!xContent.leaf) ** GOTO lbl16
            while (i >= 1 && k.compareTo(xContent.key[i - 1].v) < 0) {
                xContent.key[i + 1 - 1].v = xContent.key[i - 1].v;
                xContent.value[i + 1 - 1].r = xContent.value[i - 1].r;
                --i;
            }
            xContent.key[i + 1 - 1].v = k;
            xContent.value[i + 1 - 1].r = v;
            ++xContent.n;
            this.setOwner(graph, v, x, false);
            manager.setContentBean(graph, x, xContent);
            break block4;
lbl-1000:
            // 1 sources

            {
                --i;
lbl16:
                // 2 sources

                ** while (i >= 1 && k.compareTo((Variant)xContent.key[i - 1].v) < 0)
            }
lbl17:
            // 1 sources

            xciContent = manager.getContentBean((ReadGraph)graph, xContent.c[++i - 1].r);
            if (xciContent.n == 2 * t - 1) {
                this.splitChild(graph, manager, t, x, i, xContent.c[i - 1].r);
                xContent = manager.getContentBean((ReadGraph)graph, x);
                if (k.compareTo(xContent.key[i - 1].v) > 0) {
                    ++i;
                }
            }
            this.insertNonfull(graph, manager, t, xContent.c[i - 1].r, k, v);
        }
    }

    private void setOwner(WriteGraph graph, Resource r, Resource owner, boolean force) throws DatabaseException {
        if (r != null && (this.ownerRelation != null || force)) {
            Resource own = this.ownerRelation != null ? this.ownerRelation : this.DATA.BTreeNode_IsOwnedBy;
            graph.deny(r, own);
            graph.claim(r, own, owner);
        }
    }

    private Resource getRoot(ReadGraph graph) throws DatabaseException {
        return graph.getPossibleObject(this.tree, this.DATA.BTree_root);
    }

    private void setRoot(WriteGraph graph, Resource r) throws DatabaseException {
        graph.deny(this.tree, this.DATA.BTree_root);
        graph.claim(this.tree, this.DATA.BTree_root, r);
    }

    private Resource allocateNode(WriteGraph graph, BTreeContentManager manager, int t) throws DatabaseException {
        return this.createNode(graph, manager, this.DATA.BTreeNode, t);
    }

    @Override
    public void setContentBean(WriteGraph graph, Resource node, BTreeContentBean bean) throws DatabaseException {
        graph.claimLiteral(node, this.DATA.BTreeNode_content, this.DATA.BTreeNode_Content, (Object)bean, this.CONTENT_BEAN_BINDING);
    }

    private int getDegree(ReadGraph graph) throws DatabaseException {
        return (Integer)graph.syncRequest((AsyncRead)new RelatedValue(this.tree, this.DATA.BTree_t, (Binding)Bindings.INTEGER), (Listener)TransientCacheListener.instance());
    }

    @Override
    public BTreeContentBean getContentBean(ReadGraph graph, Resource node) throws DatabaseException {
        return (BTreeContentBean)((Object)graph.syncRequest((AsyncRead)new RelatedValue(node, this.DATA.BTreeNode_content, this.CONTENT_BEAN_BINDING), (Listener)TransientCacheListener.instance()));
    }

    public List<Tuple2> entries(ReadGraph graph) throws DatabaseException {
        Resource r = this.getRoot(graph);
        ArrayList<Tuple2> results = new ArrayList<Tuple2>();
        return this.collectEntries(graph, r, null, null, results);
    }

    private List<Tuple2> collectEntries(ReadGraph graph, Resource x, Variant min, Variant max, List<Tuple2> results) throws DatabaseException {
        BTreeContentBean xContent = this.getContentBean(graph, x);
        int i = 0;
        while (i < xContent.n + 1) {
            if (min == null || i >= xContent.n || min.compareTo(xContent.key[i].v) <= 0) {
                Resource child;
                if (!xContent.leaf && (child = xContent.c[i].r) != null) {
                    Variant min2 = min != null && i > 0 && min.compareTo(xContent.key[i - 1].v) < 0 ? null : min;
                    Variant max2 = max != null && i < xContent.n - 1 && max.compareTo(xContent.key[i + 1].v) > 0 ? null : max;
                    this.collectEntries(graph, child, min2, max2, results);
                }
                if (i < xContent.n) {
                    if (max != null && max.compareTo(xContent.key[i].v) < 0) {
                        return results;
                    }
                    results.add(new Tuple2((Object)xContent.key[i].v, (Object)xContent.value[i].r));
                }
            }
            ++i;
        }
        return results;
    }

    public List<Tuple2> searchRange(ReadGraph graph, Variant min, Variant max) throws DatabaseException {
        Resource r = this.getRoot(graph);
        ArrayList<Tuple2> results = new ArrayList<Tuple2>();
        return this.collectEntries(graph, r, min, max, results);
    }

    static class BatchContentManager
    implements BTreeContentManager {
        private final BTreeUtils bu;
        final Map<Resource, BTreeContentBean> beans = new HashMap<Resource, BTreeContentBean>();

        public BatchContentManager(BTreeUtils bu) {
            this.bu = bu;
        }

        @Override
        public BTreeContentBean getContentBean(ReadGraph graph, Resource node) throws DatabaseException {
            BTreeContentBean bean = this.beans.get(node);
            if (bean != null) {
                return bean;
            }
            return this.bu.getContentBean(graph, node);
        }

        @Override
        public void setContentBean(WriteGraph graph, Resource node, BTreeContentBean bean) throws DatabaseException {
            this.beans.put(node, bean);
        }

        public void apply(WriteGraph graph) throws DatabaseException {
            for (Map.Entry<Resource, BTreeContentBean> entry : this.beans.entrySet()) {
                this.bu.setContentBean(graph, entry.getKey(), entry.getValue());
            }
        }
    }
}

