/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.datatypes.utils;

import java.util.List;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.datatypes.utils.BTreeUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.scl.runtime.tuple.Tuple2;

public class BTree {
    private final BTreeUtils utils;

    public BTree(WriteGraph graph, int t, Resource ownerRelation) throws DatabaseException {
        this.utils = new BTreeUtils((ReadGraph)graph, BTreeUtils.create(graph, ownerRelation, t));
    }

    public BTree(ReadGraph graph, Resource tree) throws DatabaseException {
        this.utils = new BTreeUtils(graph, tree);
    }

    public Resource rootOfBTree() {
        return this.utils.getTree();
    }

    public void insertBTree(WriteGraph graph, Variant key, Resource value) throws DatabaseException {
        this.utils.insert(graph, key, value);
    }

    public Resource searchBTree(ReadGraph graph, Variant key) throws DatabaseException {
        return this.utils.search(graph, key);
    }

    public void removeBTree(WriteGraph graph, Variant key) throws DatabaseException {
        this.utils.remove(graph, key);
    }

    public List<Tuple2> entriesOfBTree(ReadGraph graph) throws DatabaseException {
        return this.utils.entries(graph);
    }

    public List<Tuple2> searchRangeBTree(ReadGraph graph, Variant min, Variant max) throws DatabaseException {
        return this.utils.searchRange(graph, min, max);
    }
}

