/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.common.modifiers;

import java.util.Comparator;

public class EnumeratedValue<T>
implements Comparable<EnumeratedValue<T>> {
    public static final Comparator<EnumeratedValue<? extends Object>> CASE_INSENSITIVE_NAME_ORDER = new Comparator<EnumeratedValue<? extends Object>>(){

        @Override
        public int compare(EnumeratedValue<? extends Object> o1, EnumeratedValue<? extends Object> o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    };
    private final String name;
    private final T object;

    public static final <T> EnumeratedValue<T> invalid(String name) {
        return new InvalidEnumeratedValue(name);
    }

    public static final boolean isInvalid(EnumeratedValue<?> value) {
        return value instanceof InvalidEnumeratedValue;
    }

    public static EnumeratedValue<String> make(String name) {
        return new EnumeratedValue<String>(name, name);
    }

    public static <T> EnumeratedValue<T> make(String name, T object) {
        return new EnumeratedValue<T>(name, object);
    }

    public EnumeratedValue(String name, T object) {
        if (name == null) {
            throw new NullPointerException("null enumerated value name");
        }
        this.name = name;
        this.object = object;
    }

    public String getName() {
        return this.name;
    }

    public T getObject() {
        return this.object;
    }

    public String toString() {
        return String.valueOf(this.name) + "[" + this.object + "]";
    }

    @Override
    public int compareTo(EnumeratedValue<T> o) {
        return this.getName().compareTo(o.getName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.object == null ? 0 : this.object.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnumeratedValue other = (EnumeratedValue)obj;
        if (!this.name.equals(other.name)) {
            return false;
        }
        return !(this.object == null ? other.object != null : !this.object.equals(other.object));
    }

    private static class InvalidEnumeratedValue<T>
    extends EnumeratedValue<T> {
        public InvalidEnumeratedValue(String name) {
            super(name, null);
        }
    }
}

