package org.simantics.utils.logging;

import java.text.DecimalFormat;
import java.text.NumberFormat;

public class TimeLogger {
    public static final boolean TIME_LOGGING_ENABLED = false;
    
    private static final NumberFormat TIME_FORMAT = new DecimalFormat("0.000");
    
    private static long BEGIN_TIME = System.nanoTime();
    
    private static void printCurrentTime() {
        double time = (System.nanoTime() - BEGIN_TIME) * 1e-9;
        System.out.print("[");
        System.out.print(TIME_FORMAT.format(time));
        System.out.print(" s] ");
    }
    
    public static void resetTimeAndLog(String message) {
        if(TIME_LOGGING_ENABLED) {
            BEGIN_TIME = System.nanoTime();
            printCurrentTime();
            System.out.print(message);
            System.out.print(" ");
            for(int i=0;i<140-message.length();++i)
                System.out.print("=");
            System.out.println();
        }
    }
    
    public static void resetTimeAndLog(Class<?> clazz, String method) {
        if(TIME_LOGGING_ENABLED)
            resetTimeAndLog(clazz.getSimpleName() + "." + method);
    }
    
    public static void resetTime() {
        if(TIME_LOGGING_ENABLED)
            BEGIN_TIME = System.nanoTime();
    }
    
    public static void log(String message) {
        if(TIME_LOGGING_ENABLED) {
            printCurrentTime();
            System.out.println(message);
        }
    }
    
    public static void log(Class<?> clazz, String method) {
        if(TIME_LOGGING_ENABLED)
            log(clazz.getSimpleName() + "." + method);
    }
}
