/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.logging;

import java.util.Properties;

abstract public class Logger {

	public static final boolean ECHO = false;
    
    protected static final Properties defaultProperties(String ... keyValuePairs) {

    	assert(keyValuePairs.length % 2 == 0);
    	
        Properties defaultProperties = new Properties();
        defaultProperties.put("log4j.rootCategory", "ERROR, default");
        defaultProperties.put("log4j.appender.default", "org.apache.log4j.FileAppender");
        defaultProperties.put("log4j.appender.default.append", "false");
        defaultProperties.put("log4j.appender.default.layout", "org.apache.log4j.PatternLayout");
        defaultProperties.put("log4j.appender.default.layout.ConversionPattern", "%-6r [%15.15t] %-5p %30.30c - %m%n");
        
        for(int i=0;i<keyValuePairs.length;) {
        	String key = keyValuePairs[i++];
        	String value = keyValuePairs[i++];
        	defaultProperties.put(key, value);
        }
        
        return defaultProperties; 
    	
    }
    
    final protected org.apache.log4j.Logger logger;
    
    protected Logger(org.apache.log4j.Logger logger) {
    	this.logger = logger;
    }

    final protected org.apache.log4j.Logger getLogger() {
    	return logger;
    }
    
    /**
     * Log a trace event.
     * 
     * @param message message of the trace
     * @param exception the exception, or <code>null</code>
     */
    public void logTrace(String message, Throwable exception) {
        // Errors are much more useful with a stack trace!
        if (exception == null) {
            exception = new RuntimeException();
        }
        getLogger().trace(message, exception);
    }

    /**
     * Log an info event.
     * 
     * @param message message of the info
     * @param exception the exception, or <code>null</code>
     */
    public void logInfo(String message, Throwable exception) {
        // Errors are much more useful with a stack trace!
        if (exception == null) {
            exception = new RuntimeException();
        }
        getLogger().info(message, exception);
    }

    /**
     * Log an error event.
     * 
     * @param message message of the error
     * @param exception the exception, or <code>null</code>
     */
    public void logError(String message, Throwable exception) {
    	
        // Errors are much more useful with a stack trace!
        if (exception == null) {
            exception = new RuntimeException();
        }
        getLogger().error(message, exception);
    }
    
    /**
     * Log an error event.
     * 
     * @param message message of the error
     * @param exception the exception, or <code>null</code>
     */
    public void logWarning(String message, Throwable exception) {
        // Errors are much more useful with a stack trace!
        if (exception == null) {
            exception = new RuntimeException();
        }
        getLogger().error(message, exception);
    }
    
}
