package org.simantics.utils;
/**
 * Listener that can be added to IOperation.
 * 
 * @author Hannu Niemist&ouml;
 */
public interface IOperationListener<Result, E extends Exception> {

    /**
     * Called when the operation succeeds.
     */
    void succeeded(Result result);

    /**
     * Called when the operation fails.
     */
    void failed(E exception);

}