package org.simantics.utils;

import java.io.File;
import java.io.IOException;

/**
 * @author Tuukka Lehtonen
 */
public interface FileService {

	public static interface DeleteOption {}

	public static class EffortOption implements DeleteOption {
		public final int maxTries;

		private EffortOption(int maxTries) {
			this.maxTries = maxTries;
		}

		public static EffortOption maxTries(int maxTries) {
			return new EffortOption(maxTries);
		}
	}

	/**
	 * Schedules a file to be deleted at some point in the future when the
	 * system allows it to be deleted if ever.
	 * 
	 * @param file
	 * @return an operation handle for tracking the progress of the deletion or
	 *         <code>null</code> if there's a deletion operation scheduled for
	 *         the provided file in the queue or the file does not exist.
	 */
	IOperation<Boolean, IOException> scheduleDeleteIfExists(File file, DeleteOption... options);

}
