/*******************************************************************************
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.spreadsheet;

import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;

import org.simantics.utils.datastructures.Pair;


public interface ClientModel extends CellModifier {

	public interface ClientModelListener {
		
		public void rows(int amount);
		public void columns(int amount);

		public void columnLabels(String[] labels);
		public void rowLabels(String[] labels);
		public void columnWidths(int[] widths);
		
		public void sources(String[] available, String current);
		
		public void propertyChange(String location, String property, Object value);
		public void cleared(String location);
		public void flush();
		
	}

	public static final String EXCEL = "Excel";
	public static final String EXCEL_VISIBLE = "Visible";

	/**
	 * The location argument to use for setting header properties.
	 * @see #HEADERS_COL_LABELS
	 * @see #HEADERS_COL_WIDTHS
	 * @see #HEADERS_ROW_HEIGHTS
	 * @see #HEADERS_ROW_LABELS
	 */
	public static final String HEADERS = "Headers";
	public static final String HEADERS_COL_WIDTHS = "columnWidths";
	public static final String HEADERS_ROW_HEIGHTS = "rowHeights";
	public static final String HEADERS_COL_LABELS = "columnLabels";
	public static final String HEADERS_ROW_LABELS = "rowLabels";
	
	/**
	 * The location argument to use for setting dimension properties.
	 * @see #DIMENSIONS_COL_COUNT
	 * @see #DIMENSIONS_FIT_COLS
	 * @see #DIMENSIONS_FIT_ROWS
	 * @see #DIMENSIONS_ROW_COUNT
	 */
	public static final String DIMENSIONS = "Dimensions";
	public static final String DIMENSIONS_FIT_ROWS = "fitRows";
	public static final String DIMENSIONS_FIT_COLS = "fitColumns";
	public static final String DIMENSIONS_COL_COUNT = "columnCount";
	public static final String DIMENSIONS_ROW_COUNT = "rowCount";

	public static final String SOURCES = "Sources";
	public static final String SOURCES_AVAILABLE = "available";
	public static final String SOURCES_CURRENT = "current";

	public static final String FONT = "font";
	public static final String FOREGROUND = "foreground";
	public static final String BACKGROUND = "background";
	public static final String BORDER = "border";
	public static final String ALIGN = "align";
	public static final String LABEL = "label";
	public static final String CONTENT = "content";
	public static final String CONTENT_EXPRESSION = "content#expression";
	public static final String COMPUTED = "Computed";
	public static final String LOCKED = "locked";
	public static final String ROW_SPAN = "rowSpan";
	public static final String COLUMN_SPAN = "columnSpan";
	
    void addListener(ClientModelListener listener);
    void removeListener(ClientModelListener listener);
    <T> T getPropertyAt(String location, String property);
    <T> T getPossiblePropertyAt(String location, String property);
    
    int[] getColumnWidths();
    int[] getRowHeights();
    
    int getRows();
    int getColumns();

	public Collection<Pair<String, Object>> listAll(String property);
	
	/*
	 * Returns a copy of the span. Null if not found.
	 */
	public Rectangle getSpan(int row, int column);

	/*
	 * Returns a copy of the span list.
	 */	
	public List<Rectangle> getSpans();
	
}
