/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.osgi.internal;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.hash.THashSet;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTracker;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.compiler.source.ModuleSource;
import org.simantics.scl.compiler.source.repository.AbstractModuleSourceRepository;
import org.simantics.scl.osgi.internal.BundleDocumentationSource;
import org.simantics.scl.osgi.internal.BundleModuleSource;

public class BundleModuleSourceRepository
extends AbstractModuleSourceRepository {
    Tracker tracker;
    THashMap<String, BundleModuleSource> modules = new THashMap();
    THashMap<Bundle, ArrayList<String>> modulesPerBundle = new THashMap();
    THashMap<String, BundleDocumentationSource> documentations = new THashMap();
    THashMap<Bundle, ArrayList<String>> documentationsPerBundle = new THashMap();

    public BundleModuleSourceRepository(BundleContext context) {
        this.tracker = new Tracker(context);
        this.tracker.open();
    }

    public synchronized ModuleSource getModuleSource(String moduleName, UpdateListener listener) {
        return (ModuleSource)this.modules.get((Object)moduleName);
    }

    public synchronized void forAllModules(TObjectProcedure<String> procedure) {
        this.modules.forEachKey(procedure);
    }

    public synchronized String getDocumentation(String documentationName) {
        BundleDocumentationSource source = (BundleDocumentationSource)this.documentations.get((Object)documentationName);
        if (source == null) {
            return null;
        }
        return source.getText();
    }

    public synchronized void forAllDocumentations(TObjectProcedure<String> procedure) {
        this.documentations.forEachKey(procedure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkUpdates() {
        BundleModuleSourceRepository bundleModuleSourceRepository = this;
        synchronized (bundleModuleSourceRepository) {
            this.modulesPerBundle.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<Bundle, ArrayList<String>>(){

                public boolean execute(Bundle bundle, ArrayList<String> oldModules) {
                    Enumeration moduleEntries = bundle.findEntries("scl", "*.scl", true);
                    if (moduleEntries != null) {
                        THashSet oldModuleSet = new THashSet(oldModules);
                        ArrayList<String> modulesInThisBundle = new ArrayList<String>();
                        while (moduleEntries.hasMoreElements()) {
                            URL url = (URL)moduleEntries.nextElement();
                            String path = url.getPath();
                            String moduleName = path.substring(5, path.length() - 4);
                            if (!oldModuleSet.remove((Object)moduleName)) {
                                BundleModuleSourceRepository.this.modules.put((Object)moduleName, (Object)new BundleModuleSource(moduleName, bundle, url));
                            }
                            modulesInThisBundle.add(moduleName);
                        }
                        for (String oldModule : oldModuleSet) {
                            BundleModuleSourceRepository.this.modules.remove((Object)oldModule);
                        }
                        BundleModuleSourceRepository.this.modulesPerBundle.put((Object)bundle, modulesInThisBundle);
                    } else {
                        for (String oldModule : oldModules) {
                            BundleModuleSourceRepository.this.modules.remove((Object)oldModule);
                        }
                        BundleModuleSourceRepository.this.modulesPerBundle.put((Object)bundle, new ArrayList(0));
                    }
                    return true;
                }
            });
            this.documentationsPerBundle.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<Bundle, ArrayList<String>>(){

                public boolean execute(Bundle bundle, ArrayList<String> oldDocumentations) {
                    Enumeration documentationEntries = bundle.findEntries("scl", "*.md", true);
                    if (documentationEntries != null) {
                        THashSet oldDocSet = new THashSet(oldDocumentations);
                        ArrayList<String> documentationsInThisBundle = new ArrayList<String>();
                        while (documentationEntries.hasMoreElements()) {
                            URL url = (URL)documentationEntries.nextElement();
                            String path = url.getPath();
                            String documentationName = path.substring(5, path.length() - 3);
                            if (!oldDocSet.remove((Object)documentationName)) {
                                BundleModuleSourceRepository.this.documentations.put((Object)documentationName, (Object)new BundleDocumentationSource(documentationName, bundle, url));
                            }
                            documentationsInThisBundle.add(documentationName);
                        }
                        for (String oldDocumentation : oldDocSet) {
                            BundleModuleSourceRepository.this.documentations.remove((Object)oldDocumentation);
                        }
                        BundleModuleSourceRepository.this.documentationsPerBundle.put((Object)bundle, documentationsInThisBundle);
                    } else {
                        for (String oldDocumentation : oldDocumentations) {
                            BundleModuleSourceRepository.this.documentations.remove((Object)oldDocumentation);
                        }
                        BundleModuleSourceRepository.this.documentationsPerBundle.put((Object)bundle, new ArrayList(0));
                    }
                    return true;
                }
            });
        }
        for (BundleModuleSource source : this.modules.values()) {
            source.checkUpdates();
        }
    }

    class Tracker
    extends BundleTracker<Bundle> {
        public Tracker(BundleContext context) {
            super(context, -1, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Bundle addingBundle(Bundle bundle, BundleEvent event) {
            BundleModuleSourceRepository bundleModuleSourceRepository = BundleModuleSourceRepository.this;
            synchronized (bundleModuleSourceRepository) {
                Enumeration moduleEntries = bundle.findEntries("scl", "*.scl", true);
                if (moduleEntries != null) {
                    ArrayList<String> modulesInThisBundle = new ArrayList<String>();
                    while (moduleEntries.hasMoreElements()) {
                        URL url = (URL)moduleEntries.nextElement();
                        String path = url.getPath();
                        String moduleName = path.substring(5, path.length() - 4);
                        BundleModuleSourceRepository.this.modules.put((Object)moduleName, (Object)new BundleModuleSource(moduleName, bundle, url));
                        modulesInThisBundle.add(moduleName);
                    }
                    BundleModuleSourceRepository.this.modulesPerBundle.put((Object)bundle, modulesInThisBundle);
                } else {
                    BundleModuleSourceRepository.this.modulesPerBundle.put((Object)bundle, new ArrayList(0));
                }
                Enumeration documentationEntries = bundle.findEntries("scl", "*.md", true);
                if (documentationEntries != null) {
                    ArrayList<String> documentationsInThisBundle = new ArrayList<String>();
                    while (documentationEntries.hasMoreElements()) {
                        URL url = (URL)documentationEntries.nextElement();
                        String path = url.getPath();
                        String documentationName = path.substring(5, path.length() - 3);
                        BundleModuleSourceRepository.this.documentations.put((Object)documentationName, (Object)new BundleDocumentationSource(documentationName, bundle, url));
                        documentationsInThisBundle.add(documentationName);
                    }
                    BundleModuleSourceRepository.this.documentationsPerBundle.put((Object)bundle, documentationsInThisBundle);
                } else {
                    BundleModuleSourceRepository.this.documentationsPerBundle.put((Object)bundle, new ArrayList(0));
                }
                return bundle;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedBundle(Bundle bundle, BundleEvent event, Bundle object) {
            System.out.println("removeBundle " + bundle.getSymbolicName());
            BundleModuleSourceRepository bundleModuleSourceRepository = BundleModuleSourceRepository.this;
            synchronized (bundleModuleSourceRepository) {
                ArrayList documentationsList;
                ArrayList moduleList = (ArrayList)BundleModuleSourceRepository.this.modulesPerBundle.get((Object)bundle);
                if (moduleList != null) {
                    for (String moduleName : moduleList) {
                        BundleModuleSourceRepository.this.modules.remove((Object)moduleName);
                    }
                }
                if ((documentationsList = (ArrayList)BundleModuleSourceRepository.this.documentationsPerBundle.get((Object)bundle)) != null) {
                    for (String documentation : documentationsList) {
                        BundleModuleSourceRepository.this.documentations.remove((Object)documentation);
                    }
                }
            }
        }
    }
}

