/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.osgi.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.simantics.scl.compiler.module.ImportDeclaration;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.compiler.source.EncodedTextualModuleSource;
import org.simantics.scl.compiler.types.Type;

public class BundleModuleSource
extends EncodedTextualModuleSource {
    public static final ImportDeclaration[] DEFAULT_IMPORTS = new ImportDeclaration[]{new ImportDeclaration("Builtin", ""), new ImportDeclaration("StandardLibrary", "")};
    public static final ImportDeclaration[] DEFAULT_IMPORTS_FOR_STANDARD_LIBRARY = new ImportDeclaration[]{new ImportDeclaration("Builtin", "")};
    public final Bundle bundle;
    public final URL url;
    private byte[] digest;
    private ArrayList<UpdateListener> listeners;

    public BundleModuleSource(String moduleName, Bundle bundle, URL url) {
        super(moduleName);
        this.bundle = bundle;
        this.url = url;
    }

    protected ImportDeclaration[] getBuiltinImports(UpdateListener listener) {
        if (this.bundle.getSymbolicName().equals("org.simantics.scl.runtime")) {
            return DEFAULT_IMPORTS_FOR_STANDARD_LIBRARY;
        }
        return DEFAULT_IMPORTS;
    }

    private byte[] computeDigest() {
        byte[] byArray;
        InputStream stream = this.url.openStream();
        try {
            int count;
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            byte[] buffer = new byte[1024];
            while ((count = stream.read(buffer)) > 0) {
                digest.update(buffer, 0, count);
            }
            byArray = digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            byte[] byArray2;
            try {
                e.printStackTrace();
                byArray2 = new byte[]{};
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    return new byte[0];
                }
            }
            stream.close();
            return byArray2;
        }
        stream.close();
        return byArray;
    }

    protected InputStream getSourceStream(UpdateListener listener) throws IOException {
        if (this.digest == null) {
            this.digest = this.computeDigest();
        }
        if (listener != null) {
            if (this.listeners == null) {
                this.listeners = new ArrayList(2);
            }
            this.listeners.add(listener);
        }
        return this.url.openStream();
    }

    public ClassLoader getClassLoader() {
        if (this.bundle.getSymbolicName().equals("org.simantics.scl.runtime")) {
            return Type.class.getClassLoader();
        }
        BundleWiring wiring = (BundleWiring)this.bundle.adapt(BundleWiring.class);
        if (wiring != null) {
            return wiring.getClassLoader();
        }
        return ((Object)((Object)this)).getClass().getClassLoader();
    }

    public void checkUpdates() {
        byte[] newDigest;
        if (this.digest != null && this.listeners != null && !Arrays.equals(this.digest, newDigest = this.computeDigest())) {
            this.digest = newDigest;
            ArrayList<UpdateListener> oldListeners = this.listeners;
            this.listeners = null;
            for (UpdateListener listener : oldListeners) {
                listener.notifyAboutUpdate();
            }
        }
    }
}

