/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.template2d.ui.diagram.adapter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.Bean;
import org.simantics.datatypes.literal.Font;
import org.simantics.datatypes.literal.RGB;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.diagram.elements.TextNode;
import org.simantics.diagram.function.All;
import org.simantics.diagram.function.PredefinedVariables;
import org.simantics.diagram.profile.ProfileKeys;
import org.simantics.diagram.profile.StyleBase;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.ElementAdapter;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.FillColor;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.Outline;
import org.simantics.g2d.element.handler.OutlineColorSpec;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.SelectionSpecification;
import org.simantics.g2d.element.handler.StrokeSpec;
import org.simantics.g2d.element.handler.Transform;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.g2d.element.impl.Element;
import org.simantics.g2d.elementclass.NonCopyable;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.template2d.ui.function.DrawingTemplateInfo;
import org.simantics.modeling.template2d.ui.function.FlagInfo;
import org.simantics.modeling.template2d.ui.function.FlagTableColumnInfo;
import org.simantics.modeling.template2d.ui.function.FlagTableInfo;
import org.simantics.modeling.template2d.ui.function.MonitorInfo;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.nodes.ShapeNode;
import org.simantics.scenegraph.g2d.nodes.spatial.RTreeNode;
import org.simantics.scenegraph.profile.DataNodeMap;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.Observer;
import org.simantics.scenegraph.profile.common.ProfileVariables;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.ui.colors.Colors;
import org.simantics.ui.fonts.Fonts;
import org.simantics.utils.datastructures.hints.IHintContext;

public class DrawingFlagTableStyle
extends StyleBase<StyleInfo> {
    private static final boolean DEBUG_PAINT_ELEMENTS = false;
    private static final String SLOT_TABLE_PREFIX = "slotTable<";
    private static final String SLOT_TABLE_SEPARATOR = ">";
    private static final String SLOT_TABLE_ELEMENTS = "slotTableElements";
    private ElementClass rowElementClass;

    public DrawingFlagTableStyle(ReadGraph graph) {
        this.rowElementClass = ElementClass.compile((ElementHandler[])new ElementHandler[]{RowElementHandler.INSTANCE, RowElementSelectionHandler.INSTANCE, NonCopyable.INSTANCE, new StaticObjectAdapter((Object)DiagramResource.getInstance((ReadGraph)graph).Flag)}).setId(RowElementHandler.class.getSimpleName());
    }

    public StyleInfo calculateStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource diagram, Variable activeComposite) throws DatabaseException {
        Resource template = All.getTemplate((ReadGraph)graph, (Resource)runtimeDiagram);
        if (template == null) {
            return null;
        }
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource diagram2 = graph.getPossibleObject(runtimeDiagram, DIA.RuntimeDiagram_HasConfiguration);
        StyleInfo info = new StyleInfo();
        DrawingTemplateInfo templateInfo = new DrawingTemplateInfo(template);
        info.template = template;
        info.name2table = (TreeMap)graph.syncRequest((Read)templateInfo, (Listener)TransientCacheListener.instance());
        if (info.name2table == null) {
            info.name2table = new TreeMap();
        }
        info.flags = (List)graph.syncRequest((Read)new FlagInfos(diagram2), (Listener)TransientCacheListener.instance());
        if (info.flags == null) {
            info.flags = Collections.emptyList();
        }
        return info;
    }

    public void applyStyleForItem(EvaluationContext evaluationContext, DataNodeMap map, Object item, StyleInfo info) {
        if (info == null || info.flags == null || info.name2table == null) {
            return;
        }
        this.cleanupStyleForItem(evaluationContext, map, item);
        for (Map.Entry<String, FlagTableInfo> entry : info.name2table.entrySet()) {
            String name = entry.getKey();
            FlagTableInfo table = entry.getValue();
            RenderTable com = new RenderTable(evaluationContext, table, name);
            com.perform();
            RenderHeaderTexts com3 = new RenderHeaderTexts(evaluationContext, table, name);
            com3.perform();
        }
    }

    protected void cleanupStyleForItem(EvaluationContext evaluationContext, DataNodeMap map, Object item) {
        G2DSceneGraph root = evaluationContext.getSceneGraph();
        if (root instanceof G2DSceneGraph) {
            G2DSceneGraph sg = root;
            G2DParentNode nav = (G2DParentNode)sg.getNode("navigation");
            IDiagram diagram = (IDiagram)evaluationContext.getConstant(ProfileKeys.DIAGRAM);
            for (String childId : NodeUtil.filterDirectChildIds((ParentNode)nav, (String)SLOT_TABLE_PREFIX)) {
                INode child = nav.getNode(childId);
                List elements = (List)evaluationContext.setProperty(child, SLOT_TABLE_ELEMENTS, null);
                if (elements != null && diagram != null) {
                    for (IElement e : elements) {
                        this.cleanupElement(diagram, e);
                    }
                }
                nav.removeNode(childId);
            }
        }
    }

    private void cleanupElement(IDiagram diagram, IElement e) {
        diagram.removeElement(e);
    }

    private static String tableLookupName(String tableName) {
        return SLOT_TABLE_PREFIX + tableName;
    }

    private static String cellLookupName(String tableName, int column, int row, int index) {
        return SLOT_TABLE_PREFIX + tableName + SLOT_TABLE_SEPARATOR + column + SLOT_TABLE_SEPARATOR + row + SLOT_TABLE_SEPARATOR + index;
    }

    private IElement addFlagElement(EvaluationContext evaluationContext, INode tableNode, Rectangle2D bounds, Resource flag) {
        IDiagram diagram = (IDiagram)evaluationContext.getConstant(ProfileKeys.DIAGRAM);
        assert (diagram != null);
        List elements = (List)evaluationContext.getProperty(tableNode, SLOT_TABLE_ELEMENTS);
        assert (elements != null);
        IElement e = this.newFlagElement(evaluationContext, bounds, flag);
        elements.add(e);
        diagram.addElement(e);
        return e;
    }

    private IElement newFlagElement(EvaluationContext evaluationContext, Rectangle2D bounds, Resource flag) {
        IElement e = Element.spawnNew((ElementClass)this.rowElementClass);
        e.setHint(ElementHints.KEY_BOUNDS, bounds.clone());
        e.setHint(ElementHints.KEY_TRANSFORM, (Object)new AffineTransform());
        e.setHint(ElementHints.KEY_OBJECT, (Object)new Wrapper(flag));
        return e;
    }

    public String toString() {
        return "Flag table style";
    }

    public static class EvaluatePath
    extends ResourceRead<String> {
        private String path = null;

        public EvaluatePath(Resource res, String path) {
            super(res);
            this.path = path;
        }

        public String perform(ReadGraph g) throws DatabaseException {
            PredefinedVariables vars = PredefinedVariables.getInstance();
            Variable resourceVariable = Variables.getVariable((ReadGraph)g, (Resource)this.resource);
            if (resourceVariable == null) {
                return "";
            }
            Variable property = vars.getVariable(g, this.path, this.resource, resourceVariable);
            Object value = null;
            if (property == null) {
                return "";
            }
            try {
                value = property.getValue(g);
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
            if (value == null || !(value instanceof String)) {
                return "";
            }
            return value.toString();
        }
    }

    public static class FlagInfos
    extends ResourceRead<ArrayList<FlagInfo>> {
        public FlagInfos(Resource diagram) {
            super(diagram);
        }

        public ArrayList<FlagInfo> perform(ReadGraph g) throws DatabaseException {
            ArrayList<FlagInfo> flagInfos = new ArrayList<FlagInfo>();
            try {
                Layer0 L0 = Layer0.getInstance((ReadGraph)g);
                DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
                Collection children = g.getObjects(this.resource, L0.ConsistsOf);
                for (Resource child : children) {
                    if (!g.isInstanceOf(child, DIA.Flag)) continue;
                    Resource flag = child;
                    String tableName = (String)g.getPossibleRelatedValue(flag, DIA.Flag_HasIOTableBinding, (Binding)Bindings.STRING);
                    Integer rowIndex = (Integer)g.getPossibleRelatedValue(flag, DIA.Flag_HasIOTableRowIndex, (Binding)Bindings.INTEGER);
                    FlagInfo flagInfo = new FlagInfo();
                    flagInfo.flag = flag;
                    if (tableName != null && tableName.length() > 0) {
                        flagInfo.flagTableName = tableName;
                    }
                    flagInfo.flagTableRowIndex = rowIndex;
                    flagInfos.add(flagInfo);
                }
            }
            catch (Throwable e) {
                e.printStackTrace(System.err);
            }
            return flagInfos;
        }
    }

    public static class RenderHeaderTexts {
        private FlagTableInfo table = null;
        private String tableName = null;
        private EvaluationContext evaluationContext = null;

        public RenderHeaderTexts(EvaluationContext evaluationContext, FlagTableInfo table, String tableName) {
            this.table = table;
            this.tableName = tableName;
            this.evaluationContext = evaluationContext;
        }

        public void perform() {
            if (this.table == null || this.evaluationContext == null || this.tableName == null) {
                return;
            }
            Session session = Simantics.peekSession();
            if (session == null) {
                return;
            }
            G2DSceneGraph sg = this.evaluationContext.getSceneGraph();
            if (sg == null) {
                return;
            }
            int k = 0;
            while (k < this.table.columns.size()) {
                List<MonitorInfo> monitorInfos;
                FlagTableColumnInfo slotcolumn = this.table.columns.get(k);
                if (slotcolumn != null && (monitorInfos = slotcolumn.columnHeaders) != null) {
                    int cellInx = 0;
                    for (MonitorInfo slotColumnData : monitorInfos) {
                        String cellNodeName = null;
                        cellNodeName = DrawingFlagTableStyle.cellLookupName(this.tableName, k, 0, cellInx);
                        ++cellInx;
                        TextNode cellNode = (TextNode)NodeUtil.lookup((INode)sg, (String)cellNodeName);
                        if (cellNode == null) continue;
                        String txtValue = "";
                        if (slotColumnData != null && slotColumnData.getText() != null) {
                            txtValue = slotColumnData.getText();
                        }
                        String text = txtValue;
                        try {
                            String value = "";
                            if (slotColumnData.getResource() != null) {
                                value = (String)Simantics.getSession().sync((ReadInterface)new EvaluatePath(slotColumnData.getResource(), text));
                            }
                            if (value == null) continue;
                            cellNode.setText(value.toString());
                        }
                        catch (DatabaseException e) {
                            e.printStackTrace();
                        }
                    }
                }
                ++k;
            }
        }
    }

    public static class RenderTable {
        private FlagTableInfo table = null;
        private String tableName = null;
        private EvaluationContext evaluationContext = null;

        public RenderTable(EvaluationContext evaluationContext, FlagTableInfo table, String tableName) {
            this.table = table;
            this.evaluationContext = evaluationContext;
            this.tableName = tableName;
        }

        public void perform() {
            G2DSceneGraph sg = this.evaluationContext.getSceneGraph();
            if (sg == null) {
                return;
            }
            G2DParentNode nav = (G2DParentNode)sg.getNode("navigation");
            if (nav == null) {
                return;
            }
            String tableNodeName = DrawingFlagTableStyle.tableLookupName(this.tableName);
            RTreeNode tableNode = (RTreeNode)sg.getNode(tableNodeName);
            if (tableNode == null) {
                tableNode = (RTreeNode)ProfileVariables.claimChild((INode)this.evaluationContext.getSceneGraph(), (String)"navigation", (String)tableNodeName, RTreeNode.class, (Observer)this.evaluationContext);
            }
            if (tableNode == null) {
                return;
            }
            tableNode.setTransform(new AffineTransform(this.table.affineTransform));
            tableNode.setLookupId(tableNodeName);
            this.evaluationContext.setProperty((INode)tableNode, DrawingFlagTableStyle.SLOT_TABLE_ELEMENTS, new ArrayList());
            Integer rowCount = this.table.getRowCount();
            if (rowCount <= 0) {
                return;
            }
            String colNodeName = DrawingFlagTableStyle.SLOT_TABLE_PREFIX + this.tableName + DrawingFlagTableStyle.SLOT_TABLE_SEPARATOR + "0";
            RTreeNode colNode = (RTreeNode)sg.getNode(colNodeName);
            if (colNode != null) {
                return;
            }
            tableNode.setZIndex(2);
            int k = -1;
            while (k < rowCount) {
                int lineY = (int)(this.table.getRowHeight().floatValue() * (float)k + this.table.getRowHeight().floatValue());
                if (k == -1 || k + 1 == rowCount) {
                    this.addLine("line_" + k, 0, lineY, this.table.getWidth().intValue(), lineY, 0, tableNode);
                } else {
                    this.addLine("lineEnd_" + k, this.table.getWidth().intValue() - 3, lineY, this.table.getWidth().intValue(), lineY, 0, tableNode);
                    this.addLine("lineStart_" + k, 0, lineY, 3, lineY, 0, tableNode);
                }
                ++k;
            }
            int lineY = (int)(this.table.getRowHeight().floatValue() * (float)rowCount.intValue());
            this.addLine("bar_0", 0, 0, 0, lineY, 2, tableNode);
            this.addLine("bar_last", (int)this.table.getWidth().floatValue(), 0, (int)this.table.getWidth().floatValue(), lineY, 2, tableNode);
            int maxColumnHeaders = 0;
            if (this.table.columns.size() > 0) {
                for (FlagTableColumnInfo column : this.table.columns) {
                    maxColumnHeaders = Math.max(maxColumnHeaders, column.columnHeaders.size());
                }
            }
            String cellNodeName = null;
            TextNode cellNode = null;
            int k2 = 0;
            while (k2 < this.table.columns.size()) {
                colNodeName = DrawingFlagTableStyle.SLOT_TABLE_PREFIX + this.tableName + DrawingFlagTableStyle.SLOT_TABLE_SEPARATOR + k2;
                colNode = (RTreeNode)ProfileVariables.claimChild((INode)this.evaluationContext.getSceneGraph(), (String)("navigation." + tableNodeName), (String)colNodeName, RTreeNode.class, (Observer)this.evaluationContext);
                if (colNode != null) {
                    FlagTableColumnInfo slotcolumn;
                    double cellProcent;
                    float cellWidth;
                    double colX = 0.0;
                    double colXAfter = 0.0;
                    if ((double)this.table.getWeightTotal().floatValue() != 0.0) {
                        double weightBefore = 0.0;
                        int m = 0;
                        while (m < k2) {
                            FlagTableColumnInfo slotcolumn2 = this.table.columns.get(m);
                            if (slotcolumn2 != null && slotcolumn2.getWeight().floatValue() != Float.NaN) {
                                weightBefore += (double)slotcolumn2.getWeight().floatValue();
                            }
                            ++m;
                        }
                        FlagTableColumnInfo slotcolumn3 = this.table.columns.get(k2);
                        colXAfter = (weightBefore + (double)slotcolumn3.getWeight().floatValue()) / (double)this.table.getWeightTotal().floatValue() * (double)this.table.getWidth().floatValue();
                        double procent = weightBefore / (double)this.table.getWeightTotal().floatValue();
                        colX = procent * (double)this.table.getWidth().floatValue();
                        colNode.setTransform(AffineTransform.getTranslateInstance(colX, 0.0));
                    }
                    if ((double)(cellWidth = (float)(cellProcent = (double)((slotcolumn = this.table.columns.get(k2)).getWeight().floatValue() / this.table.getWeightTotal().floatValue())) * this.table.getWidth().floatValue()) < 0.0) {
                        cellWidth = 0.0f;
                    }
                    if (cellWidth != 0.0f) {
                        int lineInx = 0;
                        while (lineInx < rowCount) {
                            List<MonitorInfo> monitorInfos = slotcolumn.columnDatas;
                            if (lineInx < maxColumnHeaders) {
                                monitorInfos = slotcolumn.columnHeaders;
                            }
                            int cellInx = 0;
                            for (MonitorInfo slotColumnData : monitorInfos) {
                                cellNodeName = DrawingFlagTableStyle.cellLookupName(this.tableName, k2, lineInx, cellInx);
                                ++cellInx;
                                cellNode = (TextNode)ProfileVariables.claimChild((INode)this.evaluationContext.getSceneGraph(), (String)("navigation." + tableNodeName + "." + colNodeName), (String)cellNodeName, TextNode.class, (Observer)this.evaluationContext);
                                if (cellNode == null) continue;
                                cellNode.setLookupId(cellNodeName);
                                AffineTransform transform = new AffineTransform();
                                if (slotColumnData != null) {
                                    if (slotColumnData.getFont() != null) {
                                        cellNode.setFont(Fonts.awt((Font)slotColumnData.getFont()));
                                    }
                                    if (slotColumnData.getColor() != null) {
                                        cellNode.setColor(Colors.awt((RGB.Integer)slotColumnData.getColor()));
                                    }
                                    if (slotColumnData.getTransform() != null) {
                                        transform = new AffineTransform(slotColumnData.getTransform());
                                    }
                                }
                                cellNode.setVerticalAlignment((byte)3);
                                double cellY = this.table.getRowHeight().floatValue() * (float)lineInx + 0.8f * this.table.getRowHeight().floatValue();
                                cellNode.setText("");
                                if (lineInx >= maxColumnHeaders && slotcolumn.getType() == FlagTableColumnInfo.TYPE_ROW_NUMBERING) {
                                    cellNode.setText(new Integer(lineInx - maxColumnHeaders + slotcolumn.getStartOffset()).toString());
                                    cellNode.setHorizontalAlignment((byte)0);
                                }
                                cellNode.setBorderWidth(0.0f);
                                cellNode.setPadding(0.0, 0.0);
                                Rectangle2D bounds = cellNode.getBoundsInLocal();
                                transform.translate(0.0, cellY);
                                cellNode.setTransform(transform);
                                cellNode.setFixedWidth(cellWidth);
                            }
                            ++lineInx;
                        }
                    }
                }
                ++k2;
            }
        }

        void addLine(String nodeId, int x1, int y1, int x2, int y2, int cap, RTreeNode parent) {
            Line2D.Float line = new Line2D.Float(x1, y1, x2, y2);
            BasicStroke stroke = new BasicStroke(0.3f, cap, 0);
            ShapeNode shape = (ShapeNode)parent.addNode(nodeId, ShapeNode.class);
            shape.setShape((Shape)line);
            shape.setScaleStroke(false);
            shape.setStroke((Stroke)stroke);
            shape.setFill(false);
            shape.setColor((Paint)new Color(0, 0, 0));
            shape.setZIndex(10);
        }
    }

    static class RowElementHandler
    implements InternalSize,
    Transform,
    ElementAdapter {
        static final RowElementHandler INSTANCE = new RowElementHandler();
        private static final long serialVersionUID = 829379327756475944L;

        private RowElementHandler() {
        }

        public Rectangle2D getBounds(IElement e, Rectangle2D size) {
            if (size == null) {
                size = new Rectangle2D.Double();
            }
            Rectangle2D r = (Rectangle2D)e.getHint(ElementHints.KEY_BOUNDS);
            size.setFrame(r);
            return size;
        }

        public AffineTransform getTransform(IElement e) {
            AffineTransform at = (AffineTransform)e.getHint(ElementHints.KEY_TRANSFORM);
            return at != null ? at : new AffineTransform();
        }

        public void setTransform(IElement e, AffineTransform at) {
            e.setHint(ElementHints.KEY_TRANSFORM, at.clone());
        }

        public <T> T adapt(IElement e, Class<T> toClass) {
            Wrapper ref;
            if (toClass == Resource.class && (ref = (Wrapper)e.getHint(ElementHints.KEY_OBJECT)) != null) {
                return (T)ref.get();
            }
            return null;
        }
    }

    static class RowElementSelectionHandler
    implements SelectionSpecification {
        private static final long serialVersionUID = 2539536175525595035L;
        static final RowElementSelectionHandler INSTANCE = new RowElementSelectionHandler();

        private RowElementSelectionHandler() {
        }

        public Object getAdapter(Class adapter) {
            if (adapter.equals(OutlineColorSpec.class)) {
                return new OutlineColorSpec(){
                    private static final long serialVersionUID = 2372559366005877243L;

                    public void setColor(IElement e, Color c) {
                    }

                    public Color getColor(IElement e) {
                        return new Color(10, 10, 10, 40);
                    }
                };
            }
            if (adapter.equals(FillColor.class)) {
                return new FillColor(){
                    private static final long serialVersionUID = 558080965120741509L;

                    public void setFillColor(IElement e, Color c) {
                    }

                    public Color getFillColor(IElement e) {
                        return new Color(10, 10, 10, 40);
                    }
                };
            }
            if (adapter.equals(Outline.class)) {
                return new Outline(){
                    private static final long serialVersionUID = 272200345438045483L;

                    public Shape getElementShape(IElement e) {
                        return (Shape)e.getHint(ElementHints.KEY_BOUNDS);
                    }
                };
            }
            if (adapter.equals(Transform.class)) {
                return new Transform(){
                    private static final long serialVersionUID = 7653122570884609688L;

                    public AffineTransform getTransform(IElement e) {
                        return (AffineTransform)e.getHint(ElementHints.KEY_TRANSFORM);
                    }

                    public void setTransform(IElement e, AffineTransform at) {
                    }
                };
            }
            if (adapter.equals(StrokeSpec.class)) {
                return new StrokeSpec(){
                    private static final long serialVersionUID = 1074910311375484373L;

                    public Stroke getStroke(IElement e) {
                        return new BasicStroke(0.15f, 2, 2, 10.0f, null, 0.0f);
                    }

                    public void setStroke(IElement e, Stroke at) {
                    }
                };
            }
            return null;
        }
    }

    public static class StyleInfo
    extends Bean {
        public TreeMap<String, FlagTableInfo> name2table;
        public List<FlagInfo> flags;
        @Optional
        public Resource template = null;
    }

    private static class TestSceneGraph
    implements SceneGraph {
        private static final long serialVersionUID = 5749410674482131633L;
        public static final TestSceneGraph INSTANCE = new TestSceneGraph();
        private static final IHintContext.Key KEY_SG = new SceneGraphNodeKey(INode.class, "DEBUG_SG_NODE");

        private TestSceneGraph() {
        }

        public void init(IElement e, G2DParentNode parent) {
            ShapeNode node = (ShapeNode)parent.getOrCreateNode("debug", ShapeNode.class);
            if (node != null) {
                node.setTransform(new AffineTransform(ElementUtils.getTransform((IElement)e)));
                node.setShape((Shape)ElementUtils.getElementBounds((IElement)e));
                node.setFill(true);
                node.setColor((Paint)Color.CYAN);
                e.setHint(KEY_SG, (Object)node);
            }
        }

        public void cleanup(IElement e) {
            ElementUtils.removePossibleNode((IElement)e, (IHintContext.Key)KEY_SG);
        }
    }

    public static class Wrapper
    extends AtomicReference<Resource> {
        private static final long serialVersionUID = -4041629837352874410L;

        public Wrapper(Resource r) {
            super(r);
        }

        @Override
        public String toString() {
            return "IO-" + super.toString();
        }
    }
}

