/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.template2d.ui.actions;

import java.util.Arrays;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.datatypes.DatatypeResource;
import org.simantics.datatypes.literal.Font;
import org.simantics.datatypes.literal.RGB;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.request.Write;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.layer0.Layer0;
import org.simantics.scenegraph.ontology.ScenegraphResources;
import org.simantics.ui.SimanticsUI;

public class NewText
implements ActionFactory {
    public Runnable create(Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        final Resource parent = (Resource)target;
        return new Runnable(){

            @Override
            public void run() {
                SimanticsUI.getSession().asyncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph g) throws DatabaseException {
                        g.markUndoPoint();
                        NewText.createNewText(g, parent);
                    }
                });
            }
        };
    }

    public static Resource createNewText(WriteGraph g, Resource parent) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
        DatatypeResource DATA = DatatypeResource.getInstance((ReadGraph)g);
        G2DResource G2D = G2DResource.getInstance((ReadGraph)g);
        ScenegraphResources SG = ScenegraphResources.getInstance((ReadGraph)g);
        Resource monitor = g.newResource();
        g.claim(monitor, L0.InstanceOf, null, DIA.Scenegraph_Text);
        String name = NameUtils.findFreshName((ReadGraph)g, (String)"Text", (Resource)parent, (Resource)L0.ConsistsOf);
        g.addLiteral(monitor, L0.HasName, L0.NameOf, L0.String, (Object)name, (Binding)Bindings.STRING);
        g.addLiteral(monitor, DIA.Scenegraph_Text_text, DIA.Scenegraph_Monitor_text_Inverse, (Object)"text", (Binding)Bindings.STRING);
        g.addLiteral(monitor, DIA.Scenegraph_AbstractText_width, DIA.Scenegraph_AbstractText_width_Inverse, (Object)Float.valueOf(0.0f), (Binding)Bindings.FLOAT);
        g.addLiteral(monitor, DIA.Scenegraph_AbstractText_horizontalAlignment, DIA.Scenegraph_AbstractText_horizontalAlignment_Inverse, L0.Byte, (Object)0, (Binding)Bindings.BYTE);
        g.addLiteral(monitor, DIA.Scenegraph_AbstractText_color, DIA.Scenegraph_AbstractText_color_Inverse, DATA.RGB_Integer, (Object)new RGB.Integer(0, 0, 0), Bindings.getBindingUnchecked(RGB.Integer.class));
        g.addLiteral(monitor, DIA.Scenegraph_AbstractText_font, DIA.Scenegraph_AbstractText_font_Inverse, DATA.Font, (Object)new Font("Arial", 12, "Normal"), Bindings.getBindingUnchecked(Font.class));
        g.addLiteral(monitor, DIA.Scenegraph_AbstractText_transform, DIA.Scenegraph_AbstractText_transform_Inverse, G2D.Transform, (Object)new Double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0}, Bindings.getBindingUnchecked(Double[].class));
        g.claim(monitor, L0.PartOf, parent);
        Resource list = g.getPossibleObject(parent, SG.Node_children);
        if (list != null) {
            ListUtils.insertBack((WriteGraph)g, (Resource)list, Arrays.asList(monitor));
        }
        return monitor;
    }
}

