/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.ui.wizard;

import java.io.File;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.simantics.db.Resource;
import org.simantics.document.ui.graphfile.FileDocumentUtil;
import org.simantics.document.ui.wizard.FileSelectionPage;

public abstract class FileDocumentImportWizard
extends Wizard {
    FileSelectionPage fileSelectionPage;

    public FileDocumentImportWizard(Resource lib) {
        this.setWindowTitle("Document File import");
        this.setNeedsProgressMonitor(false);
    }

    public abstract Resource getLib();

    public abstract Resource getRel();

    public void addPage(IWizardPage page) {
        this.fileSelectionPage = new FileSelectionPage();
        this.addPage((IWizardPage)this.fileSelectionPage);
    }

    public boolean performFinish() {
        String fileName = this.fileSelectionPage.getFileName();
        if (fileName == null || fileName.length() == 0) {
            return false;
        }
        File file = new File(fileName);
        if (!file.exists() || !file.canRead()) {
            return false;
        }
        FileDocumentUtil.importFileAsync(fileName, this.getLib(), this.getRel());
        return true;
    }
}

