/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.ui.actions;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.document.ui.actions.AddDocumentAction;
import org.simantics.document.ui.graphfile.FileDocumentUtil;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.ui.ExceptionUtils;

public class ImportDocument
extends AddDocumentAction {
    public ImportDocument(ReadGraph graph, String relationUri) throws DatabaseException {
        super(graph, relationUri);
    }

    public Runnable create(Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        final Resource resource = (Resource)target;
        return new Runnable(){

            @Override
            public void run() {
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*.*"});
                final String filename = dialog.open();
                if (filename == null) {
                    return;
                }
                Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        graph.markUndoPoint();
                        Resource newDoc = FileDocumentUtil.importFileWithName(graph, filename);
                        ImportDocument.this.linkDocument(graph, resource, newDoc);
                    }
                }, (Callback)new Callback<DatabaseException>(){

                    public void run(DatabaseException parameter) {
                        if (parameter != null) {
                            ExceptionUtils.logAndShowError((String)"Cannot import document.", (Throwable)parameter);
                        }
                    }
                });
            }
        };
    }
}

