/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.ui.actions;

import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.adapter.DropActionFactory;
import org.simantics.db.request.Write;
import org.simantics.document.DocumentResource;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ISelectionUtils;

public class FolderDropAction
implements DropActionFactory {
    private Resource folderType;
    private Resource relation;
    private Resource inverse;

    public FolderDropAction(ReadGraph graph, String folderUri, String relationUri) throws DatabaseException {
        this.folderType = graph.getResource(folderUri);
        this.relation = graph.getResource(relationUri);
        this.inverse = graph.getPossibleInverse(this.relation);
    }

    public Runnable create(ReadGraph g, Object target, Object source, int operation) throws DatabaseException {
        final Resource lib = (Resource)ISelectionUtils.getSinglePossibleKey((Object)target, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        if (lib == null) {
            return null;
        }
        final List selections = ISelectionUtils.getPossibleKeys((Object)source, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        if (selections.isEmpty()) {
            return null;
        }
        if (!g.isInstanceOf(lib, this.folderType)) {
            return null;
        }
        DocumentResource doc = DocumentResource.getInstance((ReadGraph)g);
        for (Resource r : selections) {
            if (g.isInstanceOf(r, doc.Document)) continue;
            return null;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SimanticsUI.getSession().asyncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        for (Resource r : selections) {
                            if (graph.hasStatement(lib, FolderDropAction.this.relation, r)) continue;
                            if (FolderDropAction.this.inverse != null) {
                                Resource r2 = graph.getPossibleObject(r, FolderDropAction.this.inverse);
                                if (r2 != null && !graph.isInstanceOf(r2, FolderDropAction.this.folderType)) continue;
                                graph.deny(r, FolderDropAction.this.inverse);
                            }
                            graph.claim(lib, FolderDropAction.this.relation, r);
                        }
                    }
                });
            }
        };
        return runnable;
    }
}

