/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.ui.actions;

import java.io.File;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.request.Read;
import org.simantics.document.DocumentResource;
import org.simantics.graphfile.ontology.GraphFileResource;
import org.simantics.graphfile.util.GraphFileUtil;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.ui.ExceptionUtils;

public class ExportDocumentFile
implements ActionFactory {
    public Runnable create(Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        final Resource resource = (Resource)target;
        return new Runnable(){

            @Override
            public void run() {
                try {
                    String resourceName = (String)SimanticsUI.getSession().syncRequest((Read)new Read<String>(){

                        public String perform(ReadGraph graph) throws DatabaseException {
                            DocumentResource doc = DocumentResource.getInstance((ReadGraph)graph);
                            GraphFileResource gf = GraphFileResource.getInstance((ReadGraph)graph);
                            if (!graph.isInstanceOf(resource, doc.FileDocument)) {
                                return null;
                            }
                            return (String)graph.getPossibleRelatedValue(resource, gf.HasResourceName);
                        }
                    });
                    FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
                    dialog.setFileName(resourceName);
                    String filename = dialog.open();
                    if (filename == null) {
                        return;
                    }
                    ExportDocumentFile.exportDocument(resource, filename);
                }
                catch (DatabaseException e) {
                    ExceptionUtils.logAndShowError((String)"Cannot export document.", (Throwable)e);
                }
            }
        };
    }

    public static void exportDocument(Resource document, String fileName) throws DatabaseException {
        GraphFileUtil.writeDataToFile((Resource)document, (File)new File(fileName));
    }
}

