/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.views;

import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.ViewPart;
import org.simantics.Simantics;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.swt.SingleSelectionInputSource;
import org.simantics.browsing.ui.swt.widgets.GraphExplorerComposite;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupportImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.document.DocumentResource;
import org.simantics.document.linking.Activator;
import org.simantics.document.linking.adapters.SourceObjectAdapter;
import org.simantics.document.linking.ge.Constants;
import org.simantics.document.linking.ge.MultiSelectionProvider;
import org.simantics.document.linking.ge.SourceLinkExplorerComposite;
import org.simantics.document.linking.views.ModelRead;
import org.simantics.document.linking.views.ModelToComboListener;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.datastructures.ArrayMap;
import org.simantics.utils.ui.AdaptionUtils;

public class SourceView
extends ViewPart
implements ISelectionListener,
IPartListener {
    public static final String ID = "org.simantics.document.linking.views.SourceView";
    private Composite composite;
    private Action pinSelectionAction;
    private Action linkAllAction;
    private Action linkDocumentsAction;
    private WidgetSupport support;
    private GraphExplorerComposite objectExplorer;
    private GraphExplorerComposite propertyExplorer;
    private MultiSelectionProvider selectionProvider;
    private GraphExplorerComposite browseExplorer;
    private TabFolder tabFolder;
    Composite linkComposite;
    Composite browseComposite;
    private boolean pinSelection = false;
    Resource currentModel;
    private ModelToComboListener modelToComboListener;
    private CCombo modelCombo;
    private AcceptedObject acceptedObject = AcceptedObject.DOCUMENT;
    IWorkbenchPart selectionEventFilter = null;

    public SourceView() {
        this.support = new WidgetSupportImpl();
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new FillLayout());
        this.tabFolder = new TabFolder(this.composite, 0);
        TabItem link = new TabItem(this.tabFolder, 0);
        link.setText("Linking");
        TabItem browse = new TabItem(this.tabFolder, 0);
        browse.setText("Browsing");
        this.linkComposite = new Composite((Composite)this.tabFolder, 0);
        link.setControl((Control)this.linkComposite);
        this.browseComposite = new Composite((Composite)this.tabFolder, 0);
        browse.setControl((Control)this.browseComposite);
        this.selectionProvider = new MultiSelectionProvider();
        this.createLinkTab(this.linkComposite);
        this.createBrowseTab(this.browseComposite);
        this.getSite().getPage().addPostSelectionListener((ISelectionListener)this);
        this.getSite().getPage().addPartListener((IPartListener)this);
        this.makeActions();
        this.contributeToActionBars();
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
    }

    public void dispose() {
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this);
        this.getSite().getPage().removePartListener((IPartListener)this);
    }

    private void createBrowseTab(Composite browseComposite) {
        browseComposite.setLayout((Layout)new GridLayout(2, false));
        this.modelCombo = new CCombo(browseComposite, 2056);
        WidgetSupportImpl support = new WidgetSupportImpl();
        SimanticsUI.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                Resource project = (Resource)SimanticsUI.getProject().get();
                SourceView.this.modelToComboListener = new ModelToComboListener(SourceView.this.modelCombo){

                    @Override
                    public Resource getCurrentModel() {
                        return (this).SourceView.this.currentModel;
                    }
                };
                graph.syncRequest((Read)new ModelRead(project), (org.simantics.db.procedure.Listener)SourceView.this.modelToComboListener);
            }
        });
        Button checkingButton = new Button(browseComposite, 2);
        checkingButton.setText("All");
        checkingButton.addSelectionListener((SelectionListener)new SelectionAdapter((WidgetSupport)support, browseComposite){
            private final /* synthetic */ WidgetSupport val$support;
            private final /* synthetic */ Composite val$browseComposite;
            {
                this.val$support = widgetSupport;
                this.val$browseComposite = composite;
            }

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                boolean checked = button.getSelection();
                SourceView.this.browseExplorer.dispose();
                SourceView.this.createModelExplorer(checked, this.val$support, this.val$browseComposite);
                button.setText(checked ? "Old/Removed" : "All");
                if (SourceView.this.currentModel != null) {
                    SourceView.this.setModel(SourceView.this.currentModel, true);
                }
                this.val$browseComposite.getParent().layout(true, true);
            }
        });
        this.createModelExplorer(false, (WidgetSupport)support, browseComposite);
        this.modelCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = SourceView.this.modelCombo.getSelectionIndex();
                if (index == -1) {
                    return;
                }
                Resource model = (Resource)SourceView.this.modelCombo.getData(Integer.toString(index));
                if (model != null) {
                    SourceView.this.setModel(model);
                }
            }
        });
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)this.modelCombo);
    }

    private void createModelExplorer(boolean onlyCheckable, WidgetSupport support, Composite browseComposite) {
        this.browseExplorer = new SourceLinkExplorerComposite((Map<String, Object>)ArrayMap.keys((Object[])new String[]{"displaySelectors", "displayFilter", "treeView"}).values(new Object[]{false, false, true}), this.selectionProvider, (IWorkbenchSite)this.getSite(), browseComposite, support, false, 67588);
        if (!onlyCheckable) {
            this.browseExplorer.setBrowseContexts(new String[]{"http://www.simantics.org/DocumentLink-1.0/ModelViewpointBrowseContext", "http://www.simantics.org/DocumentLink-1.0/ModelViewpointActionContext"});
        } else {
            this.browseExplorer.setBrowseContexts(new String[]{"http://www.simantics.org/DocumentLink-1.0/ModelViewpointBrowseContext2", "http://www.simantics.org/DocumentLink-1.0/ModelViewpointActionContext"});
        }
        this.browseExplorer.setColumns(Constants.SOURCE_OBJECT_COLUMNS);
        this.browseExplorer.setInputSource((GraphExplorerComposite.InputSource)new SingleSelectionInputSource(Resource.class));
        this.browseExplorer.getExplorer().setAutoExpandLevel(2);
        this.browseExplorer.setColumnsVisible(true);
        this.browseExplorer.setContextMenuId("#SourceModelViewPopup");
        this.browseExplorer.finish();
        ((Tree)this.browseExplorer.getExplorer().getControl()).setLinesVisible(true);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 1).applyTo((Control)this.browseExplorer);
    }

    private void createLinkTab(final Composite linkComposite) {
        this.objectExplorer = new SourceLinkExplorerComposite((Map<String, Object>)ArrayMap.keys((Object[])new String[]{"displaySelectors", "displayFilter", "treeView"}).values(new Object[]{false, false, true}), this.selectionProvider, (IWorkbenchSite)this.getSite(), linkComposite, this.support, 67588);
        this.objectExplorer.setBrowseContexts(new String[]{"http://www.simantics.org/DocumentLink-1.0/SourceObjectViewpointBrowseContext", "http://www.simantics.org/DocumentLink-1.0/SourceObjectViewpointActionContext"});
        this.objectExplorer.setColumns(Constants.SOURCE_OBJECT_COLUMNS);
        this.objectExplorer.setInputSource((GraphExplorerComposite.InputSource)new SingleSelectionInputSource(Resource.class));
        this.objectExplorer.getExplorer().setAutoExpandLevel(2);
        this.objectExplorer.setColumnsVisible(true);
        this.objectExplorer.setContextMenuId("#SourceObjectViewPopup");
        this.objectExplorer.finish();
        ((Tree)this.objectExplorer.getExplorer().getControl()).setLinesVisible(true);
        final Sash sash = new Sash(linkComposite, 256);
        this.propertyExplorer = new SourceLinkExplorerComposite((Map<String, Object>)ArrayMap.keys((Object[])new String[]{"displaySelectors", "displayFilter", "treeView"}).values(new Object[]{false, false, true}), this.selectionProvider, (IWorkbenchSite)this.getSite(), linkComposite, this.support, 67588);
        this.propertyExplorer.setBrowseContexts(new String[]{"http://www.simantics.org/DocumentLink-1.0/SourcePropertyViewpointBrowseContext", "http://www.simantics.org/DocumentLink-1.0/SourcePropertyViewpointActionContext"});
        this.propertyExplorer.setColumns(Constants.SOURCE_COLUMNS);
        this.propertyExplorer.setInputSource((GraphExplorerComposite.InputSource)new SingleSelectionInputSource(Resource.class));
        this.propertyExplorer.getExplorer().setAutoExpandLevel(2);
        this.propertyExplorer.setColumnsVisible(true);
        this.propertyExplorer.setContextMenuId("#SourcePropertyViewPopup");
        this.propertyExplorer.finish();
        ((Tree)this.propertyExplorer.getExplorer().getControl()).setLinesVisible(true);
        FormLayout form = new FormLayout();
        linkComposite.setLayout((Layout)form);
        FormData button1Data = new FormData();
        button1Data.left = new FormAttachment(0, 0);
        button1Data.right = new FormAttachment(100, 0);
        button1Data.top = new FormAttachment(0, 0);
        button1Data.bottom = new FormAttachment((Control)sash, 0);
        this.objectExplorer.setLayoutData((Object)button1Data);
        int limit = 40;
        int percent = 20;
        final FormData sashData = new FormData();
        sashData.left = new FormAttachment(0, 0);
        sashData.right = new FormAttachment(100, 0);
        sashData.top = new FormAttachment(20, 0);
        sash.setLayoutData((Object)sashData);
        sash.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Rectangle sashRect = sash.getBounds();
                Rectangle shellRect = linkComposite.getClientArea();
                int top = shellRect.height - sashRect.height - 40;
                e.y = Math.max(Math.min(e.y, top), 40);
                if (e.y != sashRect.y) {
                    sashData.top = new FormAttachment(0, e.y);
                    linkComposite.layout();
                }
            }
        });
        FormData button2Data = new FormData();
        button2Data.left = new FormAttachment(0, 0);
        button2Data.right = new FormAttachment(100, 0);
        button2Data.top = new FormAttachment((Control)sash, 0);
        button2Data.bottom = new FormAttachment(100, 0);
        this.propertyExplorer.setLayoutData((Object)button2Data);
    }

    public void partActivated(IWorkbenchPart part) {
        if (!(part instanceof IEditorPart)) {
            this.selectionEventFilter = part;
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part == this) {
            return;
        }
        if (this.pinSelection) {
            return;
        }
        if (part == this.selectionEventFilter) {
            this.selectionEventFilter = null;
            return;
        }
        this.selectionEventFilter = null;
        final Resource res = (Resource)AdaptionUtils.adaptToSingle((Object)selection, Resource.class);
        if (res == null) {
            return;
        }
        try {
            final Resource selected = (Resource)SimanticsUI.getSession().syncRequest((Read)new Read<Resource>(){

                public Resource perform(ReadGraph graph) throws DatabaseException {
                    try {
                        SourceObjectAdapter adapter = (SourceObjectAdapter)graph.adapt(res, SourceObjectAdapter.class);
                        return adapter.getDocumentableResource(graph, res);
                    }
                    catch (AdaptionException e) {
                        return res;
                    }
                }
            });
            if (selected == null) {
                return;
            }
            if (this.acceptedObject == AcceptedObject.DOCUMENT && ((Boolean)Simantics.getSession().syncRequest((Read)new IsDocumentRead(selected))).booleanValue()) {
                return;
            }
            StructuredSelection realSelection = new StructuredSelection((Object)selected);
            this.objectExplorer.setInput(SimanticsUI.getSessionContext(), (Object)realSelection);
            this.propertyExplorer.setInput(SimanticsUI.getSessionContext(), (Object)realSelection);
            Simantics.getSession().asyncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    String name = NameUtils.getSafeLabel((ReadGraph)graph, (Resource)selected);
                    if (name.length() == 0) {
                        name = NameUtils.getSafeName((ReadGraph)graph, (Resource)selected);
                    }
                    final String title = name;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SourceView.this.setPartName(title);
                        }
                    });
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.linkAllAction);
        manager.add((IAction)this.linkDocumentsAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.pinSelectionAction);
    }

    private void makeActions() {
        this.pinSelectionAction = new Action("Pin selection", 2){

            public void run() {
                SourceView.this.pinSelection = this.isChecked();
            }
        };
        this.pinSelectionAction.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"com.famfamfam.silk", (String)"icons/lock.png"));
        this.linkAllAction = new Action("Link All", 8){

            public void run() {
                SourceView.this.setAcceptedObject(AcceptedObject.ALL);
            }
        };
        this.linkDocumentsAction = new Action("Link Documents", 8){

            public void run() {
                SourceView.this.setAcceptedObject(AcceptedObject.DOCUMENT);
            }
        };
        this.setAcceptedObject(AcceptedObject.DOCUMENT);
    }

    public void setAcceptedObject(AcceptedObject acceptedObject) {
        this.acceptedObject = acceptedObject;
        if (acceptedObject == AcceptedObject.ALL) {
            this.linkAllAction.setChecked(true);
            this.linkDocumentsAction.setChecked(false);
        } else {
            this.linkAllAction.setChecked(false);
            this.linkDocumentsAction.setChecked(true);
        }
    }

    public void setFocus() {
        this.composite.setFocus();
    }

    public void setModel(Resource model) {
        this.setModel(model, false);
    }

    public void setModel(Resource model, boolean force) {
        if (!force && model.equals(this.currentModel)) {
            return;
        }
        this.currentModel = model;
        int i = 0;
        while (i < this.modelCombo.getItemCount()) {
            Resource r = (Resource)this.modelCombo.getData(Integer.toString(i));
            if (model.equals(r)) {
                this.modelCombo.select(i);
                StructuredSelection realSelection = new StructuredSelection((Object)this.currentModel);
                this.browseExplorer.setInput(SimanticsUI.getSessionContext(), (Object)realSelection);
                return;
            }
            ++i;
        }
        this.modelCombo.select(-1);
        StructuredSelection realSelection = new StructuredSelection();
        this.browseExplorer.setInput(SimanticsUI.getSessionContext(), (Object)realSelection);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == GraphExplorer.class) {
            return this.browseExplorer.getExplorer();
        }
        return super.getAdapter(adapter);
    }

    public static enum AcceptedObject {
        ALL,
        DOCUMENT;

    }

    private class IsDocumentRead
    extends ResourceRead<Boolean> {
        public IsDocumentRead(Resource resource) {
            super(resource);
        }

        public Boolean perform(ReadGraph graph) throws DatabaseException {
            DocumentResource doc = DocumentResource.getInstance((ReadGraph)graph);
            return graph.isInstanceOf(this.resource, doc.Document);
        }
    }
}

