/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.report.templates;

import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.document.linking.report.templates.ResourceNameComparator;

class SourceParentHierarchyComparator
extends ResourceNameComparator {
    DocumentLink sl;

    public SourceParentHierarchyComparator(ReadGraph graph, Resource model) {
        super(graph, model);
        this.sl = DocumentLink.getInstance((ReadGraph)graph);
    }

    @Override
    public int compare(Resource o1, Resource o2) {
        try {
            Resource r1 = this.graph.getSingleObject(o1, this.sl.hasSource_Inverse);
            Resource r2 = this.graph.getSingleObject(o2, this.sl.hasSource_Inverse);
            List<Resource> path1 = this.getPath(r1);
            List<Resource> path2 = this.getPath(r2);
            int count = Math.min(path1.size(), path2.size());
            int i = 0;
            while (i < count) {
                int comp = super.compare(path1.get(i), path2.get(i));
                if (comp != 0) {
                    return comp;
                }
                ++i;
            }
            return path1.size() - path2.size();
        }
        catch (Exception e) {
            return 0;
        }
    }
}

