/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.report.templates;

import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.document.linking.report.templates.ResourceNameComparator;
import org.simantics.modeling.ModelingResources;

class SourceParentDiagramComparator
extends ResourceNameComparator {
    DocumentLink sl;
    ModelingResources mod;

    public SourceParentDiagramComparator(ReadGraph graph, Resource model) {
        super(graph, model);
        this.sl = DocumentLink.getInstance((ReadGraph)graph);
        this.mod = ModelingResources.getInstance((ReadGraph)graph);
    }

    @Override
    public int compare(Resource o1, Resource o2) {
        try {
            Resource r1 = this.graph.getSingleObject(o1, this.sl.hasSource_Inverse);
            Resource r2 = this.graph.getSingleObject(o2, this.sl.hasSource_Inverse);
            List<Resource> path1 = this.getPath(r1);
            List<Resource> path2 = this.getPath(r2);
            int diag1 = -1;
            int diag2 = -1;
            int i = path1.size() - 1;
            while (i >= 0) {
                if (this.graph.hasStatement(path1.get(i), this.mod.CompositeToDiagram)) {
                    diag1 = i;
                    break;
                }
                --i;
            }
            i = path2.size() - 1;
            while (i >= 0) {
                if (this.graph.hasStatement(path2.get(i), this.mod.CompositeToDiagram)) {
                    diag2 = i;
                    break;
                }
                --i;
            }
            int count = Math.min(diag1, diag2);
            int i2 = 0;
            int comp = 0;
            while (i2 <= count) {
                comp = super.compare(path1.get(i2), path2.get(i2));
                if (comp != 0) {
                    return comp;
                }
                ++i2;
            }
            return diag1 - diag2;
        }
        catch (Exception e) {
            return 0;
        }
    }
}

