/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.report.templates;

import java.util.Comparator;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.strings.AlphanumComparator;

public class PathComparator
implements Comparator<List<Resource>> {
    private ReadGraph graph;

    public PathComparator(ReadGraph graph) {
        this.graph = graph;
    }

    @Override
    public int compare(List<Resource> o1, List<Resource> o2) {
        int common = Math.min(o1.size(), o2.size());
        int i = 0;
        while (i < common) {
            if (!o1.get(i).equals(o2.get(i))) {
                int c;
                block7: {
                    Resource r2;
                    Resource r1;
                    block8: {
                        try {
                            r1 = o1.get(i);
                            r2 = o2.get(i);
                            String l1 = this.getText(r1);
                            String l2 = this.getText(r2);
                            c = AlphanumComparator.COMPARATOR.compare((Object)l1, (Object)l2);
                            if (c != 0) break block7;
                            if (r1.getResourceId() <= r2.getResourceId()) break block8;
                            return 1;
                        }
                        catch (DatabaseException e) {
                            return 0;
                        }
                    }
                    if (r1.getResourceId() < r2.getResourceId()) {
                        return -1;
                    }
                    return 0;
                }
                return c;
            }
            ++i;
        }
        return o1.size() - o2.size();
    }

    public String getText(Resource r) throws DatabaseException {
        String l1 = NameUtils.getSafeLabel((ReadGraph)this.graph, (Resource)r);
        if (l1.length() == 0) {
            l1 = NameUtils.getSafeName((ReadGraph)this.graph, (Resource)r);
        }
        return l1;
    }
}

