/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.report.html;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.simantics.document.linking.report.html.HTMLElement;

public class HTMLStreamElement
implements HTMLElement {
    protected HTMLStreamElement parent;
    protected File file;
    protected PrintStream os;

    public HTMLStreamElement(File file) throws Exception {
        this.parent = null;
        this.file = file;
        this.os = new PrintStream(file, "UTF-8");
    }

    public HTMLStreamElement(HTMLStreamElement parent) throws Exception {
        this.parent = parent;
        this.openStream();
    }

    private void openStream() throws IOException {
        this.file = File.createTempFile("report_content", ".html");
        this.os = new PrintStream(this.file, "UTF-8");
    }

    protected void copyData(File source, PrintStream dest) throws Exception {
        int read;
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(source));
        while ((read = is.read()) != -1) {
            dest.write(read);
        }
        is.close();
    }

    public PrintStream getPrintStream() {
        return this.os;
    }

    public void close() throws Exception {
        this.os.flush();
        this.os.close();
        if (this.parent != null) {
            this.copyData(this.file, this.parent.os);
            this.file.delete();
        }
        this.os = null;
    }

    @Override
    public String getId() {
        return null;
    }
}

