/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.ge;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.content.ImageDecorator;
import org.simantics.browsing.ui.model.imagedecorators.ImageDecorationRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.DocumentResource;
import org.simantics.document.linking.Activator;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.document.linking.utils.SourceLinkUtil;
import org.simantics.utils.ui.gfx.DecorationOverlayIcon;

public class VariableImageDecorationRule
implements ImageDecorationRule {
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Variable.class);
    }

    public ImageDecorator getImageDecorator(ReadGraph graph, Object content) throws DatabaseException {
        Variable v = (Variable)content;
        Resource r = v.getPossibleRepresents(graph);
        if (r == null) {
            return null;
        }
        DocumentLink sl = DocumentLink.getInstance((ReadGraph)graph);
        DocumentResource doc = DocumentResource.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(r, sl.Source)) {
            Resource reference = SourceLinkUtil.getReferredDocument(graph, r);
            if (reference != null) {
                if (graph.hasStatement(reference, doc.HasNewerVersion)) {
                    return new Dec(Activator.getDefault().clock_red);
                }
            } else {
                return new Dec(Activator.getDefault().cross);
            }
        }
        return null;
    }

    private ImageDescriptor getDecoration(ImageDescriptor original, ImageDescriptor decorator) {
        return original == null ? decorator : new DecorationOverlayIcon(original, decorator, 3);
    }

    private class Dec
    implements ImageDecorator {
        private ImageDescriptor decorator;

        public Dec(ImageDescriptor decorator) {
            this.decorator = decorator;
        }

        public <Image> Image decorateImage(Image image, String column, int itemIndex) {
            return (Image)VariableImageDecorationRule.this.getDecoration((ImageDescriptor)image, this.decorator);
        }
    }
}

