/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.ge;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.DropActionFactory;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Write;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.document.linking.utils.SourceLinkUtil;
import org.simantics.layer0.Layer0;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.ui.AdaptionUtils;

public class SourceObjectDropAction
implements DropActionFactory {
    public Runnable create(ReadGraph g, Object target, Object source, int operation) throws DatabaseException {
        Variable sv;
        Variable t = (Variable)target;
        Resource s = (Resource)AdaptionUtils.adaptToSingle((Object)source, Resource.class);
        if (s == null && (sv = (Variable)AdaptionUtils.adaptToSingle((Object)source, Variable.class)) != null) {
            s = sv.getRepresents(g);
        }
        if (t == null || s == null) {
            return null;
        }
        DocumentLink sl = DocumentLink.getInstance((ReadGraph)g);
        if (g.isInstanceOf(s, sl.Source)) {
            return null;
        }
        return this.getRunnable(t, s);
    }

    private Runnable getRunnable(final Variable tv, final Resource s) {
        return new Runnable(){

            @Override
            public void run() {
                SimanticsUI.getSession().asyncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                        Resource relation = tv.getPossiblePredicateResource((ReadGraph)graph);
                        Resource instance = relation != null && graph.isInstanceOf(relation, l0.FunctionalRelation) ? tv.getParent((ReadGraph)graph).getPossibleRepresents((ReadGraph)graph) : tv.getPossibleRepresents((ReadGraph)graph);
                        if (instance == null) {
                            return;
                        }
                        try {
                            SourceLinkUtil.createDocumentLink(graph, instance, relation, s);
                        }
                        catch (DatabaseException e) {
                            String l = NameUtils.getSafeLabel((ReadGraph)graph, (Resource)s);
                            if (l.length() == 0) {
                                l = NameUtils.getSafeName((ReadGraph)graph, (Resource)s);
                            }
                            final String label = l;
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    String dialogMessage = "Cannot create document link to \"" + label + "\":" + e.getMessage();
                                    MessageDialog dialog = new MessageDialog(Display.getCurrent().getActiveShell(), "Document Link", null, dialogMessage, 2, new String[]{"OK"}, 0);
                                    dialog.open();
                                }
                            });
                        }
                    }
                });
            }
        };
    }
}

