/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.ge;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.browsing.ui.model.children.ChildRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.StandardGraphChildVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.document.linking.utils.SourceLinkUtil;

public class ObjectChildRule
implements ChildRule {
    private boolean showOnlyCheckable = false;

    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class) || contentType.equals(Variable.class);
    }

    public void setShowOnlyCheckable(boolean showOnlyCheckable) {
        this.showOnlyCheckable = showOnlyCheckable;
    }

    public Collection<?> getChildren(ReadGraph graph, Object obj) throws DatabaseException {
        Resource rel;
        Collection sources;
        ArrayList<StandardGraphChildVariable> children = new ArrayList<StandardGraphChildVariable>();
        Resource resource = null;
        Variable variable = null;
        if (obj instanceof Resource) {
            resource = (Resource)obj;
            try {
                variable = (Variable)graph.adapt(resource, Variable.class);
            }
            catch (Throwable t) {
                return children;
            }
            children.add(new StandardGraphChildVariable(variable, null, resource));
            return children;
        }
        variable = (Variable)obj;
        resource = variable.getPossibleRepresents(graph);
        DocumentLink sl = DocumentLink.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(resource, sl.Source)) {
            return children;
        }
        Variable parentVariable = variable.getParent(graph);
        Resource parentRes = null;
        Resource relation = null;
        if (parentVariable != null) {
            parentRes = parentVariable.getPossibleRepresents(graph);
            relation = variable.getPossiblePredicateResource(graph);
        }
        if (parentRes != null && relation != null) {
            sources = graph.getObjects(parentRes, sl.hasSource);
            for (Resource source : sources) {
                rel = graph.getPossibleObject(source, sl.consernsRelation);
                if (rel == null || !rel.equals(relation) || this.showOnlyCheckable && SourceLinkUtil.isValidSource(graph, source) && SourceLinkUtil.isUpToDateSource(graph, source)) continue;
                children.add(new StandardGraphChildVariable(variable, null, source));
            }
        }
        sources = graph.getObjects(resource, sl.hasSource);
        for (Resource source : sources) {
            rel = graph.getPossibleObject(source, sl.consernsRelation);
            if (rel != null || this.showOnlyCheckable && SourceLinkUtil.isValidSource(graph, source) && SourceLinkUtil.isUpToDateSource(graph, source)) continue;
            children.add(new StandardGraphChildVariable(variable, null, source));
        }
        while (children.remove(variable)) {
        }
        return children;
    }

    public Collection<?> getParents(ReadGraph graph, Object child) throws DatabaseException {
        return new ArrayList();
    }
}

