/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.ge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.document.linking.ge.ModelChildRule;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.document.linking.utils.SourceLinkUtil;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.ExceptionUtils;

public class FixAllReferencesAction
implements ActionFactory {
    public Runnable create(final Object target) {
        return new Runnable(){

            @Override
            public void run() {
                System.out.println(target);
                try {
                    Pair refs = (Pair)Simantics.getSession().syncRequest((Read)new FindFixable(target));
                    String dialogTitle = "Fix References";
                    String dialogMessage = "Fix " + ((Collection)refs.first).size() + " old references and " + ((Collection)refs.second).size() + " removed references?";
                    String[] dialogButtonLabels = new String[]{"Ok", "Cancel"};
                    int defaultIndex = 0;
                    if (((Collection)refs.first).size() == 0 && ((Collection)refs.second).size() == 0) {
                        dialogMessage = "Nothing to fix.";
                        dialogButtonLabels = new String[]{"OK"};
                        MessageDialog dialog = new MessageDialog(Display.getCurrent().getActiveShell(), dialogTitle, null, dialogMessage, 5, dialogButtonLabels, defaultIndex);
                        dialog.open();
                        return;
                    }
                    MessageDialog dialog = new MessageDialog(Display.getCurrent().getActiveShell(), dialogTitle, null, dialogMessage, 5, dialogButtonLabels, defaultIndex);
                    if (dialog.open() != 0) {
                        return;
                    }
                    Simantics.getSession().markUndoPoint();
                    Simantics.getSession().syncRequest((Write)new FixAll((Pair<Collection<Resource>, Collection<Resource>>)refs));
                }
                catch (DatabaseException e) {
                    ExceptionUtils.logAndShowError((String)"Cannot fix references", (Throwable)e);
                }
            }
        };
    }

    public static class FindFixable
    implements Read<Pair<Collection<Resource>, Collection<Resource>>> {
        List<Resource> old;
        List<Resource> removed;
        Object target;

        public FindFixable(Object target) {
            this.target = target;
        }

        public Pair<Collection<Resource>, Collection<Resource>> perform(ReadGraph graph) throws DatabaseException {
            this.old = new ArrayList<Resource>();
            this.removed = new ArrayList<Resource>();
            DocumentLink sl = DocumentLink.getInstance((ReadGraph)graph);
            ModelChildRule modelChildRule = new ModelChildRule(graph, sl.ModelViewpointBrowseContext2_ChildRule);
            Stack<Object> stack = new Stack<Object>();
            stack.add(this.target);
            while (!stack.isEmpty()) {
                Object o = stack.pop();
                Collection<?> children = modelChildRule.getChildren(graph, o);
                if (children.size() == 0) {
                    if (o instanceof Variable) {
                        Variable v = (Variable)o;
                        Resource r = v.getPossibleRepresents(graph);
                        this.process(graph, r);
                        continue;
                    }
                    if (!(o instanceof Resource)) continue;
                    Resource r = (Resource)o;
                    this.process(graph, r);
                    continue;
                }
                stack.addAll(children);
            }
            Pair result = new Pair(this.old, this.removed);
            this.old = null;
            this.removed = null;
            return result;
        }

        void process(ReadGraph graph, Resource r) throws DatabaseException {
            if (SourceLinkUtil.isValidSource(graph, r)) {
                if (!SourceLinkUtil.isUpToDateSource(graph, r) && !this.old.contains(r)) {
                    this.old.add(r);
                }
            } else if (SourceLinkUtil.isSource(graph, r) && !this.removed.contains(r)) {
                this.removed.add(r);
            }
        }
    }

    public static class FixAll
    extends WriteRequest {
        Pair<Collection<Resource>, Collection<Resource>> refs;

        public FixAll(Pair<Collection<Resource>, Collection<Resource>> refs) {
            this.refs = refs;
        }

        public void perform(WriteGraph graph) throws DatabaseException {
            Collection old = (Collection)this.refs.first;
            Collection removed = (Collection)this.refs.second;
            for (Resource r : old) {
                SourceLinkUtil.updateToLatest(graph, r);
            }
            for (Resource r : removed) {
                graph.deny(r);
            }
        }
    }

    public static class FixAllSilent
    extends WriteRequest {
        Resource target;

        public FixAllSilent(Resource target) {
            this.target = target;
        }

        public void perform(WriteGraph graph) throws DatabaseException {
            DocumentLink sl = DocumentLink.getInstance((ReadGraph)graph);
            ModelChildRule modelChildRule = new ModelChildRule((ReadGraph)graph, sl.ModelViewpointBrowseContext2_ChildRule);
            Stack<Object> stack = new Stack<Object>();
            stack.add(this.target);
            while (!stack.isEmpty()) {
                Object o = stack.pop();
                Collection<?> children = modelChildRule.getChildren((ReadGraph)graph, o);
                if (children.size() == 0) {
                    if (o instanceof Variable) {
                        Variable v = (Variable)o;
                        Resource r = v.getPossibleRepresents((ReadGraph)graph);
                        this.process(graph, r);
                        continue;
                    }
                    if (!(o instanceof Resource)) continue;
                    Resource r = (Resource)o;
                    this.process(graph, r);
                    continue;
                }
                stack.addAll(children);
            }
        }

        void process(WriteGraph graph, Resource r) throws DatabaseException {
            if (SourceLinkUtil.isValidSource((ReadGraph)graph, r)) {
                SourceLinkUtil.updateToLatest(graph, r);
            } else {
                graph.deny(r);
            }
        }
    }
}

