/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.server.protocol;

import java.nio.ByteOrder;
import org.simantics.db.server.protocol.AbstractFunction;
import org.simantics.db.server.protocol.DataBuffer;

public class GetResourceSegmentFunction
extends AbstractFunction {
    public byte[] clusterUID = null;
    public int resourceIndex = 0;
    public long segmentOffset = 0L;
    public short segmentSize = 0;
    public boolean isExternalResource = false;
    public long valueSize = 0L;
    public byte[] segment = null;

    public GetResourceSegmentFunction() {
        super(31, 32);
    }

    public GetResourceSegmentFunction(byte[] clusterUID, int resourceIndex, long segmentOffset, short segmentSize) {
        super(31, 32);
        this.clusterUID = clusterUID;
        this.resourceIndex = resourceIndex;
        this.segmentOffset = segmentOffset;
        this.segmentSize = segmentSize;
    }

    @Override
    public DataBuffer serialize(ByteOrder byteOrder) {
        this.buffer.clear();
        this.buffer.order(byteOrder);
        this.buffer.put(this.clusterUID);
        this.buffer.put(this.resourceIndex);
        this.buffer.put(this.segmentOffset);
        this.buffer.put(this.segmentSize);
        this.buffer.mark();
        return this.buffer;
    }

    @Override
    public void deserialize(int receivedNumber_, DataBuffer dataBuffer) {
        this.receivedNumber = receivedNumber_;
        if (this.notRightDataForUs()) {
            return;
        }
        this.isExternalResource = dataBuffer.get(this.isExternalResource);
        this.valueSize = dataBuffer.get(this.valueSize);
        this.segment = dataBuffer.get(this.segment);
        this.gotResponse();
    }
}

