/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.server.protocol;

import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;

public class DataBuffer {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private boolean DEBUG = false;
    private ByteBuffer buffer = null;

    DataBuffer(Allocation a) {
        switch (a) {
            case JavaAllocation: {
                this.buffer = ByteBuffer.allocate(20);
                break;
            }
            case DirectAllocation: {
                this.buffer = ByteBuffer.allocate(20);
            }
        }
    }

    DataBuffer(byte[] bytes, int size) {
        this.buffer = ByteBuffer.allocate(size);
        this.buffer.put(bytes, 0, size);
        this.buffer.rewind();
    }

    DataBuffer(byte[] bytes) {
        this.buffer = ByteBuffer.wrap(bytes);
        this.buffer.rewind();
    }

    public DataBuffer(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer.duplicate();
        this.buffer.order(byteBuffer.order());
    }

    public DataBuffer(ByteBuffer byteBuffer, int dummy) {
        this.buffer = byteBuffer;
    }

    public ByteBuffer getByteBuffer() {
        return this.buffer;
    }

    private void checkCapacity(int a) {
        if (this.buffer.capacity() - this.buffer.position() >= a) {
            return;
        }
        ByteBuffer t = this.buffer;
        int capacity = t.capacity();
        int position = t.position();
        int newCapacity = capacity + Math.max(capacity / 2, a);
        this.buffer = ByteBuffer.allocate(newCapacity);
        t.clear();
        this.buffer.put(t);
        this.buffer.position(position);
        this.buffer.order(t.order());
    }

    public void clear() {
        this.buffer.clear();
    }

    public void order(ByteOrder byteOrder) {
        this.buffer.order(byteOrder);
    }

    public void mark() {
        this.buffer.mark();
    }

    public void position(int position) {
        this.buffer.position(position);
    }

    public byte[] getBytes() {
        byte[] t = new byte[this.buffer.position()];
        this.buffer.clear();
        this.buffer.get(t);
        return t;
    }

    public short get(short a) {
        return this.buffer.getShort();
    }

    public int get(int a) {
        return this.buffer.getInt();
    }

    public void put(int a) {
        this.checkCapacity(4);
        this.buffer.putInt(a);
    }

    public int[] get(int[] a) {
        int size = this.buffer.getInt();
        int[] t = new int[size];
        this.buffer.asIntBuffer().get(t);
        this.buffer.position(this.buffer.position() + size * 4);
        return t;
    }

    public void put(int[] a) {
        if (a == null) {
            a = new int[]{};
        }
        this.checkCapacity(4 + 4 * a.length);
        this.put(a.length);
        int i = 0;
        while (i < a.length) {
            this.buffer.putInt(a[i]);
            ++i;
        }
    }

    public long[] get(long[] a) {
        int size = this.buffer.getInt();
        long[] t = new long[size];
        this.buffer.asLongBuffer().get(t, 0, size);
        this.buffer.position(this.buffer.position() + 8 * size);
        return t;
    }

    public void put(long[] a) {
        this.checkCapacity(4 + 8 * a.length);
        this.put(a.length);
        int i = 0;
        while (i < a.length) {
            this.buffer.putLong(a[i]);
            ++i;
        }
    }

    public boolean get(boolean a) {
        byte b = this.buffer.get();
        return b != 0;
    }

    public void put(boolean a) {
        this.checkCapacity(1);
        byte b = a ? (byte)-1 : 0;
        this.buffer.put(b);
    }

    public byte get(byte a) {
        return this.buffer.get();
    }

    public void put(byte a) {
        this.checkCapacity(1);
        this.buffer.put(a);
    }

    public byte[] get(byte[] a) {
        int size = this.buffer.getInt();
        byte[] t = new byte[size];
        this.buffer.get(t, 0, size);
        return t;
    }

    public void put(byte[] a) {
        this.checkCapacity(4 + a.length);
        this.put(a.length);
        this.buffer.put(a);
    }

    public ByteBuffer get(ByteBuffer a) {
        int size = this.buffer.getInt();
        byte[] t = new byte[size];
        this.buffer.get(t, 0, size);
        a.put(t);
        return a;
    }

    public void put(ByteBuffer a) {
        byte[] t = a.array();
        this.checkCapacity(4 + t.length);
        this.put(t.length);
        this.buffer.put(t);
    }

    public static void printChars(PrintStream out, ByteBuffer buf, int pos) {
        out.print("[" + buf.limit() + "]");
        int i = pos;
        while (i < buf.limit()) {
            char c;
            int val = buf.get(i);
            if (val < 0) {
                val += 256;
            }
            if ((c = (char)val) >= ' ' && c < '\u0080') {
                out.print(c);
            } else if (c == '\u0000') {
                out.print('\u00a4');
            } else {
                out.print("(" + val + ")");
            }
            ++i;
        }
        out.println();
    }

    public String get(String a) {
        byte[] t = null;
        t = this.get(t);
        CharsetDecoder decoder = UTF8.newDecoder();
        ByteBuffer bbuf = ByteBuffer.wrap(t);
        String s = null;
        try {
            CharBuffer cbuf = decoder.decode(bbuf);
            s = cbuf.toString();
        }
        catch (CharacterCodingException e) {
            bbuf.rewind();
            if (this.DEBUG) {
                DataBuffer.printChars(System.err, bbuf, 0);
            }
            try {
                CharBuffer cbuf = UTF8.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).decode(bbuf);
                s = cbuf.toString();
            }
            catch (CharacterCodingException e1) {
                throw new Error("not possible", e1);
            }
        }
        return s;
    }

    public void put(String a) {
        try {
            this.put(a.getBytes(UTF8.name()));
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("UnsupportedEncoding: " + UTF8.name());
        }
    }

    public long get(long a) {
        return this.buffer.getLong();
    }

    public void put(long a) {
        this.checkCapacity(8);
        this.buffer.putLong(a);
    }

    public float get(float f) {
        return this.buffer.getFloat();
    }

    public void put(float a) {
        this.checkCapacity(4);
        this.buffer.putFloat(a);
    }

    public double get(double f) {
        return this.buffer.getDouble();
    }

    public void put(double a) {
        this.checkCapacity(8);
        this.buffer.putDouble(a);
    }

    public String[] get(String[] a) {
        int size = this.buffer.getInt();
        String[] t = new String[size];
        int i = 0;
        while (i < size) {
            t[i] = this.get(t[i]);
            ++i;
        }
        return t;
    }

    public void put(String[] a) {
        this.checkCapacity(4);
        this.put(a.length);
        int i = 0;
        while (i < a.length) {
            this.put(a[i]);
            ++i;
        }
    }

    static enum Allocation {
        JavaAllocation,
        DirectAllocation;

    }
}

