/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.server.internal;

import java.nio.ByteBuffer;
import org.simantics.db.server.Database;
import org.simantics.db.server.ProCoreException;
import org.simantics.db.server.internal.AskTransactionMethod;
import org.simantics.db.server.internal.ChangeSetEventHandler;
import org.simantics.db.server.internal.Client;
import org.simantics.db.server.internal.DatabaseI;
import org.simantics.db.server.internal.GetChangeSetDataMethod;
import org.simantics.db.server.internal.GetChangeSetIdsMethod;
import org.simantics.db.server.internal.GetClusterChangesMethod;
import org.simantics.db.server.internal.GetClusterIdsMethod;
import org.simantics.db.server.internal.GetClusterMethod;
import org.simantics.db.server.internal.GetInformationMethod;
import org.simantics.db.server.internal.GetRefreshMethod;
import org.simantics.db.server.internal.GetResourceSegmentMethod;
import org.simantics.db.server.internal.Method;
import org.simantics.db.server.protocol.AAAFunction;
import org.simantics.db.server.protocol.AcceptCommitFunction;
import org.simantics.db.server.protocol.AskTransactionFunction;
import org.simantics.db.server.protocol.CancelCommitFunction;
import org.simantics.db.server.protocol.EndTransactionFunction;
import org.simantics.db.server.protocol.ExecuteFunction;
import org.simantics.db.server.protocol.GetChangeSetContextFunction;
import org.simantics.db.server.protocol.GetChangeSetDataFunction;
import org.simantics.db.server.protocol.GetChangeSetsFunction;
import org.simantics.db.server.protocol.GetClusterChangesFunction;
import org.simantics.db.server.protocol.GetClusterNewFunction;
import org.simantics.db.server.protocol.GetRefresh2Function;
import org.simantics.db.server.protocol.GetResourceSegmentFunction;
import org.simantics.db.server.protocol.GetServerInfo2Function;
import org.simantics.db.server.protocol.ListClustersFunction;
import org.simantics.db.server.protocol.ReconnectFunction;
import org.simantics.db.server.protocol.ReserveIdsFunction;
import org.simantics.db.server.protocol.UndoFunction;
import org.simantics.db.server.protocol.UpdateClusterFunction;

public class SessionI
implements Database.Session {
    private final DatabaseI db;
    private Client client;

    SessionI(DatabaseI db, Client client) {
        this.db = db;
        this.client = client;
    }

    DatabaseI getDb() {
        return this.db;
    }

    Client replace(Client client) throws ProCoreException {
        Client t = this.client;
        this.client = client;
        return t;
    }

    @Override
    public Database getDatabase() {
        return this.db;
    }

    @Override
    public void close() throws ProCoreException {
        this.client.close();
    }

    @Override
    public boolean isClosed() throws ProCoreException {
        return this.client.isClosed();
    }

    @Override
    public void open() throws ProCoreException {
        try {
            this.client.open();
        }
        catch (InterruptedException e) {
            throw new ProCoreException("Client.open was interrupted.", e);
        }
    }

    public void callAAA() throws ProCoreException {
        AAAFunction f = new AAAFunction();
        this.client.call(new Method(f, null, null));
    }

    @Override
    public Database.Session.Transaction askReadTransaction() throws ProCoreException {
        AskTransactionFunction f = new AskTransactionFunction(0, 0L);
        AskTransactionMethod m = new AskTransactionMethod(f);
        this.client.call(m);
        return m;
    }

    @Override
    public Database.Session.Transaction askWriteTransaction(long transactionId) throws ProCoreException {
        AskTransactionFunction f = new AskTransactionFunction(1, transactionId);
        AskTransactionMethod m = new AskTransactionMethod(f);
        this.client.call(m);
        return m;
    }

    @Override
    public long endTransaction(long transactionId) throws ProCoreException {
        EndTransactionFunction f = new EndTransactionFunction(transactionId);
        Method m = new Method(f, null, null);
        this.client.call(m);
        return f.headChangeSetId;
    }

    @Override
    public void acceptCommit(long transactionId, long changeSetId, byte[] metadata) throws ProCoreException {
        AcceptCommitFunction f = new AcceptCommitFunction(transactionId, changeSetId, metadata);
        this.client.call(new Method(f, null, null));
    }

    @Override
    public long cancelCommit(long transactionId, long changeSetId, byte[] metadata, Database.Session.OnChangeSetUpdate onChangeSetUpdate) throws ProCoreException {
        CancelCommitFunction f = new CancelCommitFunction(transactionId, changeSetId, metadata);
        this.client.call(new Method(f, new ChangeSetEventHandler(onChangeSetUpdate), null));
        return f.headChangeSetId;
    }

    @Override
    public String execute(String command) throws ProCoreException {
        ExecuteFunction f = new ExecuteFunction(command);
        Method m = new Method(f, null, null);
        this.client.call(m);
        return f.out;
    }

    @Override
    public byte[] getChangeSetMetadata(long changeSetId) throws ProCoreException {
        GetChangeSetContextFunction f = new GetChangeSetContextFunction(changeSetId);
        this.client.call(new Method(f, null, null));
        return f.changeSetContext;
    }

    @Override
    public Database.Session.ChangeSetData getChangeSetData(long minChangeSetId, long maxChangeSetId, Database.Session.OnChangeSetUpdate on) throws ProCoreException {
        GetChangeSetDataFunction f = new GetChangeSetDataFunction(minChangeSetId, maxChangeSetId);
        GetChangeSetDataMethod m = new GetChangeSetDataMethod(f, new ChangeSetEventHandler(on));
        this.client.call(m);
        return m;
    }

    @Override
    public Database.Session.ChangeSetIds getChangeSetIds() throws ProCoreException {
        GetChangeSetsFunction f = new GetChangeSetsFunction();
        GetChangeSetIdsMethod m = new GetChangeSetIdsMethod(f);
        this.client.call(m);
        return m;
    }

    @Override
    public Database.Session.Cluster getCluster(byte[] clusterId) throws ProCoreException {
        GetClusterNewFunction f = new GetClusterNewFunction(clusterId);
        f.deflated = ByteBuffer.allocate(8192);
        GetClusterMethod m = new GetClusterMethod(f);
        this.client.call(m);
        return m;
    }

    @Override
    public Database.Session.ClusterIds getClusterIds() throws ProCoreException {
        int all = 0;
        ListClustersFunction f = new ListClustersFunction(all);
        GetClusterIdsMethod m = new GetClusterIdsMethod(f);
        this.client.call(m);
        return m;
    }

    @Override
    public Database.Session.Refresh getRefresh(long changeSetId) throws ProCoreException {
        GetRefresh2Function f = new GetRefresh2Function(0L);
        GetRefreshMethod m = new GetRefreshMethod(f);
        this.client.call(m);
        return m;
    }

    @Override
    public Database.Session.ResourceSegment getResourceSegment(byte[] clusterId, int resourceIndex, long offset, short size) throws ProCoreException {
        GetResourceSegmentFunction f = new GetResourceSegmentFunction(clusterId, resourceIndex, offset, size);
        GetResourceSegmentMethod m = new GetResourceSegmentMethod(f);
        this.client.call(m);
        return m;
    }

    @Override
    public Database.Session.ClusterChanges getClusterChanges(long changeSetId, byte[] clusterId) throws ProCoreException {
        GetClusterChangesFunction f = new GetClusterChangesFunction(changeSetId, clusterId);
        GetClusterChangesMethod m = new GetClusterChangesMethod(f);
        this.client.call(m);
        return m;
    }

    @Override
    public Database.Session.Information getInformation() throws ProCoreException {
        GetServerInfo2Function f = new GetServerInfo2Function();
        GetInformationMethod m = new GetInformationMethod(f);
        this.client.call(m);
        return m;
    }

    public void reconnect(int sessionId) throws ProCoreException {
        ReconnectFunction f = new ReconnectFunction(sessionId);
        this.client.call(new Method(f, null, null));
    }

    @Override
    public long reserveIds(int count) throws ProCoreException {
        ReserveIdsFunction f = new ReserveIdsFunction(count);
        this.client.call(new Method(f, null, null));
        return f.firstId;
    }

    @Override
    public boolean undo(long[] changeSetIds, Database.Session.OnChangeSetUpdate onChangeSetUpdate) throws ProCoreException {
        UndoFunction f = new UndoFunction(changeSetIds);
        this.client.call(new Method(f, new ChangeSetEventHandler(onChangeSetUpdate), null));
        return f.potentialConflicts;
    }

    @Override
    public void updateCluster(byte[] operations) throws ProCoreException {
        UpdateClusterFunction f = new UpdateClusterFunction(operations);
        this.client.call(new Method(f, null, null));
    }
}

