/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.server.internal;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Set;
import org.simantics.db.server.ProCoreException;
import org.simantics.db.server.internal.Client;
import org.simantics.db.server.internal.Connection;
import org.simantics.db.server.internal.ConnectionManager;
import org.simantics.db.server.internal.ConnectionThread;
import org.simantics.db.server.internal.Method;
import org.simantics.db.server.internal.ProCoreServer;
import org.simantics.db.server.internal.SessionAddress;
import org.simantics.db.server.protocol.CloseClientSessionFunction;
import org.simantics.db.server.protocol.ExecuteFunction;

class ProCoreClient {
    public static final String LOCALHOST = "127.0.0.1";
    private final Remote remote = new Remote();
    private final Set<Client> clients = new HashSet<Client>();
    private final ProCoreServer proCoreServer;

    public ProCoreClient(ProCoreServer proCoreServer) throws ProCoreException {
        this.proCoreServer = proCoreServer;
    }

    public synchronized int getPort() {
        return this.remote.connectionThread.getAddress().getPort();
    }

    public synchronized boolean isConnected() {
        return this.remote.connectionThread.isConnected();
    }

    public synchronized Client newClient() throws ProCoreException {
        return this.newClient(this.proCoreServer, this.remote.connectionThread.getAddress());
    }

    /*
     * Unable to fully structure code
     */
    public synchronized Client newClient(ProCoreServer proCoreServer, InetSocketAddress address) throws ProCoreException {
        if (!Remote.access$0(this.remote).isConnected()) {
            try {
                Remote.access$0(this.remote).connect(address);
            }
            catch (InterruptedException e) {
                if (Remote.access$0(this.remote).isConnected()) ** GOTO lbl11
                Remote.access$0(this.remote).disconnect();
                throw new ProCoreException("Failed to create new client.");
            }
        } else if (!address.equals(Remote.access$0(this.remote).getAddress())) {
            throw new ProCoreException("Illegal newClient call. Already connected to different address.");
        }
lbl11:
        // 4 sources

        client = new Client(proCoreServer, this, Remote.access$0(this.remote));
        this.clients.add(client);
        return client;
    }

    synchronized int deleteClient(Client client) {
        this.clients.remove(client);
        return this.clients.size();
    }

    void closeClient(int aSessionId) throws ProCoreException {
        try {
            CloseClientSessionFunction f = new CloseClientSessionFunction(aSessionId);
            Method m = new Method(f, null, null);
            Connection c = this.remote.connectionThread.call(m);
            m.waitForReply(c);
        }
        catch (InterruptedException e) {
            throw new ProCoreException("Thread interrupted during method call.", e);
        }
        catch (IOException e) {
            throw new ProCoreException("IOException during method call.", e);
        }
        catch (Throwable e) {
            throw new ProCoreException("Throwable during method call.", e);
        }
    }

    public synchronized String execute(String command) throws ProCoreException {
        try {
            ExecuteFunction f = new ExecuteFunction(command);
            Method m = new Method(f, null, null);
            Connection c = this.remote.connectionThread.call(m);
            m.waitForReply(c);
            return f.out;
        }
        catch (InterruptedException e) {
            throw new ProCoreException("Thread interrupted during method call.", e);
        }
        catch (IOException e) {
            throw new ProCoreException("IOException during method call.", e);
        }
        catch (Throwable e) {
            throw new ProCoreException("Throwable during method call.", e);
        }
    }

    private void recall(Method method, IOException e) throws ProCoreException {
        if (this.remote.connectionThread.isConnected()) {
            throw new ProCoreException("IOException during method call.", e);
        }
        try {
            this.remote.connectionThread.reconnect();
            Connection c = this.remote.connectionThread.call(method);
            method.waitForReply(c);
        }
        catch (Throwable t) {
            throw new ProCoreException("IOException during method call. Recall failed.", e);
        }
    }

    public synchronized void call(Method method) throws ProCoreException {
        try {
            Connection c = this.remote.connectionThread.call(method);
            method.waitForReply(c);
        }
        catch (InterruptedException e) {
            throw new ProCoreException("Thread interrupted during method call.", e);
        }
        catch (IOException e) {
            this.recall(method, e);
        }
        catch (ProCoreException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ProCoreException("Throwable during method call.", e);
        }
    }

    public synchronized void connect(int port) throws ProCoreException, InterruptedException {
        this.remote.connectionThread.connect(port);
    }

    public synchronized void connect(SessionAddress sessionAddress) throws ProCoreException, InterruptedException {
        this.remote.connectionThread.connect(sessionAddress.getSocketAddress());
    }

    public synchronized void disconnect() throws ProCoreException {
        this.remote.connectionThread.disconnect();
    }

    class Remote {
        private final ConnectionManager connectionManager = ConnectionManager.getInstance();
        private final ConnectionThread connectionThread = new ConnectionThread(this.connectionManager);

        Remote() {
        }
    }
}

