/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.server.internal;

import java.io.EOFException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.UUID;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.impl.TreeMapBinding;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.db.DatabaseUserAgent;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.CommitMetadata;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.common.utils.MetadataUtil;
import org.simantics.db.exception.InternalException;
import org.simantics.db.server.Database;
import org.simantics.db.server.DatabaseLastExitException;
import org.simantics.db.server.ProCoreException;
import org.simantics.db.server.internal.Activator;
import org.simantics.db.server.internal.Client;
import org.simantics.db.server.internal.ProCoreClient;
import org.simantics.db.server.internal.ProCoreServer;
import org.simantics.db.server.internal.SessionManager;
import org.simantics.db.server.internal.TailReadException;
import org.simantics.db.server.internal.Util;
import org.simantics.db.server.protocol.MessageText;

public class DatabaseI
implements Database {
    private static String NL = System.getProperty("line.separator");
    private static String TEMP_PREFIX = "db.temp.";
    private final SessionManager sessionManager = new SessionManager();
    private final Server server;
    private final JournalI journal;
    private DatabaseUserAgent dbUserAgent = null;

    public static DatabaseI newDatabaseI(File dbFolder) {
        return new DatabaseI(dbFolder);
    }

    private DatabaseI(File dbFolder) {
        this.server = new Server(dbFolder);
        this.journal = new JournalI(dbFolder);
    }

    public boolean isSubFolder(Path base, Path sub) throws IOException {
        if (base == null || sub == null) {
            return false;
        }
        return this.isSubFolder(base.toFile(), sub.toFile());
    }

    public boolean isSubFolder(File base, File sub) throws IOException {
        if (base == null || sub == null) {
            return false;
        }
        Path basePath = base.getCanonicalFile().toPath();
        Path subPath = sub.getCanonicalFile().toPath();
        return subPath.startsWith(basePath);
    }

    public Path saveDatabase() throws ProCoreException {
        Path dbFolder = this.getFolder().toPath();
        Path parent = this.getFolder().getParentFile().toPath();
        Path temp = this.createTempFolder(parent, "Could not create temporary directory for saving database.");
        DatabaseI.copyTree(dbFolder, temp, FileOption.IF_NEW);
        return temp;
    }

    public Path saveDatabase(Path parent) throws ProCoreException {
        Path dbFolder = this.getFolder().toPath();
        try {
            boolean yes = this.isSubFolder(dbFolder, parent);
            if (yes) {
                throw new ProCoreException("Parent must not be subdirectory of database directory." + NL + "database=" + dbFolder + NL + "parent=" + parent);
            }
        }
        catch (IOException e) {
            throw new ProCoreException("Failed to save database to parent." + NL + "database=" + dbFolder + NL + "parent=" + parent);
        }
        Path temp = this.createTempFolder(parent, "Could not create temporary directory for saving database.");
        DatabaseI.copyTree(dbFolder, temp, FileOption.IF_NEW);
        return temp;
    }

    public void deleteDatabaseFiles() throws ProCoreException {
        if (this.server.isAlive()) {
            this.server.tryToStop();
            if (this.server.isAlive()) {
                throw new ProCoreException("Server must be dead to delete database.");
            }
        }
        Path db = this.getFolder().toPath();
        DatabaseI.deleteDatabaseFiles(db);
        DatabaseI.deleteTree(db);
    }

    Path copyDatabaseFiles(Path from, Path to) throws ProCoreException {
        DatabaseI.copyTree(from, to, "procore.headClusters.procore", FileOption.IF_EXIST);
        if (Files.exists(from.resolve("procore.tailClusters.procore"), new LinkOption[0])) {
            DatabaseI.copyTree(from, to, "procore.tailClusters.procore", FileOption.IF_EXIST);
        }
        this.copyPath(from, to, "procore.config.procore", FileOption.IF_EXIST);
        this.copyPath(from, to, "procore.guard.procore", FileOption.IF_EXIST);
        this.copyPath(from, to, "procore.journal.procore", FileOption.IF_EXIST);
        this.copyPath(from, to, "procore.log.procore", FileOption.IF_EXIST);
        this.copyFiles(from, to, "procore.page*.procore", FileOption.IF_EXIST);
        return to;
    }

    public static void deleteDatabaseFiles(Path from) throws ProCoreException {
        DatabaseI.deleteFile(from, "procore.dumpChangeSets.procore", FileOption.IF_EXIST);
        DatabaseI.deleteFile(from, "recovery.needed", FileOption.IF_EXIST);
        DatabaseI.deleteFile(from, "recovery.ignored", FileOption.IF_EXIST);
        DatabaseI.deleteFile(from, "protocol.ignored", FileOption.IF_EXIST);
        DatabaseI.deleteFile(from, "procore.log.procore", FileOption.IF_EXIST);
        DatabaseI.deleteFile(from, "procore.guard.procore", FileOption.IF_EXIST);
        DatabaseI.deleteFile(from, "procore.config.procore", FileOption.IF_EXIST);
        DatabaseI.deleteFiles(from, "procore.page*.procore");
        DatabaseI.deleteTree(from.resolve("procore.headClusters.procore"));
        DatabaseI.deleteFile(from, "procore.journal.procore", FileOption.IF_EXIST);
        DatabaseI.deleteTree(from.resolve("procore.tailClusters.procore"));
    }

    Path moveDatabaseFiles(Path from, Path to) throws ProCoreException {
        DatabaseI.moveFolder(from, to, "procore.headClusters.procore", FileOption.IF_NEW);
        if (Files.exists(from.resolve("procore.tailClusters.procore"), new LinkOption[0])) {
            DatabaseI.moveFolder(from, to, "procore.tailClusters.procore", FileOption.IF_NEW);
        }
        this.movePath(from, to, "procore.config.procore", FileOption.IF_NEW);
        this.movePath(from, to, "procore.guard.procore", FileOption.IF_NEW);
        this.movePath(from, to, "procore.journal.procore", FileOption.IF_NEW);
        this.movePath(from, to, "procore.log.procore", FileOption.IF_NEW);
        this.moveFiles(from, to, "procore.page*.procore", FileOption.IF_NEW);
        this.movePath(from, to, "procore.dumpChangeSets.procore", FileOption.IF_NEW);
        this.moveFile(from, to, "recovery.needed", FileOption.IF_NEW);
        this.moveFile(from, to, "recovery.ignored", FileOption.IF_NEW);
        this.moveFile(from, to, "protocol.ignored", FileOption.IF_NEW);
        return to;
    }

    private void moveFile(Path from, Path to, String file, FileOption fileOption) throws ProCoreException {
        if (Files.exists(from.resolve(file), new LinkOption[0])) {
            this.movePath(from, to, file, fileOption);
        }
    }

    public void serverCreateConfiguration() throws ProCoreException {
        this.server.createConfiguration();
    }

    public boolean ignoreExit() throws ProCoreException {
        if (!this.isFolderOk()) {
            throw new ProCoreException("Folder must be valid database folder to ignore exit.");
        }
        this.server.deleteGuard();
        File folder = this.server.getFolder();
        Path db = Paths.get(folder.getAbsolutePath(), new String[0]);
        Path ri = db.resolve("recovery.ignored");
        if (!Files.exists(ri, new LinkOption[0])) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try {
                    OutputStream os = Files.newOutputStream(ri, new OpenOption[0]);
                    if (os != null) {
                        os.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new ProCoreException("Could not create file: " + ri, e);
            }
        }
        boolean ok = false;
        DatabaseUserAgent dbu = this.dbUserAgent;
        try {
            this.dbUserAgent = null;
            this.server.start();
            ok = this.server.isActive();
        }
        finally {
            try {
                this.dbUserAgent = dbu;
                this.server.stop();
            }
            finally {
                try {
                    Files.deleteIfExists(ri);
                }
                catch (IOException e) {
                    Logger.defaultLogError((String)("Could not delete file: " + ri), (Throwable)e);
                }
                Path rn = db.resolve("recovery.needed");
                try {
                    Files.deleteIfExists(rn);
                }
                catch (IOException e) {
                    Logger.defaultLogError((String)("Could not delete file: " + rn), (Throwable)e);
                }
            }
        }
        return ok;
    }

    public boolean ignoreProtocol() throws ProCoreException {
        if (!this.isFolderOk()) {
            throw new ProCoreException("Folder must be valid database folder to ignore exit.");
        }
        File folder = this.server.getFolder();
        Path db = Paths.get(folder.getAbsolutePath(), new String[0]);
        Path ri = db.resolve("protocol.ignored");
        if (!Files.exists(ri, new LinkOption[0])) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try {
                    OutputStream os = Files.newOutputStream(ri, new OpenOption[0]);
                    if (os != null) {
                        os.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new ProCoreException("Could not create file: " + ri, e);
            }
        }
        boolean ok = false;
        try {
            this.server.start();
            ok = this.server.isActive();
        }
        finally {
            this.server.stop();
        }
        return ok;
    }

    private long preJournalCheck() throws ProCoreException {
        File folder = this.server.getFolder();
        if (!folder.isDirectory()) {
            throw new ProCoreException("Database folder does not exist." + NL + "folder=" + folder);
        }
        File file = new File(folder, "procore.journal.procore");
        if (!file.isFile()) {
            throw new ProCoreException("Journal file does not exist." + NL + "file=" + file);
        }
        if (!file.canRead()) {
            throw new ProCoreException("Journal file must be readale to create database from journal." + NL + "file=" + file);
        }
        if (this.server.isAlive()) {
            throw new ProCoreException("Server must be dead to create database from journal file." + NL + "file=" + file);
        }
        return this.getNextClusterId(folder.toPath());
    }

    private void postJournalFix(long nextFreeId) throws ProCoreException {
        Database.Session s = this.newSession();
        long current = s.reserveIds(0);
        if (current < nextFreeId) {
            s.reserveIds((int)(nextFreeId - current));
        }
        s.isClosed();
    }

    private Path createTempFolder(Path parent, String fail) throws ProCoreException {
        try {
            return Files.createTempDirectory(parent, TEMP_PREFIX, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ProCoreException(fail, e);
        }
    }

    public void replaceFromJournal() throws ProCoreException {
        long nextFreeId = this.preJournalCheck();
        Path db = Paths.get(this.server.getFolder().getAbsolutePath(), new String[0]);
        Path temp = this.createTempFolder(db, "Could not create temporary directory for database to be created from journal.");
        this.movePath(db, temp, "procore.config.procore", FileOption.IF_NEW);
        this.movePath(db, temp, "procore.journal.procore", FileOption.IF_NEW);
        DatabaseI.deleteFile(db, "procore.guard.procore", FileOption.IF_EXIST);
        DatabaseI.deleteFiles(db, "procore.page*.procore");
        Path dbHead = db.resolve("procore.headClusters.procore");
        DatabaseI.deleteFiles(dbHead, "ExternalValue.*");
        DatabaseI.deleteFiles(dbHead, "ClusterData.*");
        DatabaseI.deleteFiles(dbHead, "ClusterIndex.*");
        Path dbHeadTailFile = dbHead.resolve("procore.tail.procore");
        boolean headTailFileExisted = Files.exists(dbHeadTailFile, new LinkOption[0]);
        long NEXT_REVISION = 1L;
        if (!headTailFileExisted) {
            ProCoreServer.TailFile.createTailFile(dbHeadTailFile.toFile(), 1L, nextFreeId, UUID.randomUUID().toString());
        }
        this.movePath(dbHead, temp, "procore.tail.procore", FileOption.IF_NEW);
        Path dbTail = db.resolve("procore.tailClusters.procore");
        boolean tailExisted = Files.isDirectory(dbTail, new LinkOption[0]);
        if (tailExisted) {
            this.copyPath(dbTail, dbHead, "procore.tail.procore", FileOption.IF_NEW);
        } else {
            try {
                Files.createDirectory(dbTail, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ProCoreException("Failed to create directory: " + dbTail, e);
            }
            this.copyPath(temp, dbTail, "procore.tail.procore", FileOption.IF_NEW);
        }
        this.server.createConfiguration();
        this.server.start();
        try {
            String t = this.server.execute("journalRead " + temp.getFileName());
            if (t.length() > 0) {
                throw new ProCoreException("Could not read journal. reply=" + t);
            }
            this.postJournalFix(nextFreeId);
        }
        finally {
            this.server.tryToStop();
        }
        this.movePath(temp, db, "procore.config.procore", FileOption.OVERWRITE);
        DatabaseI.deleteTree(temp);
        if (!tailExisted) {
            DatabaseI.deleteTree(dbTail);
        }
    }

    public boolean canPurge() throws ProCoreException {
        File folder = this.server.getFolder();
        Path db = Paths.get(folder.getAbsolutePath(), new String[0]);
        Path dbHead = db.resolve("procore.headClusters.procore");
        if (!Files.exists(dbHead, new LinkOption[0])) {
            return false;
        }
        boolean empty = this.isFolderEmpty(dbHead);
        if (empty) {
            return false;
        }
        final boolean[] found = new boolean[]{false};
        dbHead.toFile().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (found[0]) {
                    return false;
                }
                if (!name.equals("procore.tail.procore")) {
                    found[0] = true;
                    return false;
                }
                return true;
            }
        });
        return found[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() throws ProCoreException {
        ProCoreClient proCoreClient = this.server.proCoreServer.getProCoreClient();
        synchronized (proCoreClient) {
            boolean wasAlive = this.server.isAlive();
            if (wasAlive) {
                this.server.stop();
            }
            Path db = Paths.get(this.server.getFolder().getAbsolutePath(), new String[0]);
            Path dbHead = db.resolve("procore.headClusters.procore");
            Path dbTail = db.resolve("procore.tailClusters.procore");
            if (!Files.isDirectory(dbTail, new LinkOption[0])) {
                try {
                    Files.createDirectory(dbTail, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new ProCoreException("Failed to create directory: " + dbTail, e);
                }
            }
            long nextFreeId = this.getNextClusterId(db);
            boolean cleanHead = Files.isDirectory(dbHead, new LinkOption[0]) && !this.isFolderEmpty(dbHead);
            Logger.defaultLog((String)("Purging old history and exit information. folder=" + db));
            if (cleanHead) {
                this.deleteClusters(dbHead, dbTail);
                this.movePath(dbHead, dbTail, "procore.tail.procore", FileOption.OVERWRITE);
                this.moveFiles(dbHead, dbTail, "ExternalValue.*", FileOption.IF_NEW);
                this.moveFiles(dbHead, dbTail, "ClusterData.*", FileOption.OVERWRITE);
                DatabaseI.deleteFiles(dbHead, "ClusterIndex.*");
            }
            DatabaseI.deleteFiles(db, "procore.page*.procore");
            DatabaseI.deleteFile(db, "procore.journal.procore", FileOption.IF_EXIST);
            DatabaseI.deleteFile(db, "procore.log.procore", FileOption.IF_EXIST);
            DatabaseI.deleteFile(db, "procore.dumpChangeSets.procore", FileOption.IF_EXIST);
            DatabaseI.deleteFile(db, "recovery.needed", FileOption.IF_EXIST);
            DatabaseI.deleteFile(db, "recovery.ignored", FileOption.IF_EXIST);
            DatabaseI.deleteFile(db, "protocol.ignored", FileOption.IF_EXIST);
            DatabaseI.deleteFile(db, "procore.guard.procore", FileOption.IF_EXIST);
            this.purgeValues(dbTail);
            this.server.start();
            Database.Session s = this.newSession();
            long current = s.reserveIds(0);
            if (current < nextFreeId) {
                s.reserveIds((int)(nextFreeId - current));
            }
            s.isClosed();
            if (!wasAlive) {
                this.server.tryToStop();
            }
        }
    }

    private void copyPath(Path fromFolder, Path toFolder, String file, FileOption fileOption) throws ProCoreException {
        Path from = fromFolder.resolve(file);
        Path to = toFolder.resolve(file);
        try {
            if (FileOption.IF_EXIST.equals((Object)fileOption) && !Files.exists(from, new LinkOption[0])) {
                return;
            }
            if (FileOption.OVERWRITE.equals((Object)fileOption)) {
                Files.copy(from, to, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.copy(from, to, StandardCopyOption.COPY_ATTRIBUTES);
            }
        }
        catch (IOException e) {
            throw new ProCoreException("Could not copy " + from + " to " + to, e);
        }
    }

    private static void deleteFile(Path from, String file, FileOption fileOption) throws ProCoreException {
        Path path = from.resolve(file);
        DatabaseI.deletePath(path, fileOption);
    }

    private static void deletePath(Path path, FileOption fileOption) throws ProCoreException {
        try {
            if (FileOption.IF_EXIST.equals((Object)fileOption)) {
                Files.deleteIfExists(path);
            } else {
                Files.delete(path);
            }
        }
        catch (IOException e) {
            throw new ProCoreException("Could not delete " + path, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isFolderEmpty(Path folder) {
        if (!Files.isDirectory(folder, new LinkOption[0])) {
            return false;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (DirectoryStream<Path> folderStream = Files.newDirectoryStream(folder);){
                return !folderStream.iterator().hasNext();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            Logger.defaultLogError((String)("Failed to open folder stream. folder=" + folder), (Throwable)e);
            return false;
        }
    }

    private void movePath(Path fromPath, Path toPath, String file, FileOption fileOption) throws ProCoreException {
        Path from = fromPath.resolve(file);
        Path to = toPath.resolve(file);
        try {
            if (FileOption.OVERWRITE.equals((Object)fileOption)) {
                Files.move(from, to, StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.move(from, to, new CopyOption[0]);
            }
        }
        catch (IOException e) {
            throw new ProCoreException("Could not move " + from + " to " + to, e);
        }
    }

    private static void copyTree(Path from, Path to, String path, FileOption fileOption) throws ProCoreException {
        DatabaseI.copyTree(from.resolve(path), to.resolve(path), fileOption);
    }

    private static void copyTree(Path from, Path to, FileOption fileOption) throws ProCoreException {
        try {
            class Visitor
            extends SimpleFileVisitor<Path> {
                private Path fromPath;
                private Path toPath;
                private final /* synthetic */ FileOption val$fileOption;

                Visitor(Path from, Path to, FileOption fileOption) {
                    this.val$fileOption = fileOption;
                    this.fromPath = from;
                    this.toPath = to;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Path targetPath = this.toPath.resolve(this.fromPath.relativize(dir));
                    if (!Files.exists(targetPath, new LinkOption[0])) {
                        Files.createDirectory(targetPath, new FileAttribute[0]);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (FileOption.OVERWRITE.equals((Object)this.val$fileOption)) {
                        Files.copy(file, this.toPath.resolve(this.fromPath.relativize(file)), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                    } else {
                        Files.copy(file, this.toPath.resolve(this.fromPath.relativize(file)), StandardCopyOption.COPY_ATTRIBUTES);
                    }
                    return FileVisitResult.CONTINUE;
                }
            }
            Visitor v = new Visitor(from, to, fileOption);
            EnumSet<FileVisitOption> opts = EnumSet.noneOf(FileVisitOption.class);
            Files.walkFileTree(from, opts, Integer.MAX_VALUE, v);
        }
        catch (IOException e) {
            throw new ProCoreException("Could not copy " + from + " to " + to, e);
        }
    }

    private static void deleteTree(Path path) throws ProCoreException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        try {
            class Visitor
            extends SimpleFileVisitor<Path> {
                Visitor() {
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        Files.delete(file);
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        throw ioe;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                    if (e == null) {
                        try {
                            Files.delete(dir);
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                            throw ioe;
                        }
                        return FileVisitResult.CONTINUE;
                    }
                    throw e;
                }
            }
            Visitor v = new Visitor();
            EnumSet<FileVisitOption> opts = EnumSet.noneOf(FileVisitOption.class);
            Files.walkFileTree(path, opts, Integer.MAX_VALUE, v);
        }
        catch (IOException e) {
            throw new ProCoreException("Could not delete " + path, e);
        }
    }

    private static void moveFolder(Path fromPath, Path toPath, String folder, FileOption fileOption) throws ProCoreException {
        Path from = fromPath.resolve(folder);
        Path to = toPath.resolve(folder);
        DatabaseI.copyTree(from, to, fileOption);
        DatabaseI.deleteTree(from);
    }

    private void copyFiles(Path from, Path to, String pattern, FileOption fileOption) throws ProCoreException {
        try {
            class Visitor
            extends SimpleFileVisitor<Path> {
                private final PathMatcher matcher;
                private final /* synthetic */ FileOption val$fileOption;
                private final /* synthetic */ Path val$to;
                private final /* synthetic */ Path val$from;

                Visitor(String pattern, FileOption fileOption, Path path, Path path2) {
                    this.val$fileOption = fileOption;
                    this.val$to = path;
                    this.val$from = path2;
                    this.matcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern);
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path name = file.getFileName();
                    if (name == null) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (!this.matcher.matches(name)) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (FileOption.OVERWRITE.equals((Object)this.val$fileOption)) {
                        Files.copy(file, this.val$to.resolve(name), StandardCopyOption.REPLACE_EXISTING);
                    } else {
                        Files.copy(file, this.val$to.resolve(name), new CopyOption[0]);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (dir.equals(this.val$from)) {
                        return FileVisitResult.CONTINUE;
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }
            }
            Visitor v = new Visitor(pattern, fileOption, to, from);
            EnumSet<FileVisitOption> opts = EnumSet.noneOf(FileVisitOption.class);
            Files.walkFileTree(from, opts, Integer.MAX_VALUE, v);
        }
        catch (IOException e) {
            throw new ProCoreException("Could not copy " + from + " to " + to, e);
        }
    }

    private void moveFiles(Path from, Path to, String pattern, FileOption fileOption) throws ProCoreException {
        try {
            class Visitor
            extends SimpleFileVisitor<Path> {
                private final PathMatcher matcher;
                private final /* synthetic */ FileOption val$fileOption;
                private final /* synthetic */ Path val$to;
                private final /* synthetic */ Path val$from;

                Visitor(String pattern, FileOption fileOption, Path path, Path path2) {
                    this.val$fileOption = fileOption;
                    this.val$to = path;
                    this.val$from = path2;
                    this.matcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern);
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path name = file.getFileName();
                    if (name == null) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (!this.matcher.matches(name)) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (FileOption.OVERWRITE.equals((Object)this.val$fileOption)) {
                        Files.move(file, this.val$to.resolve(name), StandardCopyOption.REPLACE_EXISTING);
                    } else {
                        Files.move(file, this.val$to.resolve(name), new CopyOption[0]);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (dir.equals(this.val$from)) {
                        return FileVisitResult.CONTINUE;
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }
            }
            Visitor v = new Visitor(pattern, fileOption, to, from);
            EnumSet<FileVisitOption> opts = EnumSet.noneOf(FileVisitOption.class);
            Files.walkFileTree(from, opts, Integer.MAX_VALUE, v);
        }
        catch (IOException e) {
            throw new ProCoreException("Could not move " + from + " to " + to, e);
        }
    }

    private void deleteClusters(Path head, Path tail) throws ProCoreException {
        try {
            class Visitor
            extends SimpleFileVisitor<Path> {
                private final PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:ClusterDeleted.*");
                private final /* synthetic */ Path val$head;
                private final /* synthetic */ Path val$tail;

                Visitor(String pattern, Path path, Path path2) {
                    this.val$head = path;
                    this.val$tail = path2;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path name = file.getFileName();
                    if (name == null) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (!this.matcher.matches(name)) {
                        return FileVisitResult.CONTINUE;
                    }
                    String deletedStr = name.toString();
                    String indexName = deletedStr.replaceFirst("ClusterDeleted.", "ClusterIndex.");
                    String dataName = deletedStr.replaceFirst("ClusterDeleted.", "ClusterData.");
                    String[] ss = deletedStr.split("\\.");
                    String valuePattern = "ExternalValue." + ss[1] + "." + ss[2] + "*";
                    Files.delete(file);
                    Files.delete(this.val$head.resolve(indexName));
                    Files.delete(this.val$head.resolve(dataName));
                    try {
                        DatabaseI.deleteFiles(this.val$head, valuePattern);
                        if (Files.isDirectory(this.val$tail, new LinkOption[0])) {
                            Files.deleteIfExists(this.val$tail.resolve(dataName));
                            DatabaseI.deleteFiles(this.val$tail, valuePattern);
                        }
                    }
                    catch (ProCoreException e) {
                        throw new IOException("Delete values failed.", (Throwable)((Object)e));
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (dir.equals(this.val$head)) {
                        return FileVisitResult.CONTINUE;
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }
            }
            Visitor v = new Visitor("ClusterDeleted.", head, tail);
            EnumSet<FileVisitOption> opts = EnumSet.noneOf(FileVisitOption.class);
            Files.walkFileTree(head, opts, Integer.MAX_VALUE, v);
        }
        catch (IOException e) {
            throw new ProCoreException("Could not delete cluster(s).\nhead=" + head + "\ntail=" + tail);
        }
    }

    private static long convertHexStringToLong(String hex) {
        if (hex.length() < 16) {
            return Long.parseLong(hex, 16);
        }
        long f = Long.parseLong(hex.substring(0, 1), 16) << 60;
        long l = Long.parseLong(hex.substring(1, 16), 16);
        return f | l;
    }

    private void purgeValues(Path folder) throws ProCoreException {
        File[] files = folder.toFile().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("ExternalValue.");
            }
        });
        final class Value {
            long first;
            long second;
            int index;
            transient long cs;

            public Value(long first, long second, int index, long cs) {
                this.first = first;
                this.second = second;
                this.index = index;
                this.cs = cs;
            }

            String getName() {
                return "ExternalValue." + this.toString() + ".procore";
            }

            public String toString() {
                return String.format("%x.%x.%d.%d", this.first, this.second, this.index, this.cs);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof Value)) {
                    return false;
                }
                Value x = (Value)o;
                return this.first == x.first && this.second == x.second && this.index == x.index;
            }

            public int hashCode() {
                int result = 17;
                int f = (int)(this.first ^ this.first >>> 32);
                result = 31 * result + f;
                int s = (int)(this.second ^ this.second >>> 32);
                result = 31 * result + s;
                return result + this.index;
            }
        }
        HashMap<Value, Value> values = new HashMap<Value, Value>();
        int i = 0;
        while (i < files.length) {
            String s = files[i].getName();
            String[] ss = s.split("\\.");
            if (ss.length != 6) {
                Logger.defaultLogError((String)("Illegal external value file name. name=" + s));
            } else {
                long cs;
                int ri;
                long second;
                long first = DatabaseI.convertHexStringToLong(ss[1]);
                Value nv = new Value(first, second = DatabaseI.convertHexStringToLong(ss[2]), ri = Integer.parseInt(ss[3]), cs = Long.parseLong(ss[4]));
                Value ov = (Value)values.get(nv);
                if (ov == null) {
                    values.put(nv, nv);
                } else if (ov.cs < nv.cs) {
                    DatabaseI.deleteFile(folder, ov.getName(), FileOption.IF_EXIST);
                    ov.cs = nv.cs;
                } else {
                    DatabaseI.deleteFile(folder, nv.getName(), FileOption.IF_EXIST);
                }
            }
            ++i;
        }
    }

    private long getNextClusterId(Path db) throws ProCoreException {
        long clusterId = 0L;
        Path dbHead = db.resolve("procore.headClusters.procore");
        File[] files = dbHead.toFile().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("ClusterData.");
            }
        });
        int i = 0;
        while (i < files.length) {
            String s = files[i].getName();
            String[] ss = s.split("\\.", 4);
            if (ss.length != 4) {
                Logger.defaultLogError((String)("Illegal cluster file name. name=" + s));
            } else {
                long id = DatabaseI.convertHexStringToLong(ss[2]);
                if (id > clusterId) {
                    clusterId = id;
                }
            }
            ++i;
        }
        Path dbTail = db.resolve("procore.tailClusters.procore");
        if (!Files.exists(dbTail, new LinkOption[0])) {
            return clusterId + 1L;
        }
        try {
            class Visitor
            extends SimpleFileVisitor<Path> {
                private final PathMatcher matcher;
                long clusterId;
                private final /* synthetic */ Path val$dbTail;

                Visitor(String pattern, long clusterId, Path path) {
                    this.val$dbTail = path;
                    this.clusterId = clusterId;
                    this.matcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern);
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path name = file.getFileName();
                    if (name == null) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (!this.matcher.matches(name)) {
                        return FileVisitResult.CONTINUE;
                    }
                    String s = name.toString();
                    String[] ss = s.split("\\.", 4);
                    if (ss.length != 4) {
                        Logger.defaultLogError((String)("Illegal cluster file name. name=" + s));
                        return FileVisitResult.CONTINUE;
                    }
                    long id = DatabaseI.convertHexStringToLong(ss[2]);
                    if (id > this.clusterId) {
                        this.clusterId = id;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (dir.equals(this.val$dbTail)) {
                        return FileVisitResult.CONTINUE;
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }
            }
            Visitor v = new Visitor("ClusterData.*", clusterId, dbTail);
            EnumSet<FileVisitOption> opts = EnumSet.noneOf(FileVisitOption.class);
            Files.walkFileTree(dbTail, opts, Integer.MAX_VALUE, v);
            return v.clusterId + 1L;
        }
        catch (IOException e) {
            throw new ProCoreException("Could not get next free cluster id for " + db, e);
        }
    }

    private static void deleteFiles(Path folder, String pattern) throws ProCoreException {
        if (!Files.exists(folder, new LinkOption[0])) {
            return;
        }
        try {
            class Visitor
            extends SimpleFileVisitor<Path> {
                private final PathMatcher matcher;
                private final /* synthetic */ Path val$folder;

                Visitor(String pattern, Path path) {
                    this.val$folder = path;
                    this.matcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern);
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path name = file.getFileName();
                    if (name == null) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (!this.matcher.matches(name)) {
                        return FileVisitResult.CONTINUE;
                    }
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (dir.equals(this.val$folder)) {
                        return FileVisitResult.CONTINUE;
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }
            }
            Visitor v = new Visitor(pattern, folder);
            EnumSet<FileVisitOption> opts = EnumSet.noneOf(FileVisitOption.class);
            Files.walkFileTree(folder, opts, Integer.MAX_VALUE, v);
        }
        catch (IOException e) {
            throw new ProCoreException("Could not delete " + folder + " with " + pattern, e);
        }
    }

    public void copy(File to) throws ProCoreException {
        this.copyDatabaseFiles(this.server.getFolder().toPath(), to.toPath());
    }

    public boolean isServerAlive() {
        return this.server.isAlive();
    }

    Client newClient() throws ProCoreException {
        return this.server.newClient();
    }

    public void createFolder() throws ProCoreException {
        if (this.server.folder.exists()) {
            return;
        }
        boolean created = this.server.folder.mkdirs();
        if (!created) {
            throw new ProCoreException("Could not create folder=" + this.server.folder);
        }
    }

    public boolean serverTryToStop() throws ProCoreException {
        return this.server.tryToStop();
    }

    @Override
    public void initFolder(Properties properties) throws ProCoreException {
        this.createFolder();
        this.serverCreateConfiguration();
    }

    @Override
    public void deleteFiles() throws ProCoreException {
        this.deleteDatabaseFiles();
    }

    @Override
    public void start() throws ProCoreException {
        this.connect();
    }

    @Override
    public boolean isRunning() throws ProCoreException {
        return this.isServerAlive();
    }

    @Override
    public boolean tryToStop() throws ProCoreException {
        return this.serverTryToStop();
    }

    @Override
    public String execute(String aCommand) throws ProCoreException {
        return this.server.execute(aCommand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeDatabase() throws ProCoreException {
        ProCoreClient proCoreClient = this.server.proCoreServer.getProCoreClient();
        synchronized (proCoreClient) {
            if (!this.server.isLocal()) {
                throw new ProCoreException("Purge is allowed only for local server.");
            }
            List<Client> clients = this.sessionManager.disconnect(this);
            this.purge();
            try {
                this.sessionManager.connect(this, clients);
            }
            catch (InterruptedException e) {
                throw new ProCoreException("Failed to connect after purge.", e);
            }
        }
    }

    @Override
    public Database.Session newSession() throws ProCoreException {
        return this.sessionManager.newSession(this);
    }

    @Override
    public Path createFromChangeSets(int revision) throws ProCoreException {
        if (!this.isFolderOk()) {
            throw new ProCoreException("Folder must be valid database folder to create database from journal.");
        }
        File folder = this.server.getFolder();
        File file = new File(folder, "procore.dumpChangeSets.procore");
        if (!file.isFile() && !file.canRead()) {
            throw new ProCoreException("Dump file must be readable. file=" + file.getAbsolutePath());
        }
        Path db = Paths.get(folder.getAbsolutePath(), new String[0]);
        Path temp = this.createTempFolder(db, "Could not create temporary directory for database to be created from change sets.");
        Server s = new Server(temp.toFile());
        s.createConfiguration();
        s.start();
        String t = s.execute("loadChangeSets .. " + revision);
        if (t.length() < 1) {
            throw new ProCoreException("Could not read journal. reply=" + t);
        }
        s.tryToStop();
        try {
            int cs = Integer.parseInt(t);
            if (cs == revision) {
                return temp;
            }
            throw new ProCoreException("Could not load change sets. reply=" + t);
        }
        catch (NumberFormatException e) {
            throw new ProCoreException("Could not load change sets. reply=" + t);
        }
    }

    @Override
    public void clone(File to, int revision, boolean saveHistory) {
        String history = saveHistory ? "with history." : "without history.";
        String message = "Clone to " + to.getAbsolutePath() + "@" + revision + " " + history;
        Util.trace(message);
    }

    @Override
    public DatabaseUserAgent getUserAgent() {
        return this.dbUserAgent;
    }

    @Override
    public void setUserAgent(DatabaseUserAgent dbUserAgent) {
        this.dbUserAgent = dbUserAgent;
    }

    @Override
    public Database.Status getStatus() {
        return this.server.getStatus();
    }

    @Override
    public File getFolder() {
        return this.server.getFolder();
    }

    @Override
    public boolean isFolderOk() {
        return this.server.isFolderOk(this.server.getFolder());
    }

    @Override
    public boolean isFolderOk(File folder) {
        return this.server.isFolderOk(folder);
    }

    @Override
    public boolean isFolderEmpty() {
        return this.isFolderEmpty(this.server.getFolder());
    }

    @Override
    public boolean isFolderEmpty(File folder) {
        return this.isFolderEmpty(folder.toPath());
    }

    @Override
    public void deleteGuard() throws ProCoreException {
        this.server.deleteGuard();
    }

    @Override
    public boolean isConnected() throws ProCoreException {
        return this.server.isConnected();
    }

    @Override
    public void connect() throws ProCoreException {
        if (!this.isFolderOk()) {
            throw new ProCoreException("Could not connect to " + this.getFolder());
        }
        if (!this.server.isAlive()) {
            this.server.start();
        }
        if (this.isConnected()) {
            return;
        }
        try {
            this.server.connect();
        }
        catch (InterruptedException e) {
            Util.logError("Server connect was interrupted.", e);
        }
        if (this.server.isActive()) {
            return;
        }
        throw new ProCoreException("Could not connect to " + this.getFolder());
    }

    @Override
    public void disconnect() throws ProCoreException {
        this.server.disconnect();
    }

    @Override
    public Path dumpChangeSets() throws ProCoreException {
        block5: {
            if (!this.isFolderOk()) {
                throw new ProCoreException("Folder must be set to dump change sets.");
            }
            if (!this.server.isActive()) {
                throw new ProCoreException("Server must be responsive to dump change sets.");
            }
            String t = this.server.execute("dumpChangeSets").replaceAll("\n", "");
            try {
                int ncs = Integer.parseInt(t);
                if (ncs >= 1) break block5;
                return null;
            }
            catch (NumberFormatException e) {
                throw new ProCoreException("Could not dump change sets.", e);
            }
        }
        File file = new File(this.getFolder(), "procore.dumpChangeSets.procore");
        return file.toPath();
    }

    @Override
    public long serverGetTailChangeSetId() throws ProCoreException {
        try {
            return ((Server)this.server).proCoreServer.getTailData().nextChangeSetId;
        }
        catch (TailReadException e) {
            return 1L;
        }
    }

    @Override
    public JournalI getJournal() throws ProCoreException {
        return this.journal;
    }

    static enum FileOption {
        IF_EXIST,
        IF_NEW,
        OVERWRITE;

    }

    class JournalI
    implements Database.Journal {
        private final Analyzed analyzed;

        JournalI(File dbFolder) {
            this.analyzed = new Analyzed(dbFolder);
        }

        @Override
        public boolean canRead() {
            return this.analyzed.canRead() && !DatabaseI.this.isServerAlive();
        }

        @Override
        public int count() {
            return this.analyzed.count();
        }

        @Override
        public int read(int index, Database.Journal.Line line) throws ProCoreException {
            int count = this.analyzed.count();
            this.analyzed.getRow(index, line);
            return count;
        }

        class Analyzed {
            private final File journalFile;
            private long lastModified;
            private RandomAccessFile file;
            private ArrayList<Long> offsets = new ArrayList();
            private Database.Journal.Line[] lines = new Database.Journal.Line[256];
            int firstLine = 0;

            Analyzed(File dbFolder) {
                this.journalFile = new File(dbFolder, "procore.journal.procore");
                int i = 0;
                while (i < this.lines.length) {
                    this.lines[i] = new Database.Journal.Line();
                    ++i;
                }
            }

            private boolean canRead() {
                return this.journalFile.isFile() && this.journalFile.canRead();
            }

            private int count() {
                try {
                    return this.readOffsets().size();
                }
                catch (ProCoreException e) {
                    Util.logError("Failed to read or analyze journal. file=" + this.journalFile, (Throwable)((Object)e));
                    this.clear();
                    return 0;
                }
            }

            private void clear() {
                this.close();
                this.offsets.clear();
            }

            private void close() {
                if (this.file != null) {
                    try {
                        this.file.close();
                    }
                    catch (Throwable e) {
                        Logger.defaultLogError((String)"Close file threw an exception.", (Throwable)e);
                    }
                    this.file = null;
                }
            }

            private void open() throws ProCoreException {
                try {
                    this.file = new RandomAccessFile(this.journalFile, "r");
                }
                catch (Throwable e) {
                    this.file = null;
                    throw new ProCoreException("Failed to open journal file.", e);
                }
            }

            private String getComment(byte[] bytes) throws ProCoreException {
                Serializer METADATA_SERIALIZER = Bindings.getSerializerUnchecked((Binding)new TreeMapBinding((Binding)Bindings.STRING, (Binding)Bindings.BYTE_ARRAY));
                try {
                    TreeMap metadata = (TreeMap)METADATA_SERIALIZER.deserialize(bytes);
                    CommitMetadata commit = (CommitMetadata)MetadataUtil.getMetadata((Map)metadata, CommitMetadata.class);
                    String date = "<metadata does not contain date>";
                    if (commit != null && commit.date != null) {
                        date = commit.date.toString();
                    }
                    CommentMetadata comment = (CommentMetadata)MetadataUtil.getMetadata((Map)metadata, CommentMetadata.class);
                    String comments = "<metadata does not contain comment>";
                    if (comment != null) {
                        comments = comment.toString();
                    }
                    return String.valueOf(date) + " " + comments;
                }
                catch (IOException e) {
                    throw new ProCoreException("Failed to interpret metadata.", e);
                }
            }

            private Database.Journal.Line getRow(int index, Database.Journal.Line line) throws ProCoreException {
                if (index < 0 || index >= this.offsets.size()) {
                    return null;
                }
                if (index < this.firstLine || index >= this.firstLine + this.lines.length) {
                    this.readLines(index);
                    if (index < this.firstLine) {
                        return null;
                    }
                }
                int offset = index - this.firstLine;
                line.status = this.lines[offset].status;
                line.request = this.lines[offset].request;
                line.comment = this.lines[offset].comment;
                return line;
            }

            private void readLines(int first) throws ProCoreException {
                this.open();
                try {
                    int i = 0;
                    int index = first;
                    while (i < this.lines.length) {
                        this.readLine(index, this.lines[i]);
                        ++i;
                        ++index;
                    }
                    this.firstLine = first;
                }
                finally {
                    this.close();
                }
            }

            private void readLine(int index, Database.Journal.Line line) throws ProCoreException {
                if (index >= this.offsets.size()) {
                    line.status = false;
                    line.request = "<Illegal request.>";
                    line.comment = "<Illegal request.>";
                    return;
                }
                long offset = this.offsets.get(index);
                try {
                    int length2;
                    this.file.seek(offset);
                    int i = this.file.readInt();
                    int length = Integer.reverseBytes(i);
                    byte b = this.file.readByte();
                    boolean ok = b != 0;
                    b = this.file.readByte();
                    i = this.file.readInt();
                    int type = Integer.reverseBytes(i);
                    String comment = "";
                    if (length < 6) {
                        throw new ProCoreException("Journal file corrupted at" + this.file.getFilePointer() + ".");
                    }
                    if (length > 6) {
                        if (type != 3) {
                            this.file.skipBytes(length - 6);
                        } else if (length > 22) {
                            this.file.skipBytes(16);
                            i = this.file.readInt();
                            int size = Integer.reverseBytes(i);
                            if (size != length - 26) {
                                throw new ProCoreException("Metadata corrupted at" + this.file.getFilePointer() + ".");
                            }
                            byte[] bytes = new byte[size];
                            this.file.readFully(bytes);
                            comment = this.getComment(bytes);
                            if (comment == null) {
                                comment = "<metadata does not contain comment>";
                            }
                        }
                    }
                    if (length != (length2 = Integer.reverseBytes(i = this.file.readInt()))) {
                        throw new ProCoreException("Journal file corrupted at" + this.file.getFilePointer() + ".");
                    }
                    String command = MessageText.get(type);
                    line.status = ok;
                    line.request = command;
                    line.comment = comment;
                }
                catch (IOException e) {
                    throw new ProCoreException("Journal file corrupted.");
                }
            }

            private ArrayList<Long> readOffsets() throws ProCoreException {
                long modified;
                block14: {
                    if (!this.canRead()) {
                        this.lastModified = 0L;
                        this.offsets.clear();
                        this.firstLine = 0;
                        return this.offsets;
                    }
                    modified = this.journalFile.lastModified();
                    if (this.lastModified != 0L && this.lastModified == modified) {
                        return this.offsets;
                    }
                    this.lastModified = 0L;
                    this.offsets.clear();
                    this.firstLine = 0;
                    this.open();
                    try {
                        this.file.seek(0L);
                        int i = this.file.readInt();
                        int version = Integer.reverseBytes(i);
                        if (version != 1) {
                            throw new ProCoreException("Unsupported journal file version. expected=1 got=" + version);
                        }
                        i = this.file.readInt();
                        int major = Integer.reverseBytes(i);
                        if (major != 24) {
                            throw new ProCoreException("Unsupported journal request major version. expected=24 got=" + major);
                        }
                        i = this.file.readInt();
                        int minor = Integer.reverseBytes(i);
                        if (minor > 1) {
                            throw new ProCoreException("Unsupported journal request minor version. expected=1 got=" + minor);
                        }
                        i = this.file.readInt();
                        int length = Integer.reverseBytes(i);
                        while (length > 0) {
                            if (length < 6) {
                                throw new ProCoreException("Journal file corrupted at" + this.file.getFilePointer() + ".");
                            }
                            this.file.skipBytes(length);
                            i = this.file.readInt();
                            int length2 = Integer.reverseBytes(i);
                            if (length != length2) {
                                throw new ProCoreException("Journal file corrupted at " + this.file.getFilePointer() + ".");
                            }
                            long offset = this.file.getFilePointer() - (long)length - 8L;
                            this.offsets.add(offset);
                            i = this.file.readInt();
                            length = Integer.reverseBytes(i);
                        }
                    }
                    catch (EOFException i) {
                        this.close();
                        break block14;
                    }
                    catch (IOException e) {
                        try {
                            throw new ProCoreException("Failed to get command count.", e);
                        }
                        catch (Throwable throwable) {
                            this.close();
                            throw throwable;
                        }
                    }
                    this.close();
                }
                this.lastModified = modified;
                this.readLines(0);
                return this.offsets;
            }
        }
    }

    class Server {
        private final File folder;
        private final ProCoreServer proCoreServer;

        void start() throws ProCoreException {
            try {
                this.proCoreServer.start();
            }
            catch (DatabaseLastExitException e) {
                if (DatabaseI.this.dbUserAgent == null) {
                    return;
                }
                if (!DatabaseI.this.dbUserAgent.handleStart((InternalException)e)) {
                    throw new ProCoreException(this.folder, "Failed to handle start exception.", (Throwable)((Object)e));
                }
                this.proCoreServer.start();
            }
        }

        void stop() throws ProCoreException {
            block2: {
                try {
                    this.proCoreServer.stop();
                }
                catch (InterruptedException e) {
                    if (!this.proCoreServer.isAlive()) break block2;
                    throw new ProCoreException("ProCoreServer stop was interrupted.", e);
                }
            }
        }

        boolean isAlive() {
            try {
                return this.proCoreServer.isAlive();
            }
            catch (ProCoreException e) {
                Logger.defaultLogError((Throwable)((Object)e));
                return false;
            }
        }

        Server(File aFolder) {
            if (aFolder == null) {
                throw new RuntimeException("Database folder can not be null.");
            }
            try {
                this.folder = aFolder.getCanonicalFile();
            }
            catch (IOException e) {
                String t = "Could not get canonical path. file=" + aFolder;
                Logger.defaultLogError((String)t);
                throw new RuntimeException(t);
            }
            try {
                File serverFolder = Activator.getServerFolder();
                if (!this.folder.isDirectory()) {
                    this.folder.mkdirs();
                }
                this.proCoreServer = ProCoreServer.getProCoreServer(serverFolder, this.folder);
                return;
            }
            catch (Throwable t) {
                Logger.defaultLogError((Throwable)t);
                throw new RuntimeException(t);
            }
        }

        void createConfiguration() throws ProCoreException {
            if (!this.folder.isDirectory()) {
                throw new ProCoreException("Can't create configuration because folder is not ok. folder=" + this.folder.getAbsolutePath());
            }
            File file = new File(this.folder, "procore.config.procore");
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new ProCoreException("Can't create configuration file. file=" + file.getAbsolutePath());
            }
        }

        void deleteGuard() throws ProCoreException {
            if (DatabaseI.this.server.isActive()) {
                throw new ProCoreException("Will not delete guard file when server is alive.");
            }
            if (!DatabaseI.this.server.isFolderOk(DatabaseI.this.server.getFolder())) {
                throw new ProCoreException("Will not delete guard file when server folder is not ok. folder=" + DatabaseI.this.server.getFolder());
            }
            File file = new File(this.folder, "procore.guard.procore");
            if (!file.exists()) {
                throw new ProCoreException("Guard file does not exist. file=" + file.getAbsolutePath());
            }
            boolean deleted = file.delete();
            if (!deleted) {
                throw new ProCoreException("Failed to delete file=" + file.getAbsolutePath());
            }
        }

        String execute(String aCommand) throws ProCoreException {
            try {
                return this.proCoreServer.execute(aCommand);
            }
            catch (InterruptedException e) {
                throw new ProCoreException("Execute call was interrupted.", e);
            }
        }

        Database.Status getStatus() {
            String path;
            Database.Status status = Database.Status.NoDatabase;
            try {
                path = this.folder.getCanonicalPath();
            }
            catch (IOException e) {
                Util.logError("Could not get canonical path for folder. folder=" + this.folder.getAbsolutePath(), e);
                path = "<no path>";
            }
            status = !this.isFolderOk(this.folder) ? Database.Status.NoDatabase : (!this.isAlive() ? Database.Status.NotRunning : (this.isConnected() ? (this.isLocal() ? Database.Status.Local : Database.Status.Remote) : Database.Status.Standalone));
            status.message = String.valueOf(status.getString()) + "@" + path;
            return status;
        }

        File getFolder() {
            return this.folder;
        }

        boolean isActive() {
            try {
                return this.proCoreServer.isActive();
            }
            catch (ProCoreException e) {
                Logger.defaultLogError((String)"IsActive failed.", (Throwable)((Object)e));
                return false;
            }
        }

        boolean isConnected() {
            try {
                return this.proCoreServer.isConnected();
            }
            catch (ProCoreException e) {
                Logger.defaultLogError((String)"IsConnected failed.", (Throwable)((Object)e));
                return false;
            }
        }

        boolean isLocal() {
            try {
                return this.proCoreServer.isLocal();
            }
            catch (ProCoreException e) {
                Logger.defaultLogError((String)"IsLocal faailed.", (Throwable)((Object)e));
                return false;
            }
        }

        void connect() throws ProCoreException, InterruptedException {
            this.proCoreServer.connect();
        }

        void disconnect() {
            try {
                this.proCoreServer.disconnect();
            }
            catch (ProCoreException e) {
                Logger.defaultLogError((String)"Could not disconnect.", (Throwable)((Object)e));
            }
        }

        boolean isFolderOk(File aFolder) {
            if (!aFolder.isDirectory()) {
                return false;
            }
            File config = new File(aFolder, "procore.config.procore");
            if (config.exists()) {
                return true;
            }
            File journal = new File(aFolder, "procore.journal.procore");
            return journal.exists();
        }

        boolean tryToStop() throws ProCoreException {
            return this.proCoreServer.tryToStop();
        }

        Client newClient() throws ProCoreException {
            return this.proCoreServer.newClient();
        }

        class Command {
            Command() {
            }

            void Do(ProCoreServer proCoreServer) {
            }
        }

        class Event {
            Event() {
            }
        }
    }
}

