/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.server.internal;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.concurrent.CountDownLatch;
import org.simantics.db.server.ProCoreException;
import org.simantics.db.server.internal.ChangeSetUpdateEvent;
import org.simantics.db.server.internal.Connection;
import org.simantics.db.server.internal.ConnectionManager;
import org.simantics.db.server.internal.DefaultEventHandler;
import org.simantics.db.server.internal.EventHandler;
import org.simantics.db.server.internal.Method;
import org.simantics.db.server.internal.MethodQueue;
import org.simantics.db.server.internal.Packet;
import org.simantics.db.server.internal.PacketQueue;
import org.simantics.db.server.internal.Util;

class ConnectionThread {
    private static final boolean DEBUG = false;
    private static final int HEADER_N = 5;
    private static final int HEADER_SIZE = 20;
    private static final int DEFLATE = 4;
    private static final int INCREMENT_SIZE = 8192;
    private static int instanceCount = 0;
    private final ConnectionManager connectionManager;
    private final PacketQueue inputQueue = new PacketQueue();
    private final Connection connection = new Connection(this);
    private final Manager manager = new Manager();
    private Thread thread = new Thread((Runnable)this.manager, this.manager.toString());
    private int[] header = null;
    private int[] INTS = new int[5];
    private int remaining = 20;
    private int deflateSize;

    ConnectionThread(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    ByteBuffer getInputBuffer() {
        return this.getInputBuffer(8192);
    }

    ByteBuffer getInputBuffer(int sizeAtLeast) {
        ByteBuffer bb = ByteBuffer.allocate(Math.max(sizeAtLeast, 8192));
        bb.order(ByteOrder.LITTLE_ENDIAN);
        return bb;
    }

    public String toString() {
        return "header=" + this.header + " remaining=" + this.remaining;
    }

    private String toString(ByteBuffer buffer, int nRead) {
        return this + " nRead=" + nRead + " buffer=" + buffer;
    }

    ByteBuffer handleInput(ByteBuffer buffer, int nRead) throws IOException {
        int position = buffer.position();
        if (this.header == null) {
            if (position < 20) {
                return buffer;
            }
            buffer.position(0);
            IntBuffer ib = buffer.asIntBuffer();
            ib.get(this.INTS);
            ib = null;
            this.header = this.INTS;
            this.deflateSize = this.header[4];
            if (this.deflateSize < 0) {
                throw new IOException("Illegal deflate size=" + this.deflateSize);
            }
            this.remaining += this.deflateSize;
            if (this.remaining > buffer.limit()) {
                ByteBuffer bb = this.getInputBuffer(this.remaining);
                buffer.position(0);
                buffer.limit(position);
                bb.put(buffer);
                return bb;
            }
            buffer.position(position);
        }
        if (position < this.remaining) {
            return buffer;
        }
        if (position > this.remaining) {
            ByteBuffer bb = this.getInputBuffer(this.remaining);
            buffer.position(0);
            buffer.limit(this.remaining);
            bb.put(buffer);
            this.inputQueue.addFirst(new Packet(this.header, bb));
            ByteBuffer b2 = this.getInputBuffer(buffer.limit());
            buffer.position(this.remaining);
            buffer.limit(position);
            b2.put(buffer);
            this.header = null;
            this.remaining = 20;
            return this.handleInput(b2, b2.position());
        }
        if (position != this.remaining) {
            throw new IOException("Assertion error. this=" + this.toString(buffer, nRead));
        }
        this.inputQueue.addFirst(new Packet(this.header, buffer));
        this.header = null;
        this.remaining = 20;
        return this.getInputBuffer(8192);
    }

    InetSocketAddress getAddress() {
        return this.manager.getAddress();
    }

    boolean isConnected() {
        return this.manager.isConnected();
    }

    void reconnect() throws ProCoreException, InterruptedException {
        this.manager.reconnect();
    }

    void connect(int port) throws ProCoreException, InterruptedException {
        this.manager.connect(port);
    }

    void connect(InetSocketAddress address) throws ProCoreException, InterruptedException {
        this.manager.connect(address);
    }

    void disconnect() {
        this.manager.disconnect();
    }

    Connection call(Method m) throws ProCoreException, InterruptedException, IOException {
        this.manager.call(m);
        return this.connection;
    }

    class Manager
    implements Runnable {
        private final int instance;
        private volatile boolean carryOn = true;
        private volatile int lastTokenIn = 0;
        private volatile MethodQueue methodQueue = new MethodQueue();
        private volatile CountDownLatch running = new CountDownLatch(1);
        private final EventHandler defaultEventHandler = new DefaultEventHandler();

        Manager() {
            int n = instanceCount + 1;
            instanceCount = n;
            this.instance = n;
        }

        public String toString() {
            return "Connection " + this.instance;
        }

        InetSocketAddress getAddress() {
            return ConnectionThread.this.connection.getAddress();
        }

        boolean isConnected() {
            return ConnectionThread.this.connection.isConnected();
        }

        void reconnect() throws ProCoreException, InterruptedException {
            InetSocketAddress a = ConnectionThread.this.connection.getAddress();
            if (ConnectionThread.this.connection.addressNotInitialized() || a.getPort() == 0) {
                throw new ProCoreException("Address not ok. address=" + ConnectionThread.this.connection.getAddress());
            }
            this.connect(a);
        }

        void connect(int port) throws ProCoreException, InterruptedException {
            InetSocketAddress a = ConnectionThread.this.connection.getAddress();
            if (ConnectionThread.this.connection.addressNotInitialized() || a.getPort() == 0 || port != 0 && port != a.getPort()) {
                a = new InetSocketAddress("127.0.0.1", port);
            }
            this.connect(a);
        }

        void connect(InetSocketAddress address) throws ProCoreException, InterruptedException {
            if (ConnectionThread.this.connection.isConnected()) {
                if (ConnectionThread.this.connection.equalsAddress(address)) {
                    return;
                }
                throw new ProCoreException("Already connected to different address. old=" + ConnectionThread.this.connection.getAddress() + " new=" + address);
            }
            ConnectionThread.this.connection.init4Connection(address);
            ConnectionThread.this.connectionManager.connect(ConnectionThread.this.connection);
            if (ConnectionThread.this.thread.isAlive()) {
                return;
            }
            ConnectionThread.this.thread.start();
            this.running.await();
        }

        void call(Method method) throws ProCoreException, InterruptedException, IOException {
            ConnectionThread.this.connection.sendMethod(this.methodQueue, method, this.lastTokenIn);
        }

        void disconnect() {
            this.methodQueue.close();
            ConnectionThread.this.connection.disconnect();
        }

        @Override
        public void run() {
            block9: {
                try {
                    try {
                        this.running.countDown();
                        while (this.carryOn) {
                            Packet packet = null;
                            try {
                                packet = ConnectionThread.this.inputQueue.takeFirst();
                            }
                            catch (InterruptedException e) {
                                Util.trace("Wait for input packet interrupted. this=" + this);
                                continue;
                            }
                            if (packet == null) break;
                            this.handlePacket(packet);
                        }
                        if (this.carryOn) {
                            Util.trace("Thread " + ConnectionThread.this.thread.getName() + " stopped with null packet.");
                            break block9;
                        }
                        Util.trace("Thread " + ConnectionThread.this.thread.getName() + " stopped with false carryOn.");
                    }
                    catch (Throwable t) {
                        Util.logError("Thread " + ConnectionThread.this.thread.getName() + " stopped to exception:", t);
                        this.disconnect();
                        this.running.countDown();
                    }
                }
                finally {
                    this.disconnect();
                    this.running.countDown();
                }
            }
        }

        private void handlePacket(Packet packet) throws ProCoreException {
            Method method;
            if (packet.header.token > this.lastTokenIn) {
                this.lastTokenIn = packet.header.token;
            }
            if ((method = this.methodQueue.remove(packet.header.token)) == null) {
                try {
                    switch (packet.header.messageNumber) {
                        default: {
                            Util.logError("Missing method. token=" + packet.header.token);
                            return;
                        }
                        case 10: 
                    }
                    this.defaultEventHandler.on(new ChangeSetUpdateEvent(packet));
                }
                catch (Throwable t) {
                    Util.logError("Event handler failed:", t);
                }
                return;
            }
            switch (packet.header.messageNumber) {
                default: {
                    String s = "Illegal message number " + packet.header.messageNumber;
                    method.gotException(s);
                    break;
                }
                case 10: {
                    method.getEventHandler(this.defaultEventHandler).on(new ChangeSetUpdateEvent(packet));
                    this.methodQueue.add(method);
                    break;
                }
                case 0: {
                    break;
                }
                case 18: {
                    method.gotException(packet);
                    break;
                }
                case 2: 
                case 7: 
                case 9: 
                case 12: 
                case 14: 
                case 16: 
                case 20: 
                case 22: 
                case 24: 
                case 26: 
                case 28: 
                case 30: 
                case 32: 
                case 34: 
                case 36: 
                case 38: 
                case 40: 
                case 44: 
                case 50: 
                case 52: 
                case 54: 
                case 56: 
                case 58: {
                    method.gotPacket(packet);
                }
            }
        }
    }
}

