/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.server.internal;

import org.simantics.db.server.Database;
import org.simantics.db.server.ProCoreException;
import org.simantics.db.server.internal.Event;
import org.simantics.db.server.internal.EventHandler;
import org.simantics.db.server.internal.Util;
import org.simantics.db.server.protocol.ChangeSetUpdateEvent;

class ChangeSetEventHandler
extends EventHandler
implements Database.Session.ChangeSetUpdate {
    private final ChangeSetUpdateEvent csuEvent = new ChangeSetUpdateEvent();
    private final Database.Session.OnChangeSetUpdate on;
    private ProCoreException exception;

    ChangeSetEventHandler(Database.Session.OnChangeSetUpdate on) {
        this.on = on;
    }

    @Override
    void on(Event event) {
        event.deserialize(this.csuEvent);
        Util.log("ChangeSetEvent cid=" + this.csuEvent.changeSetId);
        try {
            if (this.on != null) {
                this.on.onChangeSetUpdate(this);
            }
        }
        catch (ProCoreException e) {
            if (this.exception == null) {
                this.exception = new ProCoreException("Execution of ChangeSetUpdate callback failed.", (Throwable)((Object)e));
            }
            Util.logError("Execution of ChangeSetUpdate callback failed(2).", (Throwable)((Object)e));
        }
    }

    @Override
    public long getChangeSetId() {
        return this.csuEvent.changeSetId;
    }

    @Override
    public int getChangeSetIndex() {
        return this.csuEvent.changeSetIndex;
    }

    @Override
    public int getNumberOfClusterChangeSets() {
        return this.csuEvent.numberOfClusterChangeSets;
    }

    @Override
    public int getIndexOfClusterChangeSet() {
        return this.csuEvent.indexOfClusterChangeSet;
    }

    @Override
    public byte[] getClusterId() {
        return this.csuEvent.clusterUID;
    }

    @Override
    public boolean getNewCluster() {
        return this.csuEvent.newCluster;
    }

    @Override
    public byte[] getData() {
        return this.csuEvent.data;
    }
}

