/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.server;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Properties;
import org.simantics.db.DatabaseUserAgent;
import org.simantics.db.server.ProCoreException;

public interface Database {
    public DatabaseUserAgent getUserAgent();

    public void setUserAgent(DatabaseUserAgent var1);

    public Status getStatus();

    public File getFolder();

    public boolean isFolderOk();

    public boolean isFolderOk(File var1);

    public boolean isFolderEmpty();

    public boolean isFolderEmpty(File var1);

    public void initFolder(Properties var1) throws ProCoreException;

    public void deleteFiles() throws ProCoreException;

    public void start() throws ProCoreException;

    public boolean isRunning() throws ProCoreException;

    public boolean tryToStop() throws ProCoreException;

    public void connect() throws ProCoreException;

    public boolean isConnected() throws ProCoreException;

    public String execute(String var1) throws ProCoreException;

    public void disconnect() throws ProCoreException;

    public void clone(File var1, int var2, boolean var3) throws ProCoreException;

    public Path createFromChangeSets(int var1) throws ProCoreException;

    public void deleteGuard() throws ProCoreException;

    public Path dumpChangeSets() throws ProCoreException;

    public void purgeDatabase() throws ProCoreException;

    public long serverGetTailChangeSetId() throws ProCoreException;

    public Session newSession() throws ProCoreException;

    public Journal getJournal() throws ProCoreException;

    public static interface Journal {
        public boolean canRead();

        public int count();

        public int read(int var1, Line var2) throws ProCoreException;

        public static class Line {
            public boolean status;
            public String request;
            public String comment;
        }
    }

    public static interface Session {
        public Database getDatabase();

        public void close() throws ProCoreException;

        public void open() throws ProCoreException;

        public boolean isClosed() throws ProCoreException;

        public void acceptCommit(long var1, long var3, byte[] var5) throws ProCoreException;

        public long cancelCommit(long var1, long var3, byte[] var5, OnChangeSetUpdate var6) throws ProCoreException;

        public Transaction askReadTransaction() throws ProCoreException;

        public Transaction askWriteTransaction(long var1) throws ProCoreException;

        public long endTransaction(long var1) throws ProCoreException;

        public String execute(String var1) throws ProCoreException;

        public byte[] getChangeSetMetadata(long var1) throws ProCoreException;

        public ChangeSetData getChangeSetData(long var1, long var3, OnChangeSetUpdate var5) throws ProCoreException;

        public ChangeSetIds getChangeSetIds() throws ProCoreException;

        public Cluster getCluster(byte[] var1) throws ProCoreException;

        public ClusterChanges getClusterChanges(long var1, byte[] var3) throws ProCoreException;

        public ClusterIds getClusterIds() throws ProCoreException;

        public Information getInformation() throws ProCoreException;

        public Refresh getRefresh(long var1) throws ProCoreException;

        public ResourceSegment getResourceSegment(byte[] var1, int var2, long var3, short var5) throws ProCoreException;

        public long reserveIds(int var1) throws ProCoreException;

        public void updateCluster(byte[] var1) throws ProCoreException;

        public boolean undo(long[] var1, OnChangeSetUpdate var2) throws ProCoreException;

        public static interface ChangeSetData {
            public boolean isOk();
        }

        public static interface ChangeSetIds {
            public long getFirstChangeSetId();

            public int getCount();
        }

        public static interface ChangeSetUpdate {
            public long getChangeSetId();

            public int getChangeSetIndex();

            public int getNumberOfClusterChangeSets();

            public int getIndexOfClusterChangeSet();

            public byte[] getClusterId();

            public boolean getNewCluster();

            public byte[] getData();
        }

        public static interface Cluster {
            public int getInflateSize();

            public ByteBuffer getDeflated();
        }

        public static interface ClusterChanges {
            public long getHeadChangeSetId();

            public int[] getResourceIndex();

            public int[] getPredicateIndex();

            public long[] getPredicateFirst();

            public long[] getPredicateSecond();

            public int[] getValueIndex();
        }

        public static interface ClusterIds {
            public int getStatus();

            public long[] getFirst();

            public long[] getSecond();
        }

        public static interface Information {
            public String getServerId();

            public String getProtocolId();

            public String getDatabaseId();

            public long getFirstChangeSetId();
        }

        public static interface OnChangeSetUpdate {
            public void onChangeSetUpdate(ChangeSetUpdate var1) throws ProCoreException;
        }

        public static interface Refresh {
            public long getHeadChangeSetId();

            public long[] getFirst();

            public long[] getSecond();
        }

        public static interface ResourceSegment {
            public byte[] getClusterId();

            public int getResourceIndex();

            public long getValueSize();

            public byte[] getSegment();

            public long getOffset();
        }

        public static interface Transaction {
            public long getHeadChangeSetId();

            public long getTransactionId();
        }
    }

    public static enum Status {
        NoDatabase{

            @Override
            public String getString() {
                return "NoDatabase";
            }
        }
        ,
        NotRunning{

            @Override
            public String getString() {
                return "NotRunning";
            }
        }
        ,
        Standalone{

            @Override
            public String getString() {
                return "Standalone";
            }
        }
        ,
        Local{

            @Override
            public String getString() {
                return "Local";
            }
        }
        ,
        Remote{

            @Override
            public String getString() {
                return "Remote";
            }
        };

        public String message = "";

        public abstract String getString();

        public String toString() {
            return this.message;
        }
    }
}

