/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.simantics.charts.editor.HideItemsAction;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.ui.contribution.DynamicMenuContribution;
import org.simantics.utils.ui.AdaptionUtils;

public class HideItemsContribution
extends DynamicMenuContribution {
    public HideItemsContribution() {
    }

    public HideItemsContribution(String id) {
        super(id);
    }

    protected IContributionItem[] getContributionItems(ReadGraph graph, Object[] input) throws DatabaseException {
        HideItemsAction show;
        List<Resource> resources = this.toResources(input);
        if (resources.isEmpty()) {
            return NONE;
        }
        ChartResource CHART = ChartResource.getInstance((ReadGraph)graph);
        int hidden = 0;
        int visible = 0;
        for (Resource r : resources) {
            if (!graph.isInstanceOf(r, CHART.Chart_Item)) {
                return NONE;
            }
            Boolean isHidden = (Boolean)graph.getPossibleRelatedValue(r, CHART.Chart_Item_hidden, (Binding)Bindings.BOOLEAN);
            if (Boolean.TRUE.equals(isHidden)) {
                ++hidden;
                continue;
            }
            ++visible;
        }
        HideItemsAction hide = visible > 0 ? new HideItemsAction("Hide Items", true, resources) : null;
        HideItemsAction hideItemsAction = show = hidden > 0 ? new HideItemsAction("Unhide Items", false, resources) : null;
        if (hidden > 0 && visible > 0) {
            return this.toContributionItems(new IAction[]{hide, show});
        }
        if (hidden > 0) {
            return this.toContributionItems(new IAction[]{show});
        }
        return this.toContributionItems(new IAction[]{hide});
    }

    private List<Resource> toResources(Object[] input) {
        ArrayList<Resource> result = null;
        Object[] objectArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            Resource r = (Resource)AdaptionUtils.adaptToSingle((Object)o, Resource.class);
            if (r == null) {
                return Collections.emptyList();
            }
            if (result == null) {
                result = new ArrayList<Resource>(input.length);
            }
            result.add(r);
            ++n2;
        }
        return result == null ? Collections.emptyList() : result;
    }
}

