/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.ui;

import java.text.Format;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.simantics.charts.ui.ChartData;
import org.simantics.db.common.NamedResource;
import org.simantics.modeling.ui.chart.property.ChartComposite;
import org.simantics.trend.configuration.TrendItem;
import org.simantics.trend.configuration.YAxisMode;
import org.simantics.utils.format.TimeFormat;
import org.simantics.utils.ui.ISelectionUtils;

public class ChartDialog
extends Dialog {
    Format timeFormat = new TimeFormat(100.0, 3);
    Label lName;
    Label lStartTime;
    Label lLength;
    Label lScrollIncrement;
    Label lAxisMode;
    Text tName;
    Text tStartTime;
    Text tLength;
    Scale sIncrement;
    Combo cAxisMode;
    Button bMilestones;
    Button bTrackExperimentTime;
    ListViewer lVisibleItems;
    ListViewer lHiddenItems;
    ControlDecoration tStartTimeDecor;
    ControlDecoration tLengthDecor;
    ChartData data;

    public ChartDialog(Shell parentShell, ChartData data) {
        super(parentShell);
        this.data = data;
        this.setShellStyle(2160);
    }

    protected Control createDialogArea(Composite parent) {
        String str;
        Composite c = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.fillDefaults().margins(8, 8).numColumns(9).applyTo(c);
        GridDataFactory gd1 = GridDataFactory.fillDefaults().align(4, 0x1000000).span(1, 1);
        GridDataFactory gd2 = GridDataFactory.fillDefaults().indent(5, 0).grab(true, false).span(8, 1);
        this.lName = new Label(c, 0);
        this.lName.setText("Name:");
        gd1.applyTo((Control)this.lName);
        this.tName = new Text(c, 2048);
        this.tName.setEnabled(true);
        if (this.data.name != null) {
            this.tName.setText(this.data.name);
        }
        gd2.applyTo((Control)this.tName);
        Label l = new Label(c, 0);
        l.setText("Chart Time Window Preference (Auto-scale)");
        GridDataFactory.fillDefaults().span(9, 1).applyTo((Control)l);
        this.lStartTime = new Label(c, 0);
        this.lStartTime.setText("Time Start:");
        gd1.applyTo((Control)this.lStartTime);
        this.tStartTime = new Text(c, 2048);
        this.tStartTime.setToolTipText("Chart Window Fixed Start Time in Seconds or Yy Dd HH:mm:ss.ddd");
        if (this.data.timeStart != null) {
            str = this.timeFormat.format(this.data.timeStart);
            this.tStartTime.setText(str);
        }
        gd2.applyTo((Control)this.tStartTime);
        this.tStartTime.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChartDialog.this.data.timeStart = ChartDialog.this.parseTime(ChartDialog.this.tStartTime, false, 0.0);
                ChartDialog.this.validate();
            }
        });
        this.lLength = new Label(c, 0);
        this.lLength.setText("Length:");
        gd1.applyTo((Control)this.lLength);
        this.tLength = new Text(c, 2048);
        this.tLength.setToolTipText("Chart Window Fixed Time Axis Length in Seconds or Yy Dd HH:mm:ss.ddd");
        if (this.data.timeLength != null) {
            str = this.timeFormat.format(this.data.timeLength);
            this.tLength.setText(str);
        }
        gd2.applyTo((Control)this.tLength);
        this.tLength.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChartDialog.this.data.timeLength = ChartDialog.this.parseTime(ChartDialog.this.tLength, false, 0.0);
                ChartDialog.this.validate();
            }
        });
        this.lScrollIncrement = new Label(c, 0);
        this.lScrollIncrement.setText("Scroll Increment:");
        gd1.applyTo((Control)this.lScrollIncrement);
        this.sIncrement = new Scale(c, 256);
        this.sIncrement.setMinimum(1);
        this.sIncrement.setMaximum(100);
        this.sIncrement.setIncrement(10);
        this.sIncrement.setPageIncrement(10);
        if (this.data.timeIncrement != null) {
            this.sIncrement.setSelection((int)this.data.timeIncrement.doubleValue());
        }
        gd2.copy().span(7, 1).applyTo((Control)this.sIncrement);
        final Text sIncrementText = new Text(c, 131080);
        gd1.copy().hint(35, -1).applyTo((Control)sIncrementText);
        this.sIncrement.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                sIncrementText.setText(String.valueOf(ChartDialog.this.sIncrement.getSelection()) + " %");
            }
        });
        sIncrementText.setText(String.valueOf(this.sIncrement.getSelection()) + " %");
        this.lAxisMode = new Label(c, 0);
        this.lAxisMode.setText("Axis Mode:");
        gd1.applyTo((Control)this.lAxisMode);
        this.cAxisMode = new Combo(c, 2060);
        GridDataFactory.fillDefaults().indent(5, 0).span(1, 1).applyTo((Control)this.cAxisMode);
        this.cAxisMode.add("Single");
        this.cAxisMode.add("Multi");
        String _mode = this.data.axisMode == YAxisMode.SingleAxis ? "Single" : "Multi";
        this.cAxisMode.setText(_mode);
        GridDataFactory.fillDefaults().span(7, 1).applyTo((Control)new Label(c, 0));
        this.bMilestones = new Button(c, 32);
        this.bMilestones.setText("Show Milestones");
        this.bMilestones.setSelection(this.data.showMilestones);
        GridDataFactory.fillDefaults().span(9, 1).applyTo((Control)this.bMilestones);
        this.bTrackExperimentTime = new Button(c, 32);
        this.bTrackExperimentTime.setText("Hairline Tracks Experiment Time");
        this.bTrackExperimentTime.setSelection(this.data.trackExperimentTime);
        GridDataFactory.fillDefaults().span(9, 1).applyTo((Control)this.bTrackExperimentTime);
        Group gItemVisibility = new Group(c, 0);
        gItemVisibility.setText("Item Visibility");
        GridDataFactory.fillDefaults().indent(0, 5).span(9, 1).applyTo((Control)gItemVisibility);
        GridLayoutFactory.fillDefaults().margins(8, 8).numColumns(3).applyTo((Composite)gItemVisibility);
        Label visible = new Label((Composite)gItemVisibility, 0);
        visible.setText("Visible");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)visible);
        new Label((Composite)gItemVisibility, 0);
        Label hidden = new Label((Composite)gItemVisibility, 0);
        hidden.setText("Hidden");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)hidden);
        this.lVisibleItems = new ListViewer((Composite)gItemVisibility, 2050);
        GridDataFactory.fillDefaults().hint(200, 200).grab(true, true).applyTo(this.lVisibleItems.getControl());
        Composite addRemoveButtons = new Composite((Composite)gItemVisibility, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(addRemoveButtons);
        GridDataFactory.fillDefaults().grab(false, true).span(1, 1).applyTo((Control)addRemoveButtons);
        Button hideButton = new Button(addRemoveButtons, 8);
        hideButton.setText("Hide \u2192");
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)hideButton);
        Button showButton = new Button(addRemoveButtons, 8);
        showButton.setText("\u2190 Show");
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)showButton);
        this.lHiddenItems = new ListViewer((Composite)gItemVisibility, 2050);
        GridDataFactory.fillDefaults().hint(200, 200).grab(true, true).applyTo(this.lHiddenItems.getControl());
        this.lVisibleItems.setContentProvider((IContentProvider)new ArrayContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList<NamedResource> result = new ArrayList<NamedResource>();
                for (NamedResource item : ChartDialog.this.data.allItems.keySet()) {
                    if (ChartDialog.this.data.hiddenItems.contains(item)) continue;
                    result.add(item);
                }
                return result.toArray();
            }
        });
        this.lHiddenItems.setContentProvider((IContentProvider)new ArrayContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList<NamedResource> result = new ArrayList<NamedResource>();
                for (NamedResource item : ChartDialog.this.data.allItems.keySet()) {
                    if (!ChartDialog.this.data.hiddenItems.contains(item)) continue;
                    result.add(item);
                }
                return result.toArray();
            }
        });
        this.lVisibleItems.setLabelProvider((IBaseLabelProvider)new ItemLabeler());
        this.lHiddenItems.setLabelProvider((IBaseLabelProvider)new ItemLabeler());
        this.lVisibleItems.setInput((Object)this.data);
        this.lHiddenItems.setInput((Object)this.data);
        showButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Set selected = ISelectionUtils.filterSetSelection((Object)ChartDialog.this.lHiddenItems.getSelection(), NamedResource.class);
                if (!selected.isEmpty()) {
                    ChartDialog.this.data.hiddenItems.removeAll(selected);
                    ChartDialog.this.lVisibleItems.refresh();
                    ChartDialog.this.lHiddenItems.refresh();
                }
            }
        });
        hideButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Set selected = ISelectionUtils.filterSetSelection((Object)ChartDialog.this.lVisibleItems.getSelection(), NamedResource.class);
                if (!selected.isEmpty()) {
                    ChartDialog.this.data.hiddenItems.addAll(selected);
                    ChartDialog.this.lVisibleItems.refresh();
                    ChartDialog.this.lHiddenItems.refresh();
                }
            }
        });
        Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        this.tStartTimeDecor = this.createDecoration((Control)this.tStartTime, 0x1004000, image);
        this.tLengthDecor = this.createDecoration((Control)this.tLength, 0x1004000, image);
        return c;
    }

    protected Double parseTime(Text text, boolean returnDefault, double defaultValue) {
        if (text == null) {
            return null;
        }
        String s = text.getText();
        Double time = ChartComposite.START_VALIDATOR.parse(s);
        if (time == null) {
            return returnDefault ? Double.valueOf(defaultValue) : null;
        }
        return time;
    }

    protected ControlDecoration createDecoration(Control control, int position, Image image) {
        ControlDecoration d = new ControlDecoration(control, position);
        d.setMarginWidth(2);
        d.setImage(image);
        d.hide();
        return d;
    }

    protected void okPressed() {
        this.data.name = this.tName.getText();
        this.data.showMilestones = this.bMilestones.getSelection();
        this.data.trackExperimentTime = this.bTrackExperimentTime.getSelection();
        this.data.axisMode = this.cAxisMode.getSelectionIndex() == 0 ? YAxisMode.SingleAxis : YAxisMode.MultiAxis;
        this.data.timeIncrement = this.sIncrement.getSelection();
        this.data.timeLength = ChartComposite.LENGTH_VALIDATOR.parse(this.tLength.getText());
        this.data.timeStart = ChartComposite.START_VALIDATOR.parse(this.tStartTime.getText());
        super.okPressed();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Edit chart");
    }

    public void validate() {
        String startTimeError = ChartComposite.START_VALIDATOR.isValid(this.tStartTime.getText());
        String lengthError = ChartComposite.LENGTH_VALIDATOR.isValid(this.tLength.getText());
        this.setDecoration(this.tStartTimeDecor, startTimeError);
        this.setDecoration(this.tLengthDecor, lengthError);
        boolean ok = startTimeError == null && lengthError == null;
        this.setFinishable(ok);
    }

    private void setDecoration(ControlDecoration decor, String desc) {
        if (decor == null) {
            return;
        }
        if (desc != null) {
            decor.setDescriptionText(desc);
            decor.show();
        } else {
            decor.hide();
        }
    }

    protected void setFinishable(boolean ok) {
        this.getButton(0).setEnabled(ok);
    }

    class ItemLabeler
    extends LabelProvider {
        ItemLabeler() {
        }

        public String getText(Object element) {
            NamedResource item = (NamedResource)element;
            TrendItem ti = ChartDialog.this.data.allItems.get(item);
            return ti.label;
        }
    }
}

