/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.ui;

import java.awt.Color;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.simantics.charts.query.ChartAndSubscriptionItemData;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.trend.configuration.Scale;
import org.simantics.trend.configuration.TrendItem;
import org.simantics.trend.impl.JarisPaints;

public class ChartAndSubscriptionItemDialog
extends Dialog {
    private static final String MANUAL = "Manual";
    private static final String AUTO = "Auto";
    Label lChart;
    Label lRVI;
    Label lLabel;
    Label lDrawMode;
    Label lScale;
    Label lMin;
    Label lMax;
    Label lSubscription;
    Label lDeadband;
    Label lInterval;
    Label lGain;
    Label lBias;
    Label lUnit;
    Text tRVI;
    Text tLabel;
    Text tDeadband;
    Text tInterval;
    Text tGain;
    Text tBias;
    Text tUnit;
    Combo cSubscription;
    Button saveAsPrefs;
    Text tChart;
    Text tMin;
    Text tMax;
    Combo cDrawMode;
    Combo cScale;
    Spinner sStrokeWidth;
    ColorSelector colorSelector;
    ControlDecoration tMinDecor;
    ControlDecoration tMaxDecor;
    ControlDecoration tDeadbandDecor;
    ControlDecoration tIntervalDecor;
    ControlDecoration tGainDecor;
    ControlDecoration tBiasDecor;
    ChartAndSubscriptionItemData data;
    IEclipsePreferences chartnode;
    IEclipsePreferences subscriptionnode;
    boolean includeChartSpecificProperties;

    public ChartAndSubscriptionItemDialog(Shell parentShell, ChartAndSubscriptionItemData data, boolean includeChartSpecificProperties) {
        super(parentShell);
        this.data = data;
        this.includeChartSpecificProperties = includeChartSpecificProperties;
        if (includeChartSpecificProperties) {
            this.chartnode = InstanceScope.INSTANCE.getNode("org.simantics.charts");
        }
        this.subscriptionnode = InstanceScope.INSTANCE.getNode("org.simantics.modeling");
        this.setShellStyle(2160);
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        this.validate();
        return c;
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.fillDefaults().margins(8, 8).numColumns(9).applyTo(c);
        GridDataFactory gd1 = GridDataFactory.fillDefaults().align(4, 0x1000000).span(1, 1);
        GridDataFactory gd2 = GridDataFactory.fillDefaults().grab(true, false).indent(5, 0).span(8, 1);
        if (this.includeChartSpecificProperties) {
            this.lChart = new Label(c, 0);
            this.lChart.setText("Chart:");
            gd1.applyTo((Control)this.lChart);
            this.tChart = new Text(c, 2056);
            if (this.data.chartName != null) {
                this.tChart.setText(this.data.chartName);
            }
            gd2.applyTo((Control)this.tChart);
        }
        this.lRVI = new Label(c, 0);
        this.lRVI.setText("Variable: ");
        gd1.applyTo((Control)this.lRVI);
        this.tRVI = new Text(c, 2056);
        if (this.data.variableReference != null) {
            this.tRVI.setText(URIStringUtils.unescape((String)this.data.variableReference));
        }
        gd2.applyTo((Control)this.tRVI);
        this.lLabel = new Label(c, 0);
        this.lLabel.setText("&Label: ");
        gd1.applyTo((Control)this.lLabel);
        this.tLabel = new Text(c, 2048);
        if (this.data.label != null) {
            this.tLabel.setText(this.data.label);
        }
        gd2.applyTo((Control)this.tLabel);
        if (!this.data.binaryMode && this.includeChartSpecificProperties) {
            this.lScale = new Label(c, 0);
            this.lScale.setText("&Scale: ");
            gd1.applyTo((Control)this.lScale);
            Composite scaleComposite = new Composite(c, 0);
            gd2.applyTo((Control)scaleComposite);
            GridLayoutFactory.fillDefaults().numColumns(8).applyTo(scaleComposite);
            this.cScale = new Combo(scaleComposite, 2060);
            this.cScale.add(AUTO);
            this.cScale.add(MANUAL);
            String _scale = this.data.scale != null ? this.data.scale.toString() : this.chartnode.get("chart.scalemode", AUTO);
            this.cScale.setText(_scale);
            GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.cScale);
            this.lMin = new Label(scaleComposite, 0);
            this.lMin.setText("&Min: ");
            GridDataFactory.fillDefaults().span(1, 1).align(4, 0x1000000).applyTo((Control)this.lMin);
            this.tMin = new Text(scaleComposite, 2048);
            Double _min = this.data.min;
            if (_min == null) {
                _min = this.chartnode.getDouble("chart.scale.min", 0.0);
            }
            this.tMin.setText(Double.toString(_min));
            GridDataFactory.fillDefaults().hint(80, -1).indent(5, 0).grab(true, false).span(2, 1).applyTo((Control)this.tMin);
            this.tMin.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ChartAndSubscriptionItemDialog.this.data.min = ChartAndSubscriptionItemDialog.this.parseDouble(ChartAndSubscriptionItemDialog.this.tMin, false, 0.0);
                    if (ChartAndSubscriptionItemDialog.this.data.min != null) {
                        ChartAndSubscriptionItemDialog.this.cScale.setText(ChartAndSubscriptionItemDialog.MANUAL);
                    }
                    ChartAndSubscriptionItemDialog.this.validate();
                }
            });
            this.lMax = new Label(scaleComposite, 0);
            this.lMax.setText("Ma&x: ");
            GridDataFactory.fillDefaults().span(1, 1).align(4, 0x1000000).applyTo((Control)this.lMax);
            this.tMax = new Text(scaleComposite, 2048);
            Double _max = this.data.max;
            if (_max == null) {
                _max = this.chartnode.getDouble("chart.scale.max", 100.0);
            }
            this.tMax.setText(Double.toString(_max));
            GridDataFactory.fillDefaults().hint(80, -1).indent(5, 0).grab(true, false).span(2, 1).applyTo((Control)this.tMax);
            this.tMax.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ChartAndSubscriptionItemDialog.this.data.max = ChartAndSubscriptionItemDialog.this.parseDouble(ChartAndSubscriptionItemDialog.this.tMax, false, 100.0);
                    if (ChartAndSubscriptionItemDialog.this.data.max != null) {
                        ChartAndSubscriptionItemDialog.this.cScale.setText(ChartAndSubscriptionItemDialog.MANUAL);
                    }
                    ChartAndSubscriptionItemDialog.this.validate();
                }
            });
        }
        this.lSubscription = new Label(c, 0);
        this.lSubscription.setText("S&ubscription: ");
        gd1.applyTo((Control)this.lSubscription);
        this.cSubscription = new Combo(c, 2048);
        String[] stringArray = this.data.subscriptions;
        int _min = this.data.subscriptions.length;
        int _scale = 0;
        while (_scale < _min) {
            String s = stringArray[_scale];
            this.cSubscription.add(s);
            ++_scale;
        }
        gd2.applyTo((Control)this.cSubscription);
        String _subscription = this.data.subscription;
        if (_subscription == null) {
            _subscription = this.subscriptionnode.get("subscriptionitem.subscription", this.data.subscriptions.length == 0 ? "Default" : this.cSubscription.getItem(0));
        }
        this.cSubscription.setText(_subscription);
        if (!this.data.binaryMode) {
            this.lDeadband = new Label(c, 0);
            this.lDeadband.setText("&Deadband: ");
            gd1.applyTo((Control)this.lDeadband);
            this.tDeadband = new Text(c, 2048);
            Double _deadband = this.data.deadband;
            if (_deadband == null) {
                _deadband = this.subscriptionnode.getDouble("subscriptionitem.deadband", 0.0);
            }
            this.tDeadband.setText(Double.toString(_deadband));
            this.tDeadband.setEditable(this.data.mutableCollectionSettings);
            GridDataFactory.fillDefaults().hint(110, -1).indent(5, 0).span(3, 1).applyTo((Control)this.tDeadband);
            this.tDeadband.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ChartAndSubscriptionItemDialog.this.data.deadband = ChartAndSubscriptionItemDialog.this.parseDouble(ChartAndSubscriptionItemDialog.this.tDeadband, false, 0.0);
                    ChartAndSubscriptionItemDialog.this.validate();
                }
            });
            this.lInterval = new Label(c, 0);
            this.lInterval.setText("&Interval: ");
            this.lInterval.setToolTipText("Sampling Interval");
            GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.lInterval);
            this.tInterval = new Text(c, 2048);
            Double _interval = this.data.interval;
            if (_interval == null) {
                _interval = this.subscriptionnode.getDouble("subscriptionitem.interval", 0.0);
            }
            this.tInterval.setText(Double.toString(_interval));
            this.tInterval.setEditable(this.data.mutableCollectionSettings);
            GridDataFactory.fillDefaults().hint(110, -1).indent(5, 0).span(3, 1).applyTo((Control)this.tInterval);
            this.tInterval.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ChartAndSubscriptionItemDialog.this.data.interval = ChartAndSubscriptionItemDialog.this.parseDouble(ChartAndSubscriptionItemDialog.this.tInterval, false, 0.0);
                    ChartAndSubscriptionItemDialog.this.validate();
                }
            });
        }
        if (!this.data.binaryMode) {
            this.lGain = new Label(c, 0);
            this.lGain.setText("&Gain: ");
            gd1.applyTo((Control)this.lGain);
            this.tGain = new Text(c, 2048);
            Double _gain = this.data.gain;
            if (_gain == null) {
                _gain = this.subscriptionnode.getDouble("subscriptionitem.gain", 1.0);
            }
            this.tGain.setText(Double.toString(_gain));
            GridDataFactory.fillDefaults().hint(110, -1).indent(5, 0).span(3, 1).applyTo((Control)this.tGain);
            this.tGain.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ChartAndSubscriptionItemDialog.this.data.gain = ChartAndSubscriptionItemDialog.this.parseDouble(ChartAndSubscriptionItemDialog.this.tGain, false, 1.0);
                    ChartAndSubscriptionItemDialog.this.validate();
                }
            });
            this.lBias = new Label(c, 0);
            this.lBias.setText("&Bias: ");
            GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.lBias);
            this.tBias = new Text(c, 2048);
            Double _bias = this.data.bias;
            if (_bias == null) {
                _bias = this.subscriptionnode.getDouble("subscriptionitem.bias", 0.0);
            }
            this.tBias.setText(Double.toString(_bias));
            GridDataFactory.fillDefaults().hint(110, -1).indent(5, 0).span(3, 1).applyTo((Control)this.tBias);
            this.tBias.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ChartAndSubscriptionItemDialog.this.data.bias = ChartAndSubscriptionItemDialog.this.parseDouble(ChartAndSubscriptionItemDialog.this.tBias, false, 0.0);
                    ChartAndSubscriptionItemDialog.this.validate();
                }
            });
        }
        if (!this.data.binaryMode) {
            this.lUnit = new Label(c, 0);
            this.lUnit.setText("U&nit: ");
            gd1.applyTo((Control)this.lUnit);
            this.tUnit = new Text(c, 2048);
            String _unit = this.data.unit;
            if (_unit == null) {
                _unit = this.subscriptionnode.get("subscriptionitem.unit", "");
            }
            this.tUnit.setText(_unit);
            GridDataFactory.fillDefaults().hint(100, -1).indent(5, 0).span(3, 1).applyTo((Control)this.tUnit);
            GridDataFactory.fillDefaults().span(5, 1).applyTo((Control)new Label(c, 0));
        }
        if (!this.data.hasSubscriptionItem) {
            this.tLabel.setEnabled(false);
            this.cSubscription.setEnabled(false);
            this.tDeadband.setEnabled(false);
            this.tInterval.setEnabled(false);
            this.tGain.setEnabled(false);
            this.tBias.setEnabled(false);
            this.tUnit.setEnabled(false);
        }
        if (this.includeChartSpecificProperties) {
            this.createStrokeGroup(c);
        }
        this.saveAsPrefs = new Button(c, 32);
        this.saveAsPrefs.setText("Sav&e as new defaults");
        this.saveAsPrefs.setToolTipText("Sav&e these settings as new defaults");
        this.saveAsPrefs.setSelection(false);
        GridDataFactory.fillDefaults().hint(100, -1).span(9, 1).applyTo((Control)this.saveAsPrefs);
        Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        if (!this.data.binaryMode) {
            if (this.includeChartSpecificProperties) {
                this.tMinDecor = this.createDecoration((Control)this.tMin, 0x1004000, image);
                this.tMaxDecor = this.createDecoration((Control)this.tMax, 0x1004000, image);
            }
            this.tDeadbandDecor = this.createDecoration((Control)this.tDeadband, 0x1004000, image);
            this.tIntervalDecor = this.createDecoration((Control)this.tInterval, 0x1004000, image);
            this.tGainDecor = this.createDecoration((Control)this.tGain, 0x1004000, image);
            this.tBiasDecor = this.createDecoration((Control)this.tBias, 0x1004000, image);
        }
        this.parseUiToData();
        return c;
    }

    private void createStrokeGroup(Composite c) {
        GridDataFactory gd1 = GridDataFactory.fillDefaults().indent(10, 0).align(4, 0x1000000).span(1, 1);
        Group gStroke = new Group(c, 0);
        gStroke.setText("Trend Line Stroke");
        GridLayoutFactory.fillDefaults().margins(8, 8).spacing(10, 10).numColumns(5).applyTo((Composite)gStroke);
        GridDataFactory.fillDefaults().span(9, 1).applyTo((Control)gStroke);
        Label lStrokeWidth = new Label((Composite)gStroke, 0);
        lStrokeWidth.setText("&Width:");
        gd1.applyTo((Control)lStrokeWidth);
        this.sStrokeWidth = new Spinner((Composite)gStroke, 2048);
        this.sStrokeWidth.setDigits(1);
        this.sStrokeWidth.setIncrement(5);
        this.sStrokeWidth.setMinimum(10);
        this.sStrokeWidth.setMaximum(50);
        GridDataFactory.fillDefaults().indent(10, 0).grab(false, false).span(1, 1).applyTo((Control)this.sStrokeWidth);
        if (this.data.strokeWidth != null) {
            this.sStrokeWidth.setSelection((int)(this.data.strokeWidth.floatValue() * 10.0f));
        }
        this.sStrokeWidth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                float newWidth = (float)ChartAndSubscriptionItemDialog.this.sStrokeWidth.getSelection() * 0.1f;
                ChartAndSubscriptionItemDialog.this.data.strokeWidth = Float.valueOf(newWidth);
            }
        });
        Label lColor = new Label((Composite)gStroke, 0);
        lColor.setText("&Color: ");
        gd1.applyTo((Control)lColor);
        this.colorSelector = new ColorSelector((Composite)gStroke);
        GridDataFactory.fillDefaults().indent(10, 0).span(1, 1).grab(false, false).applyTo((Control)this.colorSelector.getButton());
        final RGB indexColor = this.toRGB(JarisPaints.getColor((int)this.data.index));
        RGB customColor = this.data.color != null ? this.toRGB(this.data.color) : indexColor;
        this.colorSelector.setColorValue(customColor);
        final Button bResetColor = new Button((Composite)gStroke, 8);
        bResetColor.setText("Reset Color");
        bResetColor.setToolTipText("Reset Color to Item Index Default");
        bResetColor.setEnabled(!indexColor.equals((Object)customColor));
        this.colorSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                RGB rgb = ChartAndSubscriptionItemDialog.this.colorSelector.getColorValue();
                ChartAndSubscriptionItemDialog.this.data.color = new Color(rgb.red, rgb.green, rgb.blue).getColorComponents(new float[4]);
                ChartAndSubscriptionItemDialog.this.data.color[3] = 1.0f;
                bResetColor.setEnabled(!indexColor.equals((Object)rgb));
            }
        });
        bResetColor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartAndSubscriptionItemDialog.this.data.color = null;
                ChartAndSubscriptionItemDialog.this.colorSelector.setColorValue(ChartAndSubscriptionItemDialog.this.toRGB(JarisPaints.getColor((int)ChartAndSubscriptionItemDialog.this.data.index)));
                bResetColor.setEnabled(false);
            }
        });
    }

    protected RGB toRGB(float[] color) {
        float r = color[0];
        float g = color[1];
        float b = color[2];
        return new RGB((int)((double)(r * 255.0f) + 0.5), (int)((double)(g * 255.0f) + 0.5), (int)((double)(b * 255.0f) + 0.5));
    }

    protected RGB toRGB(Color color) {
        return new RGB(color.getRed(), color.getGreen(), color.getBlue());
    }

    protected ControlDecoration createDecoration(Control control, int position, Image image) {
        ControlDecoration d = new ControlDecoration(control, position);
        d.setMarginWidth(2);
        d.setImage(image);
        d.hide();
        return d;
    }

    protected Double parseDouble(Text text, boolean returnDefault, double defaultValue) {
        if (text == null) {
            return null;
        }
        try {
            String s = text.getText();
            s = s.replace(',', '.');
            return Double.valueOf(s);
        }
        catch (NumberFormatException nfe) {
            return returnDefault ? Double.valueOf(defaultValue) : null;
        }
    }

    protected void parseUiToData() {
        this.data.label = this.tLabel.getText();
        if (!this.data.binaryMode) {
            if (this.includeChartSpecificProperties) {
                this.data.min = this.parseDouble(this.tMin, true, 0.0);
                this.data.max = this.parseDouble(this.tMax, true, 100.0);
            }
            this.data.interval = this.parseDouble(this.tInterval, true, 0.0);
            this.data.deadband = this.parseDouble(this.tDeadband, true, 0.0);
            this.data.gain = this.parseDouble(this.tGain, true, 1.0);
            this.data.bias = this.parseDouble(this.tBias, true, 0.0);
            this.data.unit = this.tUnit.getText();
            if (this.includeChartSpecificProperties) {
                this.data.drawmode = TrendItem.DrawMode.Line;
                if (this.cScale.getText().equals(MANUAL)) {
                    this.data.scale = new Scale.Manual(this.data.min.doubleValue(), this.data.max.doubleValue());
                } else if (this.cScale.getText().equals(AUTO)) {
                    this.data.scale = new Scale.Auto();
                }
            }
        }
    }

    protected void okPressed() {
        boolean savePrefs = this.saveAsPrefs.getSelection();
        this.parseUiToData();
        if (!this.data.binaryMode && savePrefs) {
            if (this.includeChartSpecificProperties) {
                this.chartnode.put("chart.drawmode", this.data.drawmode.name());
                this.chartnode.put("chart.scalemode", this.data.scale instanceof Scale.Manual ? MANUAL : AUTO);
                this.chartnode.putDouble("chart.scale.min", this.data.min.doubleValue());
                this.chartnode.putDouble("chart.scale.max", this.data.max.doubleValue());
            }
            this.subscriptionnode.putDouble("subscriptionitem.deadband", this.data.deadband.doubleValue());
            this.subscriptionnode.putDouble("subscriptionitem.interval", this.data.interval.doubleValue());
            this.subscriptionnode.putDouble("subscriptionitem.gain", this.data.gain.doubleValue());
            this.subscriptionnode.putDouble("subscriptionitem.bias", this.data.bias.doubleValue());
            this.subscriptionnode.put("subscriptionitem.unit", this.data.unit);
        }
        this.data.subscription = this.cSubscription.getText();
        if (savePrefs) {
            this.subscriptionnode.put("subscriptionitem.subscription", this.data.subscription);
        }
        super.okPressed();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.includeChartSpecificProperties ? "Edit variable to chart and subscription item" : "Edit variable to subscription item");
    }

    public void validate() {
        boolean ok = true;
        if (!this.data.binaryMode) {
            if (this.includeChartSpecificProperties) {
                this.setDecoration(this.tMinDecor, null);
                this.setDecoration(this.tMaxDecor, null);
                if (this.tMin != null && this.tMax != null) {
                    if (this.data.min == null || this.data.max == null) {
                        ok = false;
                        if (this.data.min == null) {
                            this.setDecoration(this.tMinDecor, "Invalid non-numeric value");
                        }
                        if (this.data.max == null) {
                            this.setDecoration(this.tMaxDecor, "Invalid non-numeric value");
                        }
                    } else if (this.data.min >= this.data.max) {
                        this.setDecoration(this.tMinDecor, "Minimum value must be smaller than maximum value");
                        this.setDecoration(this.tMaxDecor, "Maximum value must be larger than minimum value");
                        ok = false;
                    }
                }
            }
            ok &= this.data.interval != null && this.data.deadband != null && this.data.bias != null && this.data.gain != null;
            this.setDecoration(this.tIntervalDecor, this.data.interval == null ? "Invalid non-numeric value" : null);
            if (this.data.interval != null && this.data.interval < 0.0) {
                this.setDecoration(this.tIntervalDecor, "Sampling interval cannot be negative");
            }
            this.setDecoration(this.tDeadbandDecor, this.data.deadband == null ? "Invalid non-numeric value" : null);
            if (this.data.deadband != null && this.data.deadband < 0.0) {
                this.setDecoration(this.tDeadbandDecor, "Deadband cannot be negative");
            }
            this.setDecoration(this.tGainDecor, this.data.gain == null ? "Invalid non-numeric value" : null);
            this.setDecoration(this.tBiasDecor, this.data.bias == null ? "Invalid non-numeric value" : null);
        }
        this.setFinishable(ok);
    }

    private void setDecoration(ControlDecoration decor, String desc) {
        if (decor == null) {
            return;
        }
        if (desc != null) {
            decor.setDescriptionText(desc);
            decor.show();
        } else {
            decor.hide();
        }
    }

    protected void setFinishable(boolean ok) {
        this.getButton(0).setEnabled(ok);
    }
}

