/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.ui;

import java.util.Collections;
import java.util.List;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.util.Bean;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleTypedParent;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.AsyncRead;
import org.simantics.history.HistoryException;
import org.simantics.history.HistoryManager;
import org.simantics.history.ItemManager;
import org.simantics.history.csv.CSVFormatter;
import org.simantics.history.util.subscription.SamplingFormat;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.subscription.SubscriptionItemLabel;
import org.simantics.simulation.ontology.SimulationResource;

class CSVParamsQuery
extends ReadRequest {
    CSVFormatter csv;
    List<Resource> subscriptionItems;
    ItemManager im;
    HistoryManager history;

    public CSVParamsQuery(HistoryManager history, CSVFormatter csv, List<Resource> subscriptionItems) throws HistoryException {
        this.csv = csv;
        this.subscriptionItems = subscriptionItems;
        this.history = history;
        this.im = new ItemManager(history.getItems());
    }

    public void run(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        SimulationResource SIM = SimulationResource.getInstance((ReadGraph)graph);
        for (Resource si : this.subscriptionItems) {
            String unit = (String)graph.getPossibleRelatedValue(si, MOD.Subscription_Item_Unit, (Binding)Bindings.STRING);
            String subscriptionItemLabel = (String)graph.getPossibleRelatedValue(si, L0.HasLabel, (Binding)Bindings.STRING);
            String label2 = null;
            String groupItemId = (String)graph.getPossibleRelatedValue(si, L0.HasName, (Binding)Bindings.STRING);
            if (groupItemId == null) continue;
            Binding rviBinding = ((Databoard)graph.getService(Databoard.class)).getBindingUnchecked(RVI.class);
            RVI rvi = (RVI)graph.getPossibleRelatedValue(si, MOD.Subscription_Item_VariableId, rviBinding);
            if (rvi != null) {
                Resource model = (Resource)graph.syncRequest((AsyncRead)new PossibleTypedParent(si, SIM.Model));
                Variable configuration = null;
                if (model != null) {
                    configuration = Variables.getConfigurationContext((ReadGraph)graph, (Resource)model);
                }
                if ((subscriptionItemLabel == null || subscriptionItemLabel.isEmpty()) && configuration != null) {
                    subscriptionItemLabel = rvi.asPossibleString(graph, configuration);
                    if (subscriptionItemLabel == null) {
                        subscriptionItemLabel = rvi.toPossibleString(graph, configuration);
                    }
                    if (subscriptionItemLabel != null) {
                        subscriptionItemLabel = SubscriptionItemLabel.removeVariablePrefixPath((String)subscriptionItemLabel);
                        subscriptionItemLabel = URIStringUtils.unescape((String)subscriptionItemLabel);
                    }
                }
                if (configuration != null) {
                    label2 = rvi.toPossibleString(graph, configuration);
                    if (label2 == null) continue;
                    label2 = URIStringUtils.unescape((String)label2);
                } else {
                    label2 = rvi.toString();
                }
            }
            try {
                List streams = this.im.search("groupItemId", (Object)groupItemId);
                Collections.sort(streams, SamplingFormat.INTERVAL_COMPARATOR);
                if (streams.isEmpty()) continue;
                Bean config = (Bean)streams.get(0);
                String id = (String)config.getFieldUnchecked("id");
                this.csv.addItem(this.history, id, subscriptionItemLabel, label2, unit);
            }
            catch (BindingException bindingException) {
                // empty catch block
            }
        }
    }
}

