/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.query;

import org.simantics.charts.ontology.ChartResource;
import org.simantics.charts.ui.ChartData;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.trend.configuration.YAxisMode;

public class ChartDataWrite
extends WriteRequest {
    ChartData data;
    Resource chart;

    public ChartDataWrite(Resource chart, ChartData data) {
        this.data = data;
        this.chart = chart;
    }

    public void perform(WriteGraph g) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        ChartResource CHART = ChartResource.getInstance((ReadGraph)g);
        g.claimLiteral(this.chart, L0.HasName, (Object)this.data.name, (Binding)Bindings.STRING);
        if (this.data.axisMode == YAxisMode.SingleAxis) {
            g.deny(this.chart, CHART.Chart_YAxisMode, CHART.YAxisMode_MultiAxis);
            g.claim(this.chart, CHART.Chart_YAxisMode, CHART.YAxisMode_SingleAxis);
        } else {
            g.deny(this.chart, CHART.Chart_YAxisMode, CHART.YAxisMode_SingleAxis);
            g.claim(this.chart, CHART.Chart_YAxisMode, CHART.YAxisMode_MultiAxis);
        }
        g.claimLiteral(this.chart, CHART.Chart_ShowMilestones, (Object)this.data.showMilestones, (Binding)Bindings.BOOLEAN);
        g.claimLiteral(this.chart, CHART.Chart_trackExperimentTime, (Object)this.data.trackExperimentTime, (Binding)Bindings.BOOLEAN);
        if (this.data.timeIncrement != null) {
            g.claimLiteral(this.chart, CHART.Chart_TimeWindowIncrement, (Object)this.data.timeIncrement, (Binding)Bindings.DOUBLE);
        } else {
            g.deny(this.chart, CHART.Chart_TimeWindowIncrement);
        }
        if (this.data.timeLength == null) {
            g.deny(this.chart, CHART.Chart_TimeWindowLength);
        } else {
            g.claimLiteral(this.chart, CHART.Chart_TimeWindowLength, (Object)this.data.timeLength, (Binding)Bindings.DOUBLE);
        }
        if (this.data.timeStart == null) {
            g.deny(this.chart, CHART.Chart_TimeWindowStart);
        } else {
            g.claimLiteral(this.chart, CHART.Chart_TimeWindowStart, (Object)this.data.timeStart, (Binding)Bindings.DOUBLE);
        }
        if (this.data.allItems != null && this.data.hiddenItems != null) {
            for (NamedResource item : this.data.allItems.keySet()) {
                Boolean isHidden;
                boolean shouldBeHidden = this.data.hiddenItems.contains(item);
                if (shouldBeHidden == (isHidden = (Boolean)g.getRelatedValue(item.getResource(), CHART.Chart_Item_hidden, (Binding)Bindings.BOOLEAN))) continue;
                g.claimLiteral(item.getResource(), CHART.Chart_Item_hidden, (Object)shouldBeHidden, (Binding)Bindings.BOOLEAN);
            }
        }
    }
}

