/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.query;

import java.util.Collection;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.charts.query.TrendItemQuery;
import org.simantics.charts.ui.ChartData;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.trend.configuration.TrendItem;
import org.simantics.trend.configuration.YAxisMode;

public class ChartDataQuery
extends ResourceRead<ChartData> {
    public ChartDataQuery(Resource resource) {
        super(resource);
    }

    public ChartData perform(ReadGraph g) throws DatabaseException {
        Boolean trackExperimentTime;
        Boolean showMilestones;
        Double start;
        Double length;
        Resource chart = this.resource;
        ChartData data = new ChartData();
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        ChartResource CHART = ChartResource.getInstance((ReadGraph)g);
        data.name = (String)g.getPossibleRelatedValue(chart, L0.HasName, (Binding)Bindings.STRING);
        Resource am = g.getSingleObject(chart, CHART.Chart_YAxisMode);
        data.axisMode = CHART.YAxisMode_SingleAxis.equals(am) ? YAxisMode.SingleAxis : (CHART.YAxisMode_MultiAxis.equals(am) ? YAxisMode.MultiAxis : YAxisMode.SingleAxis);
        Double increment = (Double)g.getPossibleRelatedAdapter(chart, CHART.Chart_TimeWindowIncrement, Double.class);
        if (increment != null) {
            data.timeIncrement = increment;
        }
        if ((length = (Double)g.getPossibleRelatedAdapter(chart, CHART.Chart_TimeWindowLength, Double.class)) != null) {
            data.timeLength = length;
        }
        if ((start = (Double)g.getPossibleRelatedAdapter(chart, CHART.Chart_TimeWindowStart, Double.class)) != null) {
            data.timeStart = start;
        }
        if ((showMilestones = (Boolean)g.getPossibleRelatedValue(chart, CHART.Chart_ShowMilestones, (Binding)Bindings.BOOLEAN)) != null) {
            data.showMilestones = showMilestones;
        }
        if ((trackExperimentTime = (Boolean)g.getPossibleRelatedValue(chart, CHART.Chart_trackExperimentTime, (Binding)Bindings.BOOLEAN)) != null) {
            data.trackExperimentTime = trackExperimentTime;
        }
        for (Resource chartItem : (Collection)g.syncRequest((Read)new ObjectsWithType(chart, L0.ConsistsOf, CHART.Chart_Item))) {
            TrendItem ti = (TrendItem)g.syncRequest((Read)new TrendItemQuery(chartItem));
            NamedResource nr = new NamedResource(ti.label, chartItem);
            data.allItems.put(nr, ti);
            Boolean hidden = (Boolean)g.getRelatedValue(chartItem, CHART.Chart_Item_hidden, (Binding)Bindings.BOOLEAN);
            if (!Boolean.TRUE.equals(hidden)) continue;
            data.hiddenItems.add(nr);
        }
        return data;
    }
}

