/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.editor;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.simantics.Simantics;
import org.simantics.charts.Activator;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.charts.query.SetProperty;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;

public class TrackExperimentTimeAction
extends Action {
    private Resource chart;
    private Boolean currentValue;

    public TrackExperimentTimeAction(String name, Resource chart, boolean currentValue) {
        super(name, 2);
        this.chart = chart;
        this.currentValue = currentValue;
        this.setChecked(currentValue);
    }

    public void run() {
        try {
            Session session = Simantics.getSession();
            ChartResource CHART = ChartResource.getInstance((RequestProcessor)session);
            session.markUndoPoint();
            session.syncRequest((Write)new SetProperty(this.chart, CHART.Chart_trackExperimentTime, this.currentValue == false, (Binding)Bindings.BOOLEAN));
        }
        catch (DatabaseException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.charts", "Failed to set track experiment time.", (Throwable)e));
        }
    }
}

