/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.Simantics;
import org.simantics.charts.Activator;
import org.simantics.charts.editor.TimeSeriesEditor;
import org.simantics.charts.query.AddChartItem;
import org.simantics.charts.query.ChartItemDescriptor;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.util.ClipboardUtils;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.g2d.canvas.ICanvasParticipant;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.modeling.ModelingResources;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.utils.datastructures.hints.IHintContext;

class ChartPasteHandler2
extends AbstractCanvasParticipant
implements ICanvasParticipant {
    TimeSeriesEditor editor;

    ChartPasteHandler2(TimeSeriesEditor e) {
        this.editor = e;
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleCommandEvent(CommandEvent e) {
        if (e.command == Commands.PASTE) {
            final ArrayList resources = new ArrayList();
            for (Set object : Simantics.getClipboard().getContents()) {
                try {
                    Collection rs = (Collection)ClipboardUtils.accept((Set)object, (IHintContext.Key)SimanticsKeys.KEY_COPY_RESOURCES);
                    if (rs == null) continue;
                    resources.addAll(rs);
                }
                catch (DatabaseException ex) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.charts", "Failed to retrieve clipboard contents.", (Throwable)ex));
                }
            }
            if (resources.isEmpty()) {
                return true;
            }
            Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    Resource chart;
                    Resource expectedModel = ChartPasteHandler2.this.editor.chartData.model;
                    Resource resource = chart = ChartPasteHandler2.this.editor.getResourceInput() != null ? ChartPasteHandler2.this.editor.getResourceInput().getResource() : null;
                    if (expectedModel == null || chart == null) {
                        return;
                    }
                    ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                    ArrayList<ChartItemDescriptor> refs = new ArrayList<ChartItemDescriptor>();
                    for (Resource r : resources) {
                        Resource model;
                        if (!graph.isInstanceOf(r, MOD.Subscription_Item) || !ObjectUtils.objectEquals((Object)expectedModel, (Object)(model = (Resource)graph.syncRequest((Read)new PossibleModel(r))))) continue;
                        refs.add(AddChartItem.createDescriptor((ReadGraph)graph, r));
                    }
                    if (!refs.isEmpty()) {
                        AddChartItem.addAndMoveChartItems(chart, refs, Collections.emptySet()).perform(graph);
                    }
                }
            });
            return true;
        }
        return false;
    }
}

