/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.editor;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.simantics.charts.editor.TimeInputValidator;
import org.simantics.utils.format.TimeFormat;

class AddMilestoneDialog
extends Dialog {
    IInputValidator timeValidator = new IInputValidator(){

        public String isValid(String text) {
            if (text.trim().isEmpty()) {
                return null;
            }
            return TimeInputValidator.INSTANCE.isValid(text);
        }
    };
    Label nameLabel;
    Label descLabel;
    Label timeLabel;
    Label baselineLabel;
    Text nameText;
    Text descText;
    Text timeText;
    Button baselineButt;
    double initialTime;
    String name;
    String desc;
    String time;
    boolean baseline;

    protected AddMilestoneDialog(Shell parentShell, double initialTime) {
        super(parentShell);
        this.initialTime = initialTime;
    }

    protected int getShellStyle() {
        return 2160;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Add new milestone");
    }

    protected Point getInitialSize() {
        Point result;
        Point defaultSize = this.getShell().computeSize(-1, -1, true);
        if (defaultSize.equals((Object)(result = super.getInitialSize()))) {
            return new Point(500, 250);
        }
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.fillDefaults().margins(8, 8).numColumns(4).applyTo(composite);
        GridDataFactory gd1 = GridDataFactory.fillDefaults().span(1, 1);
        GridDataFactory gd2 = GridDataFactory.fillDefaults().span(3, 1).grab(true, false);
        this.nameLabel = new Label(composite, 0);
        this.nameLabel.setText("Name:");
        gd1.applyTo((Control)this.nameLabel);
        this.nameText = new Text(composite, 2048);
        this.nameText.setText("My Milestone");
        gd2.applyTo((Control)this.nameText);
        this.descLabel = new Label(composite, 0);
        this.descLabel.setText("Description:");
        gd1.applyTo((Control)this.descLabel);
        this.descText = new Text(composite, 2048);
        gd2.applyTo((Control)this.descText);
        this.timeLabel = new Label(composite, 0);
        this.timeLabel.setText("Time:");
        gd1.applyTo((Control)this.timeLabel);
        this.timeText = new Text(composite, 2048);
        TimeFormat tf = new TimeFormat(this.initialTime, 3);
        String time = tf.format((Object)this.initialTime);
        this.timeText.setText(time);
        gd2.applyTo((Control)this.timeText);
        this.baselineLabel = new Label(composite, 0);
        this.baselineLabel.setText("Is baseline:");
        gd1.applyTo((Control)this.baselineLabel);
        this.baselineButt = new Button(composite, 32);
        return composite;
    }

    protected void okPressed() {
        this.name = this.nameText.getText();
        this.desc = this.descText.getText();
        this.time = this.timeText.getText();
        this.baseline = this.baselineButt.getSelection();
        super.okPressed();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getTime() {
        return this.time;
    }

    public boolean isBaseline() {
        return this.baseline;
    }
}

