/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.simantics.Simantics;
import org.simantics.charts.Activator;
import org.simantics.charts.Charts;
import org.simantics.charts.editor.ChartData;
import org.simantics.databoard.util.URIUtil;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.request.Read;
import org.simantics.history.History;
import org.simantics.history.HistoryException;
import org.simantics.history.HistoryManager;
import org.simantics.modeling.subscription.CollectSubscriptions;
import org.simantics.modeling.subscription.ModelHistoryCollector;
import org.simantics.modeling.subscription.SubscriptionCollectionResult;
import org.simantics.project.IProject;
import org.simantics.simulation.experiment.IDynamicExperiment;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.utils.FileUtils;
import org.simantics.utils.datastructures.Callable;

public class TrendSupport {
    private IDynamicExperiment experiment;
    private String workspaceDataDirectoryName;
    private ModelHistoryCollector historyCollector;
    private ChartData chartData;

    public TrendSupport(IDynamicExperiment experiment, String workspaceDataDirectoryName) {
        this.experiment = experiment;
        this.workspaceDataDirectoryName = workspaceDataDirectoryName;
    }

    public void initializeHistoryCollection(ReadGraph graph) throws DatabaseException {
        final IProject project = Simantics.peekProject();
        if (project == null) {
            return;
        }
        try {
            File workarea = this.getExperimentDirectory(graph, this.experiment.getResource(), true, "result-" + this.experiment.getIdentifier());
            final HistoryManager history = History.openFileHistory((File)workarea);
            this.historyCollector = ModelHistoryCollector.createCollector((IDynamicExperiment)this.experiment, (HistoryManager)history, (ILog)Activator.getDefault().getLog(), (Callable)new Callable<Read<SubscriptionCollectionResult>>(){

                public Read<SubscriptionCollectionResult> call() {
                    CollectSubscriptions cs = new CollectSubscriptions(TrendSupport.this.experiment.getModel(), TrendSupport.this.experiment);
                    cs.defaultSamplingInterval = 0.1;
                    cs.historyForIDCorrespondences = history;
                    return cs;
                }
            }, (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (TrendSupport.this.chartData != null) {
                        Charts.resetChartEditorData(project, TrendSupport.this.experiment.getModel(), TrendSupport.this.chartData);
                    }
                }
            });
            this.historyCollector.initialize((RequestProcessor)graph, 0.0, true);
            HistoryManager historyManager = History.openFileHistory((File)this.historyCollector.getWorkarea());
            this.chartData = new ChartData(this.experiment.getModel(), null, (IExperiment)this.experiment, this.experiment.getDatasource(), historyManager, this.historyCollector.getCollector());
            Charts.resetChartEditorData(project, this.experiment.getModel(), this.chartData);
        }
        catch (IOException e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (HistoryException e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public void dispose() {
        if (this.historyCollector != null) {
            this.historyCollector.dispose();
            this.historyCollector = null;
        }
        if (this.chartData != null) {
            IProject project = Simantics.peekProject();
            if (project != null) {
                Charts.resetChartEditorData(project, this.experiment.getModel(), null);
            }
            this.chartData = null;
        }
    }

    protected File getExperimentDirectory(ReadGraph g, Resource experiment, boolean ensureExistence, String ... subdirs) throws DatabaseException, IOException {
        Resource model = (Resource)g.syncRequest((Read)new PossibleModel(experiment));
        if (model == null) {
            throw new ValidationException("Experiment '" + NameUtils.getSafeName((ReadGraph)g, (Resource)experiment) + "' is not part of any model. Has the experiment been removed already? Database may also be corrupted?");
        }
        String[] dirs = new String[3 + subdirs.length];
        dirs[0] = this.workspaceDataDirectoryName;
        dirs[1] = "model-" + model.getResourceId();
        dirs[2] = "experiment-" + experiment.getResourceId();
        System.arraycopy(subdirs, 0, dirs, 3, subdirs.length);
        File experimentPath = TrendSupport.getWorkspacePath(false, dirs);
        if (ensureExistence) {
            TrendSupport.ensureDirectoryExistence(experimentPath);
        }
        return experimentPath;
    }

    protected static File ensureDirectoryExistence(File dir) throws IOException {
        if (dir.exists() && !dir.isDirectory()) {
            FileUtils.deleteAll((File)dir);
        }
        dir.mkdirs();
        if (!dir.exists() || !dir.isDirectory()) {
            throw new FileNotFoundException("Could not create directory '" + dir + "'. Out of disk space?");
        }
        return dir;
    }

    protected static File getWorkspacePath(boolean escapeNames, String ... relativeSegments) {
        IPath finalPath = Platform.getLocation();
        int i = 0;
        while (i < relativeSegments.length) {
            finalPath = finalPath.append(escapeNames ? URIUtil.encodeFilename((String)relativeSegments[i]) : relativeSegments[i]);
            ++i;
        }
        return finalPath.toFile();
    }
}

