/*******************************************************************************
 * Copyright (c) 2015 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.model.queries;

import java.util.Collections;

import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.model.actions.ActionBrowseContext;
import org.simantics.browsing.ui.model.browsecontexts.ActionBrowseContextRequest;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.project.ontology.ProjectResource;

/**
 * @author Tuukka Lehtonen
 * @since 1.18.1
 */
public class IsNodeContextModifiable extends UnaryRead<NodeContext, Boolean> {

    public IsNodeContextModifiable(NodeContext context) {
        super(context);
    }

    @Override
    public Boolean perform(ReadGraph graph) throws DatabaseException {
        ActionBrowseContext defaultContext = graph.syncRequest(
                new ActionBrowseContextRequest(Collections.singleton(ProjectResource.getInstance(graph).ProjectActionContext)),
                TransientCacheAsyncListener.<ActionBrowseContext>instance());
        ActionBrowseContext browseContext = ActionBrowseContext.get(graph, parameter, defaultContext);
        return browseContext != null && browseContext.canRename(graph, parameter);
    }

}
