/*******************************************************************************
 * Copyright (c) 2010, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.model.labels;

import java.util.Map;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.model.InvalidContribution;
import org.simantics.browsing.ui.model.nodetypes.NodeType;
import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.browsing.ui.model.visuals.VisualsContribution;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

/**
 * Produces labels for nodes of given node type.
 * @author Hannu Niemistö
 */
public class LabelContribution extends VisualsContribution {
    LabelRule labelRule;
    
    public LabelContribution(NodeType nodeType, Test test, LabelRule labelRule, double priority) throws InvalidContribution {
        super(nodeType, test, priority);
        if(!labelRule.isCompatible(
                nodeType.getContentType()
                ))
            throw new InvalidContribution("Label rule is not compatible with the content type.");
        this.labelRule = labelRule;
    }
       
    /**
     * Returns a label for the node or null, if contribution is
     * not suitable for the input.
     */
    public Map<String, String> getLabel(ReadGraph graph, NodeContext context) {
        Object content = context.getConstant(BuiltinKeys.INPUT);
        try {
            if(test == null || test.test(graph, content))            
                return labelRule.getLabel(graph, content);
            else
                return null;
        } catch(DatabaseException e) {
            ErrorLogger.defaultLogError(e);
        	//Logger.defaultLogError(e);
            // TODO reconsider
            return null;
        }
    }    
}
