/*******************************************************************************
 * Copyright (c) 2010, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.model.children;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.NoInverseException;

/**
 * A child rule that says that there is exactly one child node whose content 
 * is equal to the content of the parent.
 * @author Hannu Niemistö
 */
public class RelationChildRule implements ChildRule {

    Resource relation;
    Test test;
    
    public RelationChildRule(Resource relation, Test test) {
        this.relation = relation;
        this.test = test;
    }
    
    @Override
    public Collection<?> getChildren(ReadGraph graph, Object parent) throws DatabaseException {
        Collection<Resource> result = graph.getObjects((Resource)parent, relation);
        if(test != null) {
            ArrayList<Resource> filtered = new ArrayList<Resource>(result.size());
            for(Resource r : result)
                if(test.test(graph, r))
                    filtered.add(r); 
            result = filtered;
        }
        return result;
    }

    @Override
    public Collection<?> getParents(ReadGraph graph, Object child)
            throws DatabaseException {
        try {
            if(child instanceof Resource) {
                Resource inverse = graph.getInverse(relation);            
                return graph.getObjects((Resource)child, inverse);
            }
        } catch(NoInverseException e) {
        }   
        return Collections.emptyList();
    }
    
    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }
}
