package org.simantics.browsing.ui.model.browsecontexts;

import java.util.Collection;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.model.actions.ActionBrowseContext;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;

public class ResolveActionBrowseContext extends UnaryRead<NodeContext,ActionBrowseContext> {

    public ResolveActionBrowseContext(NodeContext parameter) {
        super(parameter);
    }

    private Resource getPossibleResource(ReadGraph graph) throws DatabaseException {
        Object input = parameter.getConstant(BuiltinKeys.INPUT);
        if(input instanceof Resource) return (Resource)input;
        else if (input instanceof Variable) return ((Variable)input).getPossibleRepresents(graph);
        else return null;
    }
    
    @Override
    public ActionBrowseContext perform(ReadGraph graph) throws DatabaseException {
        
        Resource resource = getPossibleResource(graph);
        if(resource == null) return null;
        
        Resource indexRoot = graph.syncRequest(new PossibleIndexRoot(resource));
        if(indexRoot == null) return null;

        Collection<Resource> contexts = graph.syncRequest(new ContributedActionBrowseContexts(indexRoot, resource));
        
        if(contexts.isEmpty()) return null;
        
        return graph.syncRequest(new ActionBrowseContextRequest(contexts));
        
    }

}
