package org.simantics.browsing.ui.model.browsecontexts;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead2;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.viewpoint.ontology.ViewpointResource;

public class ContributedActionBrowseContexts extends ResourceRead2<Collection<Resource>> {

    public ContributedActionBrowseContexts(Resource indexRoot, Resource context) {
        super(indexRoot, context);
    }

    @Override
    public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
        
        ViewpointResource VP = ViewpointResource.getInstance(graph);
        Instances query = graph.adapt(VP.ActionBrowseContextContribution, Instances.class);
        Collection<Resource> result = new ArrayList<Resource>();
        for(Resource contribution : query.find(graph, resource)) {
            Resource type = graph.getPossibleObject(contribution, VP.ActionBrowseContextContribution_HasType);
            if(type == null) continue;
            if(graph.isInstanceOf(resource2, type)) {
                Resource context = graph.getPossibleObject(contribution, VP.ActionBrowseContextContribution_HasActionBrowseContext);
                if(context == null) continue;
                result.add(context);
            }
        }
        return result;
        
    }

}
